#include <nitro.h>
#include <isdbglib.h>
#include "comm.h"

#define MAX_QUEUE_NUM (1024*2)			// Queuet̃bZ[Wł悤ȂA̕ӂ𒲐
#define MAX_SEND_SIZE (8192)			// 8Kȏ̓n[h̐ŏoȂ̂Œ

static void comm_init(void);
static BOOL comm_send(const MemInfo *data);
static void comm_loop(void);
static void comm_recv( u32 dwUser, u32 nChn, const void *pAdrs, u32 nSize );

static BOOL isSession = FALSE;
static BOOL isInit = FALSE;
static MemInfo sendQueue[MAX_QUEUE_NUM];
static u32 queueHead  = 0;		// Queuê
static u32 queueTail  = 0;		// Queuê
static u32 queueNum   = 0;		// ܂ĂQueue̐
static u32 sendNum	  = 0;		// MQueue̐
static unsigned long		s_nToolAPIResource = FALSE;
static CommFunc				s_comm_func = {
	comm_init, comm_send, comm_loop
};

const CommFunc *get_is_debugger_func(void)
{
	return &s_comm_func;
}

static void comm_init(void)
{
	const struct tagNITRODEVCAPS*	pDevice;
	int		total;

	// c[API܂
	NITROToolAPIInit( );

	total = NITROToolAPIGetMaxCaps( );
	if( !total ) {
		OS_TPrintf("foCX܂ł\n" );
		return;
	}

	pDevice = NITROToolAPIGetDeviceCaps( 0 );
	if( !NITROToolAPIOpen( pDevice ) ){
		// foCXJ܂ł
		OS_TPrintf("foCXJ܂ł\n" );
		return;
	}

	switch( pDevice->m_nDeviceID ){
		case NITRODEVID_CGBEMULATOR:
			OS_TPrintf("Device IS-CGB-EMULATOR open succeeded.\n" );
			break;
		case NITRODEVID_NITEMULATOR:
			OS_TPrintf("Device IS-NITRO-EMULATOR open succeeded.\n" );
			break;
		case NITRODEVID_NITUIC:
			OS_TPrintf("Device IS-NITRO-UIC open succeeded.\n" );
			break;
		default:
			OS_TPrintf("Device UNKNOWN open succeeded.\n" );
			break;
	}

	// f[^M̃R[obNo^܂
	(void)NITROToolAPISetReceiveStreamCallBackFunction( comm_recv, 0 );
	s_nToolAPIResource = pDevice->m_dwMaskResource;
	isInit = TRUE;
}

static BOOL comm_send(const MemInfo *data)
{
	if(isInit)
	{
		if(queueNum != MAX_QUEUE_NUM)
		{
			sendQueue[queueTail] = *data;
			queueTail++;
			if (queueTail == MAX_QUEUE_NUM)
				queueTail = 0;
			queueNum++;
			//OS_TPrintf("ML[ɓo^[%d/%d]\n",queueNum, MAX_QUEUE_NUM);
			return TRUE;
		}
		else
		{
			OS_TPrintf("ML[ς̂ŃL[ɓo^ł܂ł\n");
			return FALSE;
		}
	}
	else
	{
		OS_TPrintf("ĂłȂƑMł܂\n");
		return FALSE;
	}
}

static void comm_loop(void)
{
	if(!isSession)	// MłȂΑM
	{
		if(queueNum > 0)		// L[ۂłȂΑM
		{
			isSession = TRUE;

			//܂L[ɑM悤ɕύX->Ƃ͂ASď̂2񂩂ꍇ
			if(queueHead < queueTail)	// ʏ
			{
				sendNum = queueNum;
				if(sizeof(MemInfo)*sendNum > MAX_SEND_SIZE)
					sendNum = MAX_SEND_SIZE / sizeof(MemInfo);
				(void)NITROToolAPIWriteStream(0, &sendQueue[queueHead], sizeof(MemInfo) * sendNum);
			}
			else						// TailƉČɂĂ遨ĂĂ镪͎őM
			{
				sendNum = MAX_QUEUE_NUM - queueHead;
				if(sizeof(MemInfo)*sendNum > MAX_SEND_SIZE)
					sendNum = MAX_SEND_SIZE / sizeof(MemInfo);
				(void)NITROToolAPIWriteStream(0, &sendQueue[queueHead], sizeof(MemInfo) * sendNum);
			}
		}
	}

	//	ToolAPIɑ΂|[O
	if( s_nToolAPIResource & NITROMASK_RESOURCE_POLL ) {
		// C[vŌpČĂԕKv܂
		NITROToolAPIPollingIdle();
	}
}

static void comm_recv( u32 dwUser, u32 nChn, const void *pAdrs, u32 nSize )
{
	(void)dwUser;
	(void)pAdrs;
	(void)nSize;
	(void)nChn;

	queueHead += sendNum;
	if(queueHead >= MAX_QUEUE_NUM)
		queueHead -= MAX_QUEUE_NUM;
	
	queueNum -= sendNum;
	sendNum = 0;

	isSession = FALSE;
}
