//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "BreakUnit.h"
#include "memSnatcher.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "MyStringGrid"
#pragma link "MyStringGrid"
#pragma resource "*.dfm"
TBreakForm *BreakForm;

HWND		TBreakForm::m_TempParent = NULL;

enum                    // StringGridnoe̍
{
    COL_ID = 0,
    COL_ADDR,
    COL_HEAP,
    COL_LINE,
    COL_COUNT
};
enum{                   // cvs̊e̍
    CVS_ADDR = 0,
    CVS_HEAP,
    CVS_LINE,
    CVS_COUNT,
    CVS_ENABLE,
    CVS_ENEBLE_ADDR,
    CVS_ENABLE_HEAP,
    CVS_ENABLE_LINE,
    CVS_ENABLE_COUNT
};

//---------------------------------------------------------------------------
__fastcall TBreakForm::TBreakForm(TComponent* Owner)
    : TForm(Owner) , currentBreakID(0)
{
    InitFormComponent();
}
//---------------------------------------------------------------------------

void __fastcall TBreakForm::CreateParams(Controls::TCreateParams &Params)
{
	TForm::CreateParams(Params);
	if (m_TempParent) {
		Params.WndParent = m_TempParent;
	}
}

/*---------------------------------------------
// Funct Name : Init
// arg1       : OANZXC^[tF[XCX^Xւ̃|C^
// arg2       : BreakInfot@CpX
// ex         : 
//---------------------------------------------*/
void TBreakForm::Init(IExtIF *ext_if, AnsiString path)
{
    m_pExtIF = ext_if;
    filePath = path;
    InitBrealList(filePath);
}

/*---------------------------------------------
// Funct Name : Finish
// ex         : I
//---------------------------------------------*/
void TBreakForm::Finish()
{
    SaveBreakInfo(filePath);
}

/*---------------------------------------------
// Funct Name : SetBreak
// arg1       : JE^tAllocInfoւ̃t@X
// ex         : Break̒ǉ
//---------------------------------------------*/
void TBreakForm::SetBreak(const AllocInfoWithCounter& newInfo)
{
    BreakInfo tmp;
    AnsiString file_line;
    file_line.printf("%s_%d",newInfo.allocInfo.filename, newInfo.allocInfo.line_num);
    tmp.addr            = newInfo.allocInfo.addr;
    tmp.heapID          = newInfo.allocInfo.heapID;
    tmp.count           = newInfo.count;
    tmp.fileLine        = file_line;
    tmp.enable          = true;
    tmp.enableAddr      = true;
    tmp.enableHeapID    = true;
    tmp.enableFileLine  = true;
    tmp.enableCount     = false;

    breakList.push_back(tmp);

    SetToSG(tmp);

    m_pExtIF->PrintString("breakǉ");
}

/*---------------------------------------------
// Funct Name : SetToSG
// arg1       : StringGridɒǉBreakInfo
// ex         : StringGridɃuCNǉ
//---------------------------------------------*/
void TBreakForm::SetToSG(const BreakInfo& newInfo)
{
    if(BreakListSG->RowCount < (int)breakList.size()+1)
        BreakListSG->RowCount = breakList.size()+1;


    BreakListSG->Cells[COL_ADDR][breakList.size()] = "0x" + IntToHex((__int64)newInfo.addr, 8);
    BreakListSG->Cells[COL_HEAP][breakList.size()] = heapNames[newInfo.heapID];
    BreakListSG->Cells[COL_LINE][breakList.size()] = newInfo.fileLine;
    BreakListSG->Cells[COL_COUNT][breakList.size()] = newInfo.count;

    BreakListSG->Refresh();
}

/*---------------------------------------------
// Funct Name : CheckBreak
// arg1       : AllocInfoWithCounter
// ex         : uCN
//---------------------------------------------*/
unsigned TBreakForm::CheckBreak(const AllocInfoWithCounter& checkInfo)
{
    std::vector<BreakInfo>::iterator ite,end;
    unsigned  flag      = 0;
    unsigned  cnt       = 0;
    unsigned  max       = breakList.size();
    AnsiString tmp;
    tmp.printf("%s_%d",checkInfo.allocInfo.filename, checkInfo.allocInfo.line_num);

    //lXgŋCłAȂƂłȂ̂c
    //u[N̑ɔႵāAʂ邵c
    while(cnt < max)
    {
        if(breakList[cnt].enable)
        {
            if(breakList[cnt].enableAddr)
            {
                if(breakList[cnt].addr != checkInfo.allocInfo.addr)
                {
                    cnt++;
                    continue;
                }
                else
                {
                    flag |= MASK_ADDR;
                }
            }
            if(breakList[cnt].enableHeapID)
            {
                if(breakList[cnt].heapID != checkInfo.allocInfo.heapID)
                {
                    cnt++;
                    flag=0;
                    continue;
                }
                else
                {
                    flag |= MASK_HEAP;
                }
            }
            if(breakList[cnt].enableFileLine)
            {
                if(breakList[cnt].fileLine != tmp)
                {
                    cnt++;
                    flag = 0;
                    continue;
                }
                else
                {
                    flag |= MASK_LINE;
                }
            }
            if(breakList[cnt].enableCount)
            {
                if(breakList[cnt].count != checkInfo.count)
                {
                    cnt++;
                    flag = 0;
                    continue;
                }
                else
                {
                    flag |= MASK_COUNT;
                }
            }

            if(flag)    //u[N̏
            {
                currentBreakID = cnt+1;
                BreakListSG->Refresh();
                return flag;
            }

        }
        cnt++;
    }

    return flag;
}

/*---------------------------------------------
// Funct Name : InitFormComponent
// ex         : Window̃R|[lgʒȕ
//---------------------------------------------*/
void TBreakForm::InitFormComponent()
{
    rightClickRow = 0;

    BreakListSG->ColWidths[COL_ID]      = 25;
    BreakListSG->ColWidths[COL_ADDR]    = 70;
    BreakListSG->ColWidths[COL_HEAP]    = 70;
    BreakListSG->ColWidths[COL_LINE]    = 100;
    BreakListSG->ColWidths[COL_COUNT]   = 50;
    BreakListSG->Cells[COL_ID][0]       = "id";
    BreakListSG->Cells[COL_ADDR][0]     = "address";
    BreakListSG->Cells[COL_HEAP][0]     = "heapID";
    BreakListSG->Cells[COL_LINE][0]     = "file_line";
    BreakListSG->Cells[COL_COUNT][0]    = "count";
}


/*---------------------------------------------
// Funct Name : BreakListSGContextPopup
// ex         : ENbNCellʒu擾
//---------------------------------------------*/
void __fastcall TBreakForm::BreakListSGContextPopup(TObject *Sender,
      TPoint &MousePos, bool &Handled)
{
    int ACol,ARow;
    BreakListSG->MouseToCell(MousePos.x, MousePos.y, ACol, ARow);
    rightClickRow = ARow;
    BreakListSG->Row = leftClickRow;
}


/*---------------------------------------------
// Funct Name : DeleteBreakInfoClick
// ex         : ENbNj[[Delete]Ă΂֐
//              uCN폜
//---------------------------------------------*/
void __fastcall TBreakForm::DeleteBreakInfoClick(TObject *Sender)
{
    if(leftClickRow==0 || leftClickRow>breakList.size())
        return;

    std::vector<BreakInfo>::iterator ite = breakList.begin();
    ite += leftClickRow-1;
    int tmpRow = BreakListSG->TopRow;
    BreakListSG->DeleteRow(rightClickRow);
    BreakListSG->TopRow = tmpRow;
    BreakListSG->Row = leftClickRow;

    if(currentBreakID == rightClickRow)
        currentBreakID = 0;

    if(currentBreakID > rightClickRow)
        currentBreakID--;

    breakList.erase(ite);
}


/*---------------------------------------------
// Funct Name : BreakListSGDblClick
// ex         : Cell_uNbNA̗LύX
//---------------------------------------------*/
void __fastcall TBreakForm::BreakListSGDblClick(TObject *Sender)
{
    if(leftClickRow>0 && leftClickRow<=breakList.size())
    {
        switch(leftClickCol)
        {
            case COL_ID:
                breakList[leftClickRow-1].enable = !breakList[leftClickRow-1].enable;
                break;
            case COL_ADDR:
                breakList[leftClickRow-1].enableAddr = !breakList[leftClickRow-1].enableAddr;
                break;
            case COL_HEAP:
                breakList[leftClickRow-1].enableHeapID = !breakList[leftClickRow-1].enableHeapID;
                break;
            case COL_LINE:
                breakList[leftClickRow-1].enableFileLine = !breakList[leftClickRow-1].enableFileLine;
                break;
            case COL_COUNT:
                breakList[leftClickRow-1].enableCount = !breakList[leftClickRow-1].enableCount;
                break;
            default:
                break;
        }
    }
    ((TMyStringGrid*)Sender)->Refresh();
}


/*---------------------------------------------
// Funct Name : BreakListSGMouseDown
// ex         : NbNCell̈ʒu擾
//---------------------------------------------*/
void __fastcall TBreakForm::BreakListSGMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    int ACol,ARow;
    BreakListSG->MouseToCell(X, Y, ACol, ARow);
    leftClickRow = ARow;
    leftClickCol = ACol;
}


/*---------------------------------------------
// Funct Name : BreakListSGDrawCell
// ex         : Cell`֘A
//---------------------------------------------*/
void __fastcall TBreakForm::BreakListSGDrawCell(TObject *Sender, int ACol,
      int ARow, TRect &Rect, TGridDrawState State)
{

    if(ARow>0 && ARow<=(int)breakList.size())
    {
        //u[NӏɐF
        if(ACol!=COL_ID && ARow==(int)currentBreakID )
        {
            BreakListSG->Canvas->Brush->Color=clMoneyGreen;
            BreakListSG->Canvas->FillRect(Rect);
        }

        switch(ACol)
        {
            case COL_ID:
                if(!breakList[ARow-1].enable)
                {
                    BreakListSG->Canvas->Font->Color=clWhite;
                }
	            BreakListSG->Canvas->TextRect(Rect,Rect.Left+2,Rect.Top+2,ARow);
                break;
            case COL_ADDR:
                if(!breakList[ARow-1].enableAddr || !breakList[ARow-1].enable)
                    BreakListSG->Canvas->Font->Color=clSilver;
                else
                    BreakListSG->Canvas->Font->Color=clBlack;

	            BreakListSG->Canvas->TextRect(Rect,Rect.Left+2,Rect.Top+2,BreakListSG->Cells[ACol][ARow]);
                break;
            case COL_HEAP:
                if(!breakList[ARow-1].enableHeapID || !breakList[ARow-1].enable)
                    BreakListSG->Canvas->Font->Color=clSilver;
                else
                    BreakListSG->Canvas->Font->Color=clBlack;

		        BreakListSG->Canvas->TextRect(Rect,Rect.Left+2,Rect.Top+2,BreakListSG->Cells[ACol][ARow]);
                break;
            case COL_LINE:
                if(!breakList[ARow-1].enableFileLine || !breakList[ARow-1].enable)
                    BreakListSG->Canvas->Font->Color=clSilver;
                else
                    BreakListSG->Canvas->Font->Color=clBlack;

		        BreakListSG->Canvas->TextRect(Rect,Rect.Left+2,Rect.Top+2,BreakListSG->Cells[ACol][ARow]);
                break;
            case COL_COUNT:
                if(!breakList[ARow-1].enableCount || !breakList[ARow-1].enable)
                    BreakListSG->Canvas->Font->Color=clSilver;
                else
                    BreakListSG->Canvas->Font->Color=clBlack;

		        BreakListSG->Canvas->TextRect(Rect,Rect.Left+2,Rect.Top+2,BreakListSG->Cells[ACol][ARow]);
                break;
            default:
                break;
        }
    }
}


void TBreakForm::ClearBreakMark()
{
	currentBreakID = 0;
	BreakListSG->Refresh();
}

/*---------------------------------------------
// Funct Name : SaveBreakInfo
// ex         : Breakt@Cɕۑ
//---------------------------------------------*/
void TBreakForm::SaveBreakInfo(AnsiString path)
{
    if(path.IsEmpty())
        return;

    TStringList* lines;
    lines = new TStringList();

    int end = breakList.size();
    for(int cnt=0; cnt < end; cnt++)
    {
        AnsiString tmp;
        tmp.printf("%d,%d,%s,%d,%d,%d,%d,%d,%d",
        breakList[cnt].addr,
        breakList[cnt].heapID,
        breakList[cnt].fileLine,
        breakList[cnt].count,
        breakList[cnt].enable,
        breakList[cnt].enableAddr,
        breakList[cnt].enableHeapID,
        breakList[cnt].enableFileLine,
        breakList[cnt].enableCount);

        lines->Add(tmp);
    }
    TFileStream* fs = new TFileStream(path, fmCreate);
    lines->SaveToStream(fs);
    delete fs;

    delete lines;
}

/*---------------------------------------------
// Funct Name : InitBrealList
// ex         : BreakListt@C珉
//---------------------------------------------*/
void TBreakForm::InitBrealList(AnsiString path)
{
    if(path.IsEmpty())
        return;

    breakList.clear();

    TStringList* lines;
    lines = new TStringList();

    try
    {

    lines->LoadFromFile(path);

    int end = lines->Count;
    for(int cnt=0; cnt<end; cnt++)
    {
        TStrings *tmp,*tmp2;
        tmp = new TStringList();
        tmp2 = new TStringList();
        tmp->CommaText = lines->Strings[cnt];
        tmp2->AddStrings(tmp);

        {
            BreakInfo tmpInfo;

            tmpInfo.addr            = tmp2->Strings[CVS_ADDR].ToInt();
            tmpInfo.heapID          = tmp2->Strings[CVS_HEAP].ToInt();
            tmpInfo.fileLine        = tmp2->Strings[CVS_LINE];
            tmpInfo.count           = tmp2->Strings[CVS_COUNT].ToInt();
            tmpInfo.enable          = tmp2->Strings[CVS_ENABLE].ToInt();
            tmpInfo.enableAddr      = tmp2->Strings[CVS_ENEBLE_ADDR].ToInt();
            tmpInfo.enableHeapID    = tmp2->Strings[CVS_ENABLE_HEAP].ToInt();
            tmpInfo.enableFileLine  = tmp2->Strings[CVS_ENABLE_LINE].ToInt();
            tmpInfo.enableCount     = tmp2->Strings[CVS_ENABLE_COUNT].ToInt();
            breakList.push_back(tmpInfo);
            SetToSG(tmpInfo);
        }

        delete tmp;
        delete tmp2;
    }
    BreakListSG->Refresh();

    }
    catch(...)
    {
    }

    delete lines;
}


