//---------------------------------------------------------------------------

#ifndef BreakUnitH
#define BreakUnitH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <Menus.hpp>
#include "MyStringGrid.h"
#include <vector>
#include "memSnatcher.h"
#include "MyStringGrid.h"
#include "ext_if.h"
//---------------------------------------------------------------------------

class TBreakForm : public TForm
{
__published:	// IDE Ǘ̃R|[lg
    TMyStringGrid *BreakListSG;
    TPopupMenu *PopupMenu;
    TMenuItem *DeleteBreakInfo;
    void __fastcall BreakListSGContextPopup(TObject *Sender,
          TPoint &MousePos, bool &Handled);
    void __fastcall DeleteBreakInfoClick(TObject *Sender);
    void __fastcall BreakListSGDblClick(TObject *Sender);
    void __fastcall BreakListSGMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall BreakListSGDrawCell(TObject *Sender, int ACol,
          int ARow, TRect &Rect, TGridDrawState State);
private:	// [U[錾
    std::vector<BreakInfo> breakList;
    unsigned   rightClickRow;
    unsigned   leftClickRow;
    unsigned   leftClickCol;
    unsigned   currentBreakID;
    IExtIF*    m_pExtIF;
    AnsiString filePath;
    void InitFormComponent();
    void InitBrealList(AnsiString path);
    void SetToSG(const BreakInfo& newInfo);

protected:
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);

public:		// [U[錾
	static HWND		m_TempParent;

    __fastcall TBreakForm(TComponent* Owner);
    void Init(IExtIF *ext_if, AnsiString path);
    void Finish();
    void SetBreak(const AllocInfoWithCounter& newInfo);
    unsigned CheckBreak(const AllocInfoWithCounter& checkInfo);
    void ClearBreakMark();
    void SaveBreakInfo(AnsiString path);
};
//---------------------------------------------------------------------------
extern PACKAGE TBreakForm *BreakForm;
//---------------------------------------------------------------------------
#endif
