//---------------------------------------------------------------------------

#include <vcl.h>
#include <functional>
#include <algorithm>
#include <IniFiles.hpp>
#pragma hdrstop

#include "MoniterUnit.h"
#include "BreakUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMoniterForm *MoniterForm;

#define GET_PANELHEIGHT_ADDR(addr) (addr - NITRO_MEM_ADDR_START) * HeapMoniterPanel->Height / NITRO_MAX_MEM_SIZE
#define GET_PANELHEIGHT_SIZE(size) size * HeapMoniterPanel->Height / NITRO_MAX_MEM_SIZE;

HWND		TMoniterForm::m_TempParent = NULL;

//---------------------------------------------------------------------------
__fastcall TMoniterForm::TMoniterForm(TComponent* Owner)
    : TForm(Owner), allocMoniterTrgAddr(NITRO_MEM_ADDR_START)
{
}

void __fastcall TMoniterForm::CreateParams(Controls::TCreateParams &Params)
{
	TForm::CreateParams(Params);
	if (m_TempParent) {
		Params.WndParent = m_TempParent;
	}
}

//---------------------------------------------------------------------------
void TMoniterForm::Init(IExtIF *ext_if, AnsiString path_name, AnsiString module_name,
	HWND top_wnd)
{
	m_pExtIF = ext_if;
	m_MyDir = path_name;
	m_ModuleName = module_name;
	m_ShowBreak = FALSE;
    m_BreakFilePath = m_MyDir + "\\" + "breakinfo.csv";
    isNeedUpdate = FALSE;
    InitFormComponent();
    InitCounter();
    BreakForm->m_TempParent = top_wnd;
	BreakForm = new TBreakForm(NULL);
	BreakForm->OnClose = BreakFormClose;
    BreakForm->Init(m_pExtIF, m_BreakFilePath);

    LoadIni();
}

void TMoniterForm::Finish()
{
	SaveIni();
    BreakForm->Finish();
	delete BreakForm;
	BreakForm = NULL;
}
//---------------------------------------------------------------------------
void __fastcall TMoniterForm::MoniterTimerTimer(TObject *Sender)
{
    if(isNeedUpdate)
        UpdateMoniter();
}
//---------------------------------------------------------------------------
void __fastcall TMoniterForm::AllocMoniterButtonClick(TObject *Sender)
{
	unsigned	tmp;

    // allocMoniterTrgAddrݒ
    tmp = StrToIntDef(AllocMoniterEdit->Text, 0xffffffff);
    if (tmp > NITRO_MEM_ADDR_END || tmp < NITRO_MEM_ADDR_START )
    {
        ShowMessage(AnsiString("0x") + IntToHex(NITRO_MEM_ADDR_START, 8) + "`0x" +
            IntToHex(NITRO_MEM_ADDR_END, 8) + "͈̔͂Ŏw肵ĉB");
        AllocMoniterEdit->Text = "0x" + IntToHex((int)allocMoniterTrgAddr, 8);
    }
    else
    {
        allocMoniterTrgAddr = tmp;
        AllocMoniterCurrentLabel->Caption = "0x" + IntToHex((int)allocMoniterTrgAddr, 8);
    }

    // US
    std::map<unsigned int, TPanel*>::iterator itPanel = allocPanelMap.begin();
    while(itPanel != allocPanelMap.end())
    {
        delete itPanel->second;
        itPanel++;
    }
    allocPanelMap.clear();

    // AllocMoniter̍č\z inAllocMoniter_Range_funcObj
    std::map<unsigned int, AllocInfoWithCounter>::iterator itInfo;
    for(itInfo = allocWithCountMap.begin(); itInfo != allocWithCountMap.end(); itInfo++)
    {
        CreateAllocComponent(&(itInfo->second.allocInfo));
    }

    // AllocMoniterʒu̐ĕ`
    DrawAllocRange();
}
//---------------------------------------------------------------------------

void __fastcall TMoniterForm::ListPageControlChange(TObject *Sender)
{
    UpdateMoniter();
}
//---------------------------------------------------------------------------

void __fastcall TMoniterForm::AllocListSGSelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
    if(ACol == 1 && ARow > 0)
        AllocMoniterEdit->Text = AllocListSG->Cells[ACol][ARow];
}
//---------------------------------------------------------------------------

void __fastcall TMoniterForm::HeapListSGSelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
    if(ACol == 1 && ARow > 0)
        AllocMoniterEdit->Text = HeapListSG->Cells[ACol][ARow];
}
//---------------------------------------------------------------------------

void __fastcall TMoniterForm::GrepRadioClick(TObject *Sender)
{
    UpdateList();
}
//---------------------------------------------------------------------------
void __fastcall TMoniterForm::FormPaint(TObject *Sender)
{
    DrawAllocRange();
}
//---------------------------------------------------------------------------
void __fastcall TMoniterForm::addToBreakClick(TObject *Sender)
{
    AllocInfoWithCounter tmp;
    tmp = allocWithCountMap.find(rightClickAddr)->second;
    BreakForm->SetBreak(tmp);

    rightClickAddr = NULL;
    addToBreak->Enabled = false;

    ShowAllocBreakClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TMoniterForm::AllocListSGContextPopup(TObject *Sender,
      TPoint &MousePos, bool &Handled)
{
    int ACol,ARow;
    AllocListSG->MouseToCell(MousePos.x, MousePos.y, ACol, ARow);
    if(ACol==1 && ARow !=0)
    {
        rightClickAddr = StrToInt64Def(AllocListSG->Cells[ACol][ARow],NULL);
        if(rightClickAddr)
            addToBreak->Enabled = true;
    }
}
//---------------------------------------------------------------------------


/*----- O֐IuWFNg -----*/

class equal_parentID_funcObj : public std::binary_function<std::pair<const unsigned int, HeapInfo>, unsigned int, BOOL>
{
    public:
        result_type operator()(first_argument_type a, second_argument_type b)
        {
            if(a.second.parentID == b)
                return TRUE;
            else
                return FALSE;
        }
};

class inHeap_parentID_funcObj : public std::binary_function<std::pair<const unsigned int, AllocInfoWithCounter>, unsigned int, BOOL>
{
    public:
        result_type operator()(first_argument_type a, second_argument_type b)
        {
            if(MoniterForm->GetParentID(a.second.allocInfo.heapID) == b)
                return TRUE;
            else
                return FALSE;
        }
};


/*----- O֐S ------*/

/*---------------------------------------------
// Funct Name : SetMemInfo
// Arg1       : void* newInfo
// ex         : newInfoAllocMapHeapMapɏi[
//              void*̐AllocInfoHeapInfołȂĂ͂ȂȂB
//              OJ֐
//---------------------------------------------*/
void TMoniterForm::SetMemInfo(MemInfo* newInfo)
{
    unsigned int msgType = *((unsigned int*)newInfo);
    switch (msgType)  // bZ[W^CvƂɏ𕪊
    {
        case ALLOC_INFO:
            AddAllocInfo(&newInfo->allocInfo);
            break;
        case FREE_INFO:
            RemoveAllocInfo(&newInfo->allocInfo);
            break;
        case CREATE_HEAP_INFO:
            AddHeapInfo(&newInfo->heapInfo);
            break;
        case DELETE_HEAP_INFO:
            RemoveHeapInfo(&newInfo->heapInfo);
            break;
        default:
            ShowMessage("sȃbZ[WM܂:SetMemInfo");
            exit(EXIT_FAILURE);
            break;
    }
    isNeedUpdate = TRUE;
}

/*---------------------------------------------
// Funct Name : UpdateMoniter
// ex         : Window̃R|[lgmapQƂčXVB
//---------------------------------------------*/
void TMoniterForm::UpdateMoniter()
{
    UpdateList();
    UpdateCounter();
    isNeedUpdate = FALSE;
}

/*---------------------------------------------
// Funct Name : AddAllocInfo
// Arg1       : AllocInfo* newInfo
// ex         : newInfoAllocMapɏi[
//---------------------------------------------*/
void TMoniterForm::AddAllocInfo(AllocInfo* newInfo)
{
    // HeapCheck
    if(heapMap.find(newInfo->heapID) == heapMap.end())
    {
        ShowMessage("݂ȂheapIDɑ΂Allocs܂");
        return;
    }

    allocWithCountMap[newInfo->addr].allocInfo = *newInfo;
    allocWithCountMap[newInfo->addr].allocInfo.filename[MEMBLOCK_FILENAME_AREASIZE-1]= '\0';
    allocWithCountMap[newInfo->addr].count = allocCount;

    // R|[lgǉ
    CreateAllocComponent(newInfo);

    // JE^
    heapCounter[ALL_VIEW].usedSize += newInfo->size;
    heapCounter[ALL_VIEW].allocNum++;
    heapCounter[GetParentID(newInfo->heapID)].usedSize += newInfo->size;
    heapCounter[GetParentID(newInfo->heapID)].allocNum++;
    allocCount++;

    // u[N`FbN
    if(BreakForm->CheckBreak(allocWithCountMap[newInfo->addr]))
    {
        m_pExtIF->PrintString("u[No");
        m_pExtIF->EngineStop();
    }

    //o ςoĂ܂ɂȂ邩ÂƂ
    //AnsiString tmp = "Alloced Addr:0x" + IntToHex((int)newInfo->addr, 8) + " size:" + IntToStr(newInfo->size)
    //               + " file:" + newInfo->filename + " line:" + IntToStr(newInfo->line_num);
    //PrintForm->PrintString(tmp);
}

/*---------------------------------------------
// Funct Name : RemoveAllocInfo
// Arg1       : AllocInfo* newInfo
// ex         : AllocMapnewInfoɊY폜
//---------------------------------------------*/
void TMoniterForm::RemoveAllocInfo(AllocInfo* newInfo)
{
    // HeapCheck
    if(heapMap.find(newInfo->heapID) == heapMap.end())
    {
        ShowMessage("݂ȂheapIDɑ΂Allocs܂");
        return;
    }
    // alloc񂪂邩`FbN
    if(allocWithCountMap.find(newInfo->addr) == allocWithCountMap.end())
    {
        ShowMessage("mۗ̈̊JM܂:RemoveAllocInfo");
        return;
    }


    // JE^
    heapCounter[ALL_VIEW].usedSize -= allocWithCountMap[newInfo->addr].allocInfo.size;
    heapCounter[ALL_VIEW].allocNum--;
    heapCounter[GetParentID(newInfo->heapID)].usedSize -= allocWithCountMap[newInfo->addr].allocInfo.size;
    heapCounter[GetParentID(newInfo->heapID)].allocNum--;

    allocWithCountMap.erase(newInfo->addr);

    // R|[lg폜
    if(allocPanelMap.find(newInfo->addr) != allocPanelMap.end())
    {
        delete allocPanelMap[newInfo->addr];
        allocPanelMap.erase(newInfo->addr);
    }
}

/*---------------------------------------------
// Funct Name : AddHeapInfo
// Arg1       : HeapInfo* newInfo
// ex         : newInfoHeapMapɏi[
//---------------------------------------------*/
void TMoniterForm::AddHeapInfo(HeapInfo* newInfo)
{
    // sID`FbN
    if(newInfo->heapID >= HEAPID_MAX)
    {
        ShowMessage("őHeapID傫lHeapIDw肳܂");
        return;
    }

    // HeapIDd`FbN
    if(heapMap.find(newInfo->heapID) != heapMap.end())
    {
        ShowMessage("ɑ݂HeapIDHeapmۂ悤Ƃ܂");
        return;
    }

    heapMap[newInfo->heapID] = *newInfo;

    // R|[lgǉ
    CreateHeapComponent(newInfo);

    // JE^
    heapCounter[ALL_VIEW].heapNum++;
    heapCounter[GetParentID(newInfo->heapID)].heapNum++;

    if(newInfo->heapID == HEAPID_BASE_SYSTEM)
    {
        heapCounter[ALL_VIEW].usedSize += newInfo->addr - NITRO_MEM_ADDR_START;
    }

}

/*---------------------------------------------
// Funct Name : RemoveHeapInfo
// Arg1       : HeapInfo* newInfo
// ex         : HeapMapnewInfoɊY폜
//---------------------------------------------*/
void TMoniterForm::RemoveHeapInfo(HeapInfo* newInfo)
{
    // YHeap݂邩`FbN
    if(heapMap.find(newInfo->heapID) == heapMap.end())
    {
        ShowMessage("쐬Heap̊JM܂:RemoveAllocInfo");
        return;
    }

    // JE^
    heapCounter[ALL_VIEW].heapNum--;
    heapCounter[GetParentID(newInfo->heapID)].heapNum--;

    // R|[lg폜
    delete heapPanelMap[newInfo->heapID];
    heapPanelMap.erase(newInfo->heapID);

    if(newInfo->addr == HEAPID_BASE_SYSTEM)	// ̃P[X͂Ă͂ȂȂ
		delete programPanel;

    // HeapInfo폜
    heapMap.erase(newInfo->heapID);


    // cĂĂ͍邪AHeapɖFreë悪ΊJ
    // ǉ\c Heapeq֌WׁAX

}

/*---------------------------------------------
// Funct Name : InitFormComponent
// ex         : Window̃R|[lgʒȕ
//---------------------------------------------*/
void TMoniterForm::InitFormComponent()
{
    AllocListSG->ColWidths[0] = 25;
    AllocListSG->ColWidths[1] = 70;
    AllocListSG->ColWidths[2] = 100;
    AllocListSG->ColWidths[3] = 48;
    AllocListSG->ColWidths[4] = 66;
    AllocListSG->ColWidths[5] = 49;
    AllocListSG->Cells[0][0] = "id";
    AllocListSG->Cells[1][0] = "address";
    AllocListSG->Cells[2][0] = "heapID";
    AllocListSG->Cells[3][0] = "size";
    AllocListSG->Cells[4][0] = "filename";
    AllocListSG->Cells[5][0] = "line_num";

    HeapListSG->ColWidths[0] = 25;
    HeapListSG->ColWidths[1] = 70;
    HeapListSG->ColWidths[2] = 100;
    HeapListSG->ColWidths[3] = 100;
    HeapListSG->ColWidths[4] = 48;
    HeapListSG->Cells[0][0] = "id";
    HeapListSG->Cells[1][0] = "address";
    HeapListSG->Cells[2][0] = "heapID";
    HeapListSG->Cells[3][0] = "parentID";
    HeapListSG->Cells[4][0] = "size";

    CounterSG->Cells[0][1] = "ALL";
    CounterSG->Cells[0][2] = "SYS";
    CounterSG->Cells[0][3] = "SAVE";
    CounterSG->Cells[0][4] = "DEBUG";
    CounterSG->Cells[0][5] = "APP";
    CounterSG->Cells[1][0] = "Heap";
    CounterSG->Cells[2][0] = "Alloc";

    AllocMoniterEdit->Text = "0x" + IntToHex(NITRO_MEM_ADDR_START, 8);
    AllocMoniterCurrentLabel->Caption = "0x" + IntToHex(NITRO_MEM_ADDR_START, 8);

    counterComponents[ALL_VIEW].perBar = MemPerBar;
    counterComponents[ALL_VIEW].perLabel = TotalPerLabel;
    counterComponents[ALL_VIEW].perLabel2 = TotalPerLabel2;
    counterComponents[SYSTEM_VIEW].perBar = SystemPerBar;
    counterComponents[SYSTEM_VIEW].perLabel = SystemPerLabel;
    counterComponents[SYSTEM_VIEW].perLabel2 = SystemPerLabel2;
    counterComponents[SAVE_VIEW].perBar = SavePerBar;
    counterComponents[SAVE_VIEW].perLabel = SavePerLabel;
    counterComponents[SAVE_VIEW].perLabel2 = SavePerLabel2;
    counterComponents[DEBUG_VIEW].perBar = DebugPerBar;
    counterComponents[DEBUG_VIEW].perLabel = DebugPerLabel;
    counterComponents[DEBUG_VIEW].perLabel2 = DebugPerLabel2;
    counterComponents[APP_VIEW].perBar = AppPerBar;
    counterComponents[APP_VIEW].perLabel = AppPerLabel;
    counterComponents[APP_VIEW].perLabel2 = AppPerLabel2;

}

/*---------------------------------------------
// Funct Name : InitCounter
// ex         : eViewHeap/AllocJE^̏
//---------------------------------------------*/
void TMoniterForm::InitCounter()
{
    for(int cnt=0; cnt<VIEW_NUM; cnt++)
    {
        heapCounter[cnt].heapNum = 0;
        heapCounter[cnt].allocNum = 0;
        heapCounter[cnt].usedSize = 0;
    }
    allocCount = 0;
}

/*---------------------------------------------
// Funct Name : CreateHeapComponent
// arg1       : HeapInfo* newInfo
// ex         : newInfoɊÂHeapPanelR|[lg𐶐
//---------------------------------------------*/
void TMoniterForm::CreateHeapComponent(HeapInfo *newInfo)
{
	int height, top;
    TPanel* tmp;

    // SYSTEM_HEAP ̏ꍇ̂ Program̈̃R|[lg쐬
    if(newInfo->heapID == HEAPID_BASE_SYSTEM)
    {
        height = GET_PANELHEIGHT_ADDR(newInfo->addr);

        programPanel = new TPanel(MoniterForm);
        programPanel->Parent = HeapMoniterPanel;
        programPanel->Top    = HeapMoniterPanel->Height - height;
        programPanel->Left   = 1;
        programPanel->Width  = HeapMoniterPanel->Width - 2;
        programPanel->Height = height-1;
        programPanel->Caption = "PROGRAM";
    }

    // R|[lg̃TCYvZ
    top = GET_PANELHEIGHT_ADDR(newInfo->addr);
    height = GET_PANELHEIGHT_SIZE(newInfo->size);

	// R|[lg̍쐬(elPanel̘g̒)
    tmp = new TPanel(MoniterForm);
    heapPanelMap[newInfo->heapID] = tmp;
    tmp->Parent = HeapMoniterPanel;
    tmp->Top    = HeapMoniterPanel->Height - 2 - top - height;
    tmp->Height = height - 1;
    tmp->Caption = heapNames[newInfo->heapID];
    tmp->ShowHint = true;
    AnsiString hint;
    hint.printf("Addr:0x%8X Size:%d",newInfo->addr, newInfo->size);
    tmp->Hint = hint;

    if(newInfo->heapID < HEAPID_BASE_MAX)
    {
	    tmp->Left   = 1;
	    tmp->Width  = HeapMoniterPanel->Width - 2;
        tmp->Color  = clSkyBlue;
        tmp->SendToBack();
    }
    else
    {
	    tmp->Left   = 2;
	    tmp->Width  = HeapMoniterPanel->Width - 4;
	    tmp->Color  = clMoneyGreen;
    }
}

/*---------------------------------------------
// Funct Name : CreateAllocComponent
// arg1       : AllocInfo* newInfo
// ex         : newInfoɊÂAllocPanelR|[lg𐶐
//---------------------------------------------*/
void TMoniterForm::CreateAllocComponent(AllocInfo *newInfo)
{
    // `Ώ۔
    if( !( (newInfo->addr > allocMoniterTrgAddr) && ((newInfo->addr + newInfo->size) > (allocMoniterTrgAddr + ALLOC_MONITER_RANGE)) )
    && !( (newInfo->addr < allocMoniterTrgAddr) && ((newInfo->addr + newInfo->size) < (allocMoniterTrgAddr + ALLOC_MONITER_RANGE)) ) )
    {
        // 1E2̒l̓R|[lg̃TCY̔
        int height = newInfo->size / ALLOC_BYTE_PER_PIXEL;
        int top = AllocMoniterPanel->Height - 2 - (newInfo->addr - allocMoniterTrgAddr) / ALLOC_BYTE_PER_PIXEL - height;
        if(top < 0) top = 0;
        if(height > AllocMoniterPanel->Height - 2) height = AllocMoniterPanel->Height - 2;

        TPanel* tmp;
        tmp = new TPanel(MoniterForm);
        allocPanelMap[newInfo->addr] = tmp;
        tmp->Parent = AllocMoniterPanel;
        tmp->Top    = top;
        tmp->Left   = 1;
        tmp->Width  = AllocMoniterPanel->Width - 2;
        tmp->Height = height;
        tmp->Color  = clSkyBlue;
        tmp->ShowHint = true;
        AnsiString hint;
        hint.printf("Addr:0x%8X Size:%d",newInfo->addr, newInfo->size);
        tmp->Hint = hint;
        AnsiString cap;
        cap.printf("%s line:%d", newInfo->filename, newInfo->line_num);
        tmp->Caption = cap;
    }
}

/*---------------------------------------------
// Funct Name : UpdateList
// ex         : WindowAlloc/Heap List(StringGrid)XVB
//---------------------------------------------*/
void TMoniterForm::UpdateList()
{
    inHeap_parentID_funcObj fobj_inParent;
    equal_parentID_funcObj  fobj_eqParent;
    switch (ListPageControl->ActivePageIndex)
    {
        case 0: // AllocList
        {
            std::map<unsigned int, AllocInfoWithCounter>::iterator itAlloc, itSwap;
            int cnt;

            itAlloc = allocWithCountMap.begin();
            if(GrepRadio->ItemIndex != ALL_VIEW)
                itAlloc = std::find_if(itAlloc, allocWithCountMap.end(), std::bind2nd(fobj_inParent, GrepRadio->ItemIndex) );

            for(cnt=1; itAlloc != allocWithCountMap.end(); cnt++)
            {
                AllocListSG->RowCount++;
                AllocListSG->Cells[0][cnt] = cnt-1;
                AnsiString hex = "0x" + IntToHex((int)itAlloc->second.allocInfo.addr, 8);
                AllocListSG->Cells[1][cnt] = hex;
                AllocListSG->Cells[2][cnt] = heapNames[itAlloc->second.allocInfo.heapID];
                AllocListSG->Cells[3][cnt] = itAlloc->second.allocInfo.size;
                AllocListSG->Cells[4][cnt] = itAlloc->second.allocInfo.filename;
                AllocListSG->Cells[5][cnt] = itAlloc->second.allocInfo.line_num;

                if(GrepRadio->ItemIndex != ALL_VIEW)
                {
                    itSwap = itAlloc;
                    itSwap++;
                    itAlloc = std::find_if(itSwap, allocWithCountMap.end(), std::bind2nd(fobj_inParent, GrepRadio->ItemIndex) );
                }
                else
                    itAlloc++;
            }
            if(cnt == 1) // 1ōƁAPsڂ邭Ȃ
            {
                cnt++;
                AllocListSG->Cells[1][1] = "";
                AllocListSG->Cells[2][1] = "";
                AllocListSG->Cells[3][1] = "";
                AllocListSG->Cells[4][1] = "";
                AllocListSG->Cells[5][1] = "";
            }
            AllocListSG->RowCount = cnt;
            break;
        }
        case 1: // HeapList
        {
            std::map<unsigned int, HeapInfo>::iterator itHeap, itSwap;
            int cnt;

            itHeap = heapMap.begin();
            if(GrepRadio->ItemIndex != ALL_VIEW)
                itHeap = std::find_if(itHeap, heapMap.end(), std::bind2nd(fobj_eqParent, GrepRadio->ItemIndex) );

            for(cnt=1; itHeap != heapMap.end(); cnt++)
            {
                HeapListSG->RowCount++;
                HeapListSG->Cells[0][cnt] = cnt-1;
                AnsiString hex = "0x" + IntToHex((int)itHeap->second.addr, 8);
                HeapListSG->Cells[1][cnt] = hex;
                HeapListSG->Cells[2][cnt] = heapNames[itHeap->second.heapID];
                HeapListSG->Cells[3][cnt] = heapNames[itHeap->second.parentID];
                HeapListSG->Cells[4][cnt] = itHeap->second.size;

                if(GrepRadio->ItemIndex != ALL_VIEW)
                {
                    itSwap = itHeap;
                    itSwap++;
                    itHeap = std::find_if(itSwap, heapMap.end(), std::bind2nd(fobj_eqParent, GrepRadio->ItemIndex) );
                }
                else
                    itHeap++;
            }

            if(cnt == 1) // 1ōƁAPsڂ邭Ȃ
            {
                cnt++;
                HeapListSG->Cells[1][1] = "";
                HeapListSG->Cells[2][1] = "";
                HeapListSG->Cells[3][1] = "";
                HeapListSG->Cells[4][1] = "";
                HeapListSG->Cells[5][1] = "";

            }
            HeapListSG->RowCount = cnt;
            break;
        }
        default:
            break;
    }
}

/*---------------------------------------------
// Funct Name : UpdateCounter
// ex         : CounterɊւR|[lg̃Abvf[g
//---------------------------------------------*/
void TMoniterForm::UpdateCounter()
{
    for(int cnt=0; cnt<VIEW_NUM; cnt++)
    {
        if(cnt == ALL_VIEW)
        {
            CounterSG->Cells[1][1] = heapCounter[cnt].heapNum;
            CounterSG->Cells[2][1] = heapCounter[cnt].allocNum;

            unsigned int per;
            if(heapMap.find(cnt) == heapMap.end())
            {
                per = 0;
                counterComponents[cnt].perLabel2->Caption = "0x" + IntToHex((int)heapCounter[cnt].usedSize, 8) + " / " + "0x00000000";
            }
            else
            {
                per = heapCounter[cnt].usedSize * 100 / NITRO_MAX_MEM_SIZE;
                counterComponents[cnt].perLabel2->Caption = "0x" + IntToHex((int)heapCounter[cnt].usedSize, 8) + " / " + "0x" + IntToHex(NITRO_MAX_MEM_SIZE, 8);
            }
            counterComponents[cnt].perBar->Position = per;
            counterComponents[cnt].perLabel->Caption = IntToStr(per) + "%";
       }
        else
        {
            CounterSG->Cells[1][cnt+2] = heapCounter[cnt].heapNum;
            CounterSG->Cells[2][cnt+2] = heapCounter[cnt].allocNum;

            unsigned int per;
            if(heapMap.find(cnt) == heapMap.end())
            {
                per = 0;
                counterComponents[cnt].perLabel2->Caption = "0x" + IntToHex((int)heapCounter[cnt].usedSize, 8) + " / " + "0x00000000";
            }
            else
            {
                per = heapCounter[cnt].usedSize * 100 / heapMap[cnt].size;
                counterComponents[cnt].perLabel2->Caption = "0x" + IntToHex((int)heapCounter[cnt].usedSize, 8) + " / " + "0x" + IntToHex((int)heapMap[cnt].size, 8);
            }
            counterComponents[cnt].perBar->Position = per;
            counterComponents[cnt].perLabel->Caption = IntToStr(per) + "%";

        }
    }
}

/*---------------------------------------------
// Funct Name : GetParentID
// Arg1       : int heapID
// ex         : heapID炻HeapParentHeapID擾
//---------------------------------------------*/
unsigned int TMoniterForm::GetParentID(unsigned int heapID)
{
    return heapMap[heapID].parentID;
}

/*---------------------------------------------
// Funct Name : DrawAllocRange
// ex         : Alloc\͈͂̐`
//---------------------------------------------*/
void TMoniterForm::DrawAllocRange()
{
   HWND hWnd;
   hiLine = new TCanvas();
   hiLine->Handle = GetDeviceContext(hWnd);
   UpdateList();

   hiLine->Brush->Color = clBtnFace;
   TRect rect;
   rect.left = HeapMoniterPanel->Left + HeapMoniterPanel->Width;
   rect.right = rect.left + 42;
   rect.top = HeapMoniterPanel->Top;
   rect.bottom = HeapMoniterPanel->Top + HeapMoniterPanel->Height;

   hiLine->FillRect(rect);

   hiLine->Pen->Color = clBlue;
   hiLine->MoveTo( HeapMoniterPanel->Left + HeapMoniterPanel->Width, HeapMoniterPanel->Top + HeapMoniterPanel->Height - GET_PANELHEIGHT_ADDR(allocMoniterTrgAddr));
   hiLine->LineTo( AllocMoniterPanel->Left - 1, AllocMoniterPanel->Top + AllocMoniterPanel->Height );
   hiLine->Brush->Color = clBtnFace;

   delete hiLine;
   hiLine = NULL;
}

/*---------------------------------------------
// Funct Name : ResetMoniter
// ex         : S̃Zbg
//---------------------------------------------*/
void TMoniterForm::ResetMoniter()
{
    //heapEallocMap̃NA
    allocWithCountMap.clear();
    heapMap.clear();


    //PanelR|[lg̍폜
    std::map<unsigned int, TPanel*>::iterator ite = allocPanelMap.begin();
    std::map<unsigned int, TPanel*>::iterator end = allocPanelMap.end();
    while(ite != end)
    {
        delete ite->second;
        ite++;
    }
    allocPanelMap.clear();

    ite = heapPanelMap.begin();
    end = heapPanelMap.end();
    while(ite != end)
    {
        delete ite->second;
        ite++;
    }
    heapPanelMap.clear();
    if(programPanel!=NULL)
    {
        delete programPanel;
        programPanel=NULL;
    }


    //JE^[̏
    InitCounter();
    UpdateCounter();

    //XVtO
    isNeedUpdate = false;

    BreakForm->ClearBreakMark();

    m_pExtIF->PrintString("SZbg܂");
}

void TMoniterForm::LoadIni()
{
	TIniFile	*pi = new TIniFile(m_MyDir + "\\" + m_ModuleName + ".ini");
	AnsiString	visible;

	BreakForm->Left = pi->ReadInteger("break form", "left", BreakForm->Left);
	BreakForm->Top = pi->ReadInteger("break form", "top", BreakForm->Top);
	BreakForm->Height = pi->ReadInteger("break form", "height", BreakForm->Height);
	visible = pi->ReadString("break form", "visible", "false");
	if (visible == "true") {
		m_ShowBreak = TRUE;
	}
	Left = pi->ReadInteger("monitor form", "left", Left);
	Top = pi->ReadInteger("monitor form", "top", Top);
	visible = pi->ReadString("monitor form", "visible", "false");
	if (visible == "true") {
		Show();
	}
	delete pi;
}

void TMoniterForm::SaveIni()
{
	TIniFile	*pi = new TIniFile(m_MyDir + "\\" + m_ModuleName + ".ini");

	pi->WriteInteger("monitor form", "left", Left);
	pi->WriteInteger("monitor form", "top", Top);
	pi->WriteString("monitor form", "visible", Visible ? "true" : "false");
	pi->WriteInteger("break form", "left", BreakForm->Left);
	pi->WriteInteger("break form", "top", BreakForm->Top);
	pi->WriteInteger("break form", "height", BreakForm->Height);
	pi->WriteString("break form", "visible", m_ShowBreak ? "true" : "false");
	delete pi;
}

void __fastcall TMoniterForm::ShowAllocBreakClick(TObject *Sender)
{
	m_ShowBreak = TRUE;
	BreakForm->Show();
}

void __fastcall TMoniterForm::BreakFormClose(TObject *Sender, TCloseAction &Action)
{
	m_ShowBreak = FALSE;
}

void __fastcall TMoniterForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	BreakForm->Hide();
}

void TMoniterForm::Show()
{
	TForm::Show();
	if (m_ShowBreak) {
		BreakForm->Show();
	}
}


void TMoniterForm::SaveAllocInfo(TStream *st)
{
    TStringList* lines;
    lines = new TStringList();

    {
        std::map<unsigned int, HeapInfo>::iterator ite, end;
        end = heapMap.end();
        for(ite = heapMap.begin(); ite != end; ite++)
        {
            AnsiString tmp;
            tmp.printf("%d,%d,%d,%d",
            ite->second.addr,
            ite->second.heapID,
            ite->second.parentID,
            ite->second.size);

            lines->Add(tmp);
        }
    }
    lines->Add("Alloc");

    {
        std::map<unsigned int, AllocInfoWithCounter>::iterator ite, end;
        end = allocWithCountMap.end();
        for(ite = allocWithCountMap.begin(); ite != end; ite++)
        {
            AnsiString tmp;
            tmp.printf("%d,%d,%d,%s,%d,%d",
            ite->second.allocInfo.addr,
            ite->second.allocInfo.heapID,
            ite->second.allocInfo.size,
            ite->second.allocInfo.filename,
            ite->second.allocInfo.line_num,
            ite->second.count);

            lines->Add(tmp);
        }
    }

	//ŌAllocCounterĂ
    {
    	AnsiString tmp;
    	tmp.printf("%d",allocCount);

        lines->Add(tmp);
    }
    
    lines->SaveToStream(st);

    delete lines;
}

void TMoniterForm::CreateInfoFromFile(TStream *st)
{
    std::map<unsigned int, HeapInfo>::iterator heapIte = heapMap.begin();
    std::map<unsigned int, AllocInfoWithCounter>::iterator allocIte = allocWithCountMap.begin();

    BOOL finishHeap = FALSE;

    ResetMoniter();

    TStringList* lines;
    lines = new TStringList();

    try
    {

    lines->LoadFromStream(st);

	int cnt;
    int end = lines->Count;
    for(cnt=0; cnt<end-1; cnt++)
    {
		if(lines->Strings[cnt] == "Alloc")
		{
			finishHeap = TRUE;
			continue;
		}

        TStrings *tmp,*tmp2;
        tmp = new TStringList();
        tmp2 = new TStringList();
        tmp->CommaText = lines->Strings[cnt];
        tmp2->AddStrings(tmp);

		if(!finishHeap) // HeapMap\z
		{
            HeapInfo tmpInfo;

            tmpInfo.addr            = tmp2->Strings[CSV_HEAPINFO_ADDR].ToInt();
            tmpInfo.heapID          = tmp2->Strings[CSV_HEAPINFO_HEAPID].ToInt();
            tmpInfo.parentID        = tmp2->Strings[CSV_HEAPINFO_PARENTID].ToInt();
            tmpInfo.size            = tmp2->Strings[CSV_HEAPINFO_SIZE].ToInt();

			AddHeapInfo(&tmpInfo);
		}
		else // AllocMap\z
		{
            AllocInfoWithCounter tmpInfo;

            tmpInfo.allocInfo.addr      = tmp2->Strings[CSV_ALLOCINFO_ADDR].ToInt();
            tmpInfo.allocInfo.heapID    = tmp2->Strings[CSV_ALLOCINFO_HEAPID].ToInt();
            tmpInfo.allocInfo.size      = tmp2->Strings[CSV_ALLOCINFO_SIZE].ToInt();
            strcpy(tmpInfo.allocInfo.filename, tmp2->Strings[CSV_ALLOCINFO_FILE].c_str());
            tmpInfo.allocInfo.line_num  = tmp2->Strings[CSV_ALLOCINFO_LINE].ToInt();
            tmpInfo.count               = tmp2->Strings[CSV_ALLOCINFO_COUNT].ToInt();

            allocWithCountMap[tmpInfo.allocInfo.addr] = tmpInfo;

		    // R|[lgǉ
		    CreateAllocComponent(&tmpInfo.allocInfo);

		    // JE^
		    heapCounter[ALL_VIEW].usedSize += tmpInfo.allocInfo.size;
		    heapCounter[ALL_VIEW].allocNum++;
		    heapCounter[GetParentID(tmpInfo.allocInfo.heapID)].usedSize += tmpInfo.allocInfo.size;
		    heapCounter[GetParentID(tmpInfo.allocInfo.heapID)].allocNum++;
		}
		
        delete tmp;
        delete tmp2;
    }

    //ŌAllocCount炤
    {
    	allocCount = lines->Strings[cnt].ToInt();
    }

    }
    catch(...)
    {
        ShowMessage("error:CreateInfoFromFile");
    }

    delete lines;

    UpdateList();
    UpdateCounter();

}

