//---------------------------------------------------------------------------

#ifndef MoniterUnitH
#define MoniterUnitH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>
#include <Menus.hpp>

#include <map>
#include "memSnatcher.h"
#include "ext_if.h"
//---------------------------------------------------------------------------

#define ALLOC_MONITER_RANGE 800U // Alloc\͈́iTCYbytej
#define ALLOC_BYTE_PER_PIXEL 4U  // AllocMoniterł1PIXELBYTEɑ邩

class TMoniterForm : public TForm
{
__published:	// IDE Ǘ̃R|[lg
    TTimer *MoniterTimer;
    TLabel *HeapHiLabel;
    TLabel *HeapLoLabel;
    TLabel *HeapMoniterLabel;
    TShape *HeapMoniterShape1;
    TShape *HeapMoniterShape2;
    TLabel *AllocMoniterLabel;
    TShape *AllocMoniterShape2;
    TShape *AllocMoniterShape1;
    TLabel *ListLabel;
    TShape *ListShape2;
    TShape *ListShape1;
    TLabel *AllocMoniterCurrentLabel;
    TPanel *HeapMoniterPanel;
    TPageControl *ListPageControl;
    TTabSheet *AllocListTab;
    TStringGrid *AllocListSG;
    TTabSheet *HeapListTab;
    TStringGrid *HeapListSG;
    TPanel *AllocMoniterPanel;
    TEdit *AllocMoniterEdit;
    TButton *AllocMoniterButton;
    TRadioGroup *GrepRadio;
    TShape *CounterShape1;
    TShape *CounterShape2;
    TLabel *CounterLabel;
    TStringGrid *CounterSG;
    TProgressBar *MemPerBar;
    TLabel *TotalPerLabel;
    TLabel *TotalPerLabel2;
    TLabel *MemPerLabel2;
    TShape *MemUsedShape2;
    TShape *MemUsedShape1;
    TLabel *TotalLabel;
    TProgressBar *SystemPerBar;
    TLabel *SystemPerLabel;
    TLabel *SystemPerLabel2;
    TLabel *SystemLabel;
    TProgressBar *SavePerBar;
    TLabel *SavePerLabel;
    TLabel *SavePerLabel2;
    TLabel *SaveLabel;
    TProgressBar *DebugPerBar;
    TLabel *DebugPerLabel;
    TLabel *DebugPerLabel2;
    TLabel *DebugLabel;
    TProgressBar *AppPerBar;
    TLabel *AppPerLabel;
    TLabel *AppPerLabel2;
    TLabel *AppLabel;
    TPopupMenu *AllocListMenu;
    TMenuItem *addToBreak;
    TMenuItem *goToLine;
	TMenuItem *ShowAllocBreak;
    void __fastcall MoniterTimerTimer(TObject *Sender);
    void __fastcall ListPageControlChange(TObject *Sender);
    void __fastcall AllocMoniterButtonClick(TObject *Sender);
    void __fastcall AllocListSGSelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
    void __fastcall HeapListSGSelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
    void __fastcall GrepRadioClick(TObject *Sender);
    void __fastcall FormPaint(TObject *Sender);
    void __fastcall addToBreakClick(TObject *Sender);
    void __fastcall AllocListSGContextPopup(TObject *Sender,
          TPoint &MousePos, bool &Handled);
	void __fastcall ShowAllocBreakClick(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
private:	// [U[錾
    //-- typedef
    typedef enum
    {
        SYSTEM_VIEW = 0,
        SAVE_VIEW,
        DEBUG_VIEW,
        APP_VIEW,
        ALL_VIEW,
        VIEW_NUM
    }ShowMode;
    typedef struct
    {
        unsigned int heapNum;
        unsigned int allocNum;
        unsigned int usedSize;
    }HeapCounter;
    typedef struct
    {
        TProgressBar*   perBar;
        TLabel*         perLabel;
        TLabel*         perLabel2;
    }CounterComponent;

    //-- ϐS
    TPanel*             programPanel;
    std::map<unsigned int, TPanel*> heapPanelMap;
    std::map<unsigned int, TPanel*> allocPanelMap;
    std::map<unsigned int, HeapInfo> heapMap;                       // Heap񂻂̂̂Map
    std::map<unsigned int, AllocInfoWithCounter> allocWithCountMap; // JE^[tAlloc񂻂̂̂Map
    unsigned int        allocMoniterTrgAddr;            // ALLOC_MONITER_RANGEPanel\
    BOOL                isNeedUpdate;                   // `Abvf[gKvǂFlag
    HeapCounter         heapCounter[VIEW_NUM];
    CounterComponent    counterComponents[VIEW_NUM];
    BOOL                isConnected;
    TCanvas*            hiLine;
    unsigned long       allocCount;
    unsigned long       rightClickAddr;
    IExtIF				*m_pExtIF;
    AnsiString			m_MyDir;
    AnsiString			m_ModuleName;
    BOOL				m_ShowBreak;
    AnsiString          m_BreakFilePath;

    //-- ֐S
    void    UpdateMoniter();        // \Abvf[g
    void    UpdateList();           // Alloc/Heap List Abvf[g
    void    UpdateCounter();

    void    AddAllocInfo(AllocInfo* newInfo);       // MapAllocǉ
    void    RemoveAllocInfo(AllocInfo* newInf);     // MapAlloc폜
    void    AddHeapInfo(HeapInfo* newInfo);         // MapHeapǉ
    void    RemoveHeapInfo(HeapInfo* newInfo);      // MapHeap폜

    void    InitFormComponent();                    // Form̃R|[lg̏
    void    CreateHeapComponent(HeapInfo* newInfo);     // HeapPanelR|[lg𐶐
    void    CreateAllocComponent(AllocInfo *newInfo);   // AllocPanelR|[lg𐶐

    void    InitCounter();   // Heap Alloc JE^[̏

    void    DrawAllocRange();
    void    LoadIni();
    void    SaveIni();
	void __fastcall BreakFormClose(TObject *Sender, TCloseAction &Action);

protected:
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);

public:		// [U[錾
	static HWND		m_TempParent;

    __fastcall TMoniterForm(TComponent* Owner);

    //-- J֐S
    void Init(IExtIF *ext_if, AnsiString path_name, AnsiString module_name, HWND top_wnd);
    void Finish();
    void    SetMemInfo(MemInfo* newInfo);     // g͕ȂInfo炤
    unsigned int    GetParentID(unsigned int heapID);
    void    ResetMoniter();
    void Show();
    void SaveAllocInfo(TStream *st);        // Sۑ
    void CreateInfoFromFile(TStream *st);   // ōCSVt@CɏԂ𕜌
};
//---------------------------------------------------------------------------
extern PACKAGE TMoniterForm *MoniterForm;
//---------------------------------------------------------------------------
#endif
