#ifndef MEM_SEND_H__
#define MEM_SEND_H__

#define MEMBLOCK_FILENAME_AREASIZE		(12)	// fobOpwb_Ɋi[t@C̈TCY
#define NITRO_MAX_MEM_SIZE              (0x400000)  // fobO͖
#define NITRO_MEM_ADDR_START            (0x2000000)
#define NITRO_MEM_ADDR_END              (0x23FFFFF)

#include "heapdefine.h"
#include "heapnames.h"

typedef enum
{
	ALLOC_INFO = 0,
	FREE_INFO,
	CREATE_HEAP_INFO,
    DELETE_HEAP_INFO
}MsgType;

typedef struct		// sizeof(AllocInfo)̐{MAX_SEND_NUMƈvKv
{
	unsigned int	heapID;
	unsigned int	size;
	unsigned int	line_num;
	unsigned int    addr;
	char			filename[MEMBLOCK_FILENAME_AREASIZE];
}AllocInfo;

typedef enum
{
    CSV_ALLOCINFO_ADDR = 0,
    CSV_ALLOCINFO_HEAPID,
    CSV_ALLOCINFO_SIZE,
    CSV_ALLOCINFO_FILE,
    CSV_ALLOCINFO_LINE,
    CSV_ALLOCINFO_COUNT
}CSVAllocInfo;


typedef struct		// AllocInfoƃTCYvĂKv
{
	unsigned int	heapID;
	unsigned int	parentID;
   	unsigned int	size;
	unsigned int    addr;
}HeapInfo;

typedef enum
{
    CSV_HEAPINFO_ADDR = 0,
   	CSV_HEAPINFO_HEAPID,
	CSV_HEAPINFO_PARENTID,
	CSV_HEAPINFO_SIZE

}CSVHeapInfo;



typedef struct
{
	unsigned int	type;
	union
	{
		AllocInfo	allocInfo;
		HeapInfo	heapInfo;
	};
}MemInfo;

typedef struct
{
    unsigned long   count;
    AllocInfo       allocInfo;
}AllocInfoWithCounter;

typedef struct
{
    unsigned int    addr;           //AhX
    unsigned int    heapID;         //q[vID
    AnsiString      fileLine;       //ǂ̃t@C̉sڂ
    unsigned int    count;          //ڂŎ~߂邩
    //unsigned long   frame;        //~t[ij
    bool            enable;         //S̗L
    bool            enableAddr;     //AhXu[NL
    bool            enableHeapID;   //HeapIDu[NL
    bool            enableFileLine; //Cu[NL
    bool            enableCount;    //AllocJE^u[NL
}BreakInfo;

typedef enum
{
    MASK_ADDR = 1,
    MASK_HEAP = 2,
    MASK_LINE = 4,
    MASK_COUNT = 8,
}BreakMask;

#endif // MEM_SEND__
