#include "ensata_interface.h"
#include "int_ensata_interface.h"

//----------------------------------------------------------
// vOCݒB
//----------------------------------------------------------
void CEnsataIF::SetPlugin(IPluginBase *plugin)
{
	Ensata::IFInfo	*info = est_get_info();

	info->plugin = plugin;
}

//----------------------------------------------------------
// [_\JnB
//----------------------------------------------------------
BOOL CEnsataIF::BeginModal()
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return FALSE;
	}
	return info->func.begin_modal(info->plugin_id);
}

//----------------------------------------------------------
// [_\IB
//----------------------------------------------------------
void CEnsataIF::EndModal()
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.end_modal(info->plugin_id);
}

//----------------------------------------------------------
// [hB
//----------------------------------------------------------
void CEnsataIF::ReadMemory(unsigned long addr, unsigned long size, void *data)
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.read_memory(addr, size, data);
}

//----------------------------------------------------------
// VRAM[hB
//----------------------------------------------------------
void CEnsataIF::ReadVram(unsigned long kind, unsigned long offset, unsigned long size, void *data)
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.read_vram(kind, offset, size, data);
}

//----------------------------------------------------------
// SVRAM[hB
//----------------------------------------------------------
void CEnsataIF::ReadVramAll(Ensata::VramData *data)
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.read_vram_all(data);
}

//----------------------------------------------------------
// ensata~ʒmR[obNݒB
//----------------------------------------------------------
void CEnsataIF::SetBreakCallback(Ensata::BREAK_CALLBACK func, void *arg)
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.set_break_callback(func, arg);
}

//----------------------------------------------------------
// f[^M@\B
//----------------------------------------------------------
void CEnsataIF::CommInit(const char *id_str, const Ensata::CommCallback *func,
	void *arg, long *id)
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.comm_init(id_str, func, arg, id);
}

//----------------------------------------------------------
// f[^M@\f[^MB
//----------------------------------------------------------
void CEnsataIF::CommSend(long id, const unsigned long *data, unsigned long size)
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.comm_send(id, data, size);
}

//----------------------------------------------------------
// s~B
//----------------------------------------------------------
void CEnsataIF::Stop()
{
	Ensata::IFInfo	*info = est_get_info();

	if (!info->init) {
		return;
	}
	info->func.stop();
}
