#ifndef	INT_ENSATA_INTERFACE_H
#define	INT_ENSATA_INTERFACE_H

#include "common.h"
#include "plugin_base.h"
#include "ensata_interface.h"

namespace Ensata {

//----------------------------------------------------------
// EnsataC^tF[X\́B
//----------------------------------------------------------
struct IFInfo {
	BOOL			init;
	void			*plugin_id;
	IPluginBase		*plugin;
	// ensataT[rX֐B
	struct Func {
		typedef BOOL (__cdecl *BEGIN_MODAL)(void *);
		typedef void (__cdecl *END_MODAL)(void *);
		typedef void (__cdecl *READ_MEMORY)(u32, u32, void *);
		typedef void (__cdecl *READ_VRAM)(u32, u32, u32, void *);
		typedef void (__cdecl *READ_VRAM_ALL)(Ensata::VramData *);
		typedef void (__cdecl *SET_BREAK_CALLBACK)(Ensata::BREAK_CALLBACK, void *);
		typedef void (__cdecl *COMM_INIT)(const char *, const Ensata::CommCallback *,
			void *, s32 *);
		typedef void (__cdecl *COMM_SEND)(s32, const u32 *, u32);
		typedef void (__cdecl *STOP)();

		BEGIN_MODAL			begin_modal;
		END_MODAL			end_modal;
		READ_MEMORY			read_memory;
		READ_VRAM			read_vram;
		READ_VRAM_ALL		read_vram_all;
		SET_BREAK_CALLBACK	set_break_callback;
		COMM_INIT			comm_init;
		COMM_SEND			comm_send;
		STOP				stop;
	} func;
};

}

Ensata::IFInfo *est_get_info();

#endif
