#include "int_ensata_interface.h"
#include "ensata_interface.h"
#include "common.h"

#define EXPORT extern "C" __declspec(dllexport)

static Ensata::IFInfo		s_info = {
	FALSE,
};

//----------------------------------------------------------
// vOC̃o[W擾B
//----------------------------------------------------------
EXPORT u32 __cdecl est_get_ver()
{
	return PLUGIN_VER;
}

//----------------------------------------------------------
// vOC̏B
//----------------------------------------------------------
EXPORT void __cdecl est_init_plugin(HMODULE hexe, HWND top_wnd, u32 lang,
	const char *path_name, char *name, int size, void *plugin_id)
{
	Ensata::IFInfo	*info = est_get_info();
	IPluginBase		*plugin = info->plugin;

	s_info.init = TRUE;
	s_info.plugin_id = plugin_id;
	info->func.begin_modal = (Ensata::IFInfo::Func::BEGIN_MODAL)::GetProcAddress(hexe, "ensata_begin_modal");
	info->func.end_modal = (Ensata::IFInfo::Func::END_MODAL)::GetProcAddress(hexe, "ensata_end_modal");
	info->func.read_memory = (Ensata::IFInfo::Func::READ_MEMORY)::GetProcAddress(hexe, "ensata_read_memory");
	info->func.read_vram = (Ensata::IFInfo::Func::READ_VRAM)::GetProcAddress(hexe, "ensata_read_vram");
	info->func.read_vram_all = (Ensata::IFInfo::Func::READ_VRAM_ALL)::GetProcAddress(hexe, "ensata_read_vram_all");
	info->func.set_break_callback = (Ensata::IFInfo::Func::SET_BREAK_CALLBACK)::GetProcAddress(hexe, "ensata_set_break_callback");
	info->func.comm_init = (Ensata::IFInfo::Func::COMM_INIT)::GetProcAddress(hexe, "ensata_comm_init");
	info->func.comm_send = (Ensata::IFInfo::Func::COMM_SEND)::GetProcAddress(hexe, "ensata_comm_send");
	info->func.stop = (Ensata::IFInfo::Func::STOP)::GetProcAddress(hexe, "ensata_stop");

	if (plugin) {
		plugin->Attach(top_wnd, path_name);
		plugin->Name(lang, name, size);
	} else if (0 < size) {
		name[0] = '\0';
	}
}

//----------------------------------------------------------
// vOČ㏈B
//----------------------------------------------------------
EXPORT void __cdecl est_release_plugin()
{
	IPluginBase		*plugin = s_info.plugin;

	if (plugin) {
		plugin->Detach();
	}
}

//----------------------------------------------------------
// vOCsB
//----------------------------------------------------------
EXPORT void __cdecl est_execute()
{
	IPluginBase		*plugin = s_info.plugin;

	if (plugin) {
		plugin->Execute();
	}
}

//----------------------------------------------------------
// 擾B
//----------------------------------------------------------
Ensata::IFInfo *est_get_info()
{
	return &s_info;
}
