#include <vcl.h>
#pragma hdrstop
#include "main.h"
#include "plugin_base.h"
#include "ensata_interface.h"
#include "common.h"
#include "MoniterUnit.h"
#include "BreakUnit.h"
#include "ext_if.h"

//----------------------------------------------------------
// CNXB
//----------------------------------------------------------
class CMain : public IPluginBase, public IExtIF {
private:
	s32								m_Id;
	AnsiString						m_PluginName;
	TMemoryStream					*m_Mem;
	BOOL							m_Enabled;
	static Ensata::CommCallback		m_Func;

	void CommReset();
	void CommRecv(const u32 *data, u32 size);
	u32 CommSnapPresave();
	void CommSnapSave(u8 *buf);
	void CommSnapLoad(const u8 *buf, u32 size);
	static void __cdecl CommResetCallback(void *arg);
	static void __cdecl CommRecvCallback(void *arg, const u32 *data, u32 size);
	static u32 __cdecl CommSnapPresaveCallback(void *arg);
	static void __cdecl CommSnapSaveCallback(void *arg, u8 *buf);
	static void __cdecl CommSnapLoadCallback(void *arg, const u8 *buf, u32 size);

public:
	// IPluginBaseB
	virtual void Attach(HWND top_wnd, const char *path_name);
	virtual void Detach();
	virtual void Name(unsigned long lang, char *name, unsigned long size);
	virtual void Execute();
	// IExtIFB
	virtual void EngineStop();
};

static CMain			mn;
Ensata::CommCallback	CMain::m_Func = {
	CommResetCallback, CommRecvCallback,
	CommSnapPresaveCallback, CommSnapSaveCallback, CommSnapLoadCallback
};

//----------------------------------------------------------
// B
//----------------------------------------------------------
void init()
{
	CEnsataIF::SetPlugin(&mn);
}

//----------------------------------------------------------
// A^b`B
//----------------------------------------------------------
void CMain::Attach(HWND top_wnd, const char *path_name)
{
	m_Enabled = TRUE;
	m_PluginName = ExtractFileName(path_name);
	CreateDir(path_name);
	TMoniterForm::m_TempParent = top_wnd;
	MoniterForm = new TMoniterForm(NULL);
	MoniterForm->Init(this, path_name, m_PluginName, top_wnd);
	CEnsataIF::CommInit("MemSnatcher", &m_Func, this, &m_Id);
}

//----------------------------------------------------------
// f^b`B
//----------------------------------------------------------
void CMain::Detach()
{
	MoniterForm->Finish();
	delete MoniterForm;
}

//----------------------------------------------------------
// vOCB
//----------------------------------------------------------
void CMain::Name(unsigned long lang, char *name, unsigned long size)
{
	if (0 < size) {
		strncpy(name, m_PluginName.c_str(), size);
		name[size - 1] = '\0';
	}
}

//----------------------------------------------------------
// vOCsB
//----------------------------------------------------------
void CMain::Execute()
{
	MoniterForm->Show();
}

//----------------------------------------------------------
// GWXgbvB
//----------------------------------------------------------
void CMain::EngineStop()
{
	CEnsataIF::Stop();
	if (!BreakForm->Visible) {
		ShowMessage("MemSnatcherŃu[N܂B");
	}
}

//----------------------------------------------------------
// ZbgB
//----------------------------------------------------------
void CMain::CommReset()
{
	m_Enabled = TRUE;
	MoniterForm->ResetMoniter();
}

//----------------------------------------------------------
// MB
//----------------------------------------------------------
void CMain::CommRecv(const u32 *data, u32 size)
{
	MemInfo		*ai;

	if (m_Enabled) {
		MoniterForm->SetMemInfo((MemInfo *)data);
	}
}

//----------------------------------------------------------
// XibvVbgۑR[obNB
//----------------------------------------------------------
u32 CMain::CommSnapPresave()
{
	m_Mem = new TMemoryStream();
	MoniterForm->SaveAllocInfo(m_Mem);
	return m_Mem->Size;
}

//----------------------------------------------------------
// XibvVbgۑR[obNB
//----------------------------------------------------------
void CMain::CommSnapSave(u8 *buf)
{
	m_Mem->Seek(0, soFromBeginning);
	m_Mem->Read(buf, m_Mem->Size);
	delete m_Mem;
}

//----------------------------------------------------------
// XibvVbgۑR[obNB
//----------------------------------------------------------
void CMain::CommSnapLoad(const u8 *buf, u32 size)
{
	if (buf == NULL) {
		MoniterForm->ResetMoniter();
		m_Enabled = FALSE;
		return;
	}
	m_Mem = new TMemoryStream();
	m_Mem->Write(buf, size);
	m_Mem->Seek(0, soFromBeginning);
	MoniterForm->CreateInfoFromFile(m_Mem);
	delete m_Mem;
}

//----------------------------------------------------------
// ZbgR[obNB
//----------------------------------------------------------
void CMain::CommResetCallback(void *arg)
{
	CMain	*obj = (CMain *)arg;

	obj->CommReset();
}

//----------------------------------------------------------
// MR[obNB
//----------------------------------------------------------
void CMain::CommRecvCallback(void *arg, const u32 *data, u32 size)
{
	CMain	*obj = (CMain *)arg;

	obj->CommRecv(data, size);
}

//----------------------------------------------------------
// XibvVbgۑR[obNB
//----------------------------------------------------------
u32 CMain::CommSnapPresaveCallback(void *arg)
{
	CMain	*obj = (CMain *)arg;

	return obj->CommSnapPresave();
}

//----------------------------------------------------------
// XibvVbgۑR[obNB
//----------------------------------------------------------
void CMain::CommSnapSaveCallback(void *arg, u8 *buf)
{
	CMain	*obj = (CMain *)arg;

	obj->CommSnapSave(buf);
}

//----------------------------------------------------------
// XibvVbgۑR[obNB
//----------------------------------------------------------
void CMain::CommSnapLoadCallback(void *arg, const u8 *buf, u32 size)
{
	CMain	*obj = (CMain *)arg;

	obj->CommSnapLoad(buf, size);
}
