#ifndef __ISNITRODLL_H__
#define __ISNITRODLL_H__

///////////////////////////////////////////////////////////////////////////////////////////////
///
/// Copyright (C) 2003-2005 INTELLIGENT SYSTEMS Co., Ltd.
/// All rights reserved.
///
/// IS-NITRO-EMULATOR [ISNITRO.DLL]
///
///////////////////////////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
extern "C" {
#endif

#if     defined(NITRODLL_EXPORT)
 #define    NITRODllImport   __declspec( dllexport )
#else
 #define    NITRODllImport   __declspec( dllimport )
#endif
// DLL
#define     NITROEMUDLL_NAME    "ISNITRO.DLL"

typedef enum enumNITROArch {
    NITROArchARM9,
    NITROArchARM7
} NITROArch;

///////////////////////////////////////////////////////////////////////////////////////////////
// DLL Import

typedef struct  _NITROFINDHANDLE*   NITROFINDHANDLE;
typedef struct  _NITRODEVICEHANDLE* NITRODEVICEHANDLE;
typedef unsigned long               NITRODEVICEID;
typedef void                        (_cdecl *NITROSTREAMCALLBACKFUNC)( DWORD dwUserValue, WORD nChmStream, const void *pBufRecv, DWORD nSizeRecv );
typedef BOOL                        (_cdecl *NITROTOOLAPI_ENUMDEV_CALLBACKFUNC)( NITRODEVICEID nDevice, DWORD dwUser );

NITRODllImport  NITROFINDHANDLE     NITROToolAPIFindOpen( void );
NITRODllImport  BOOL                NITROToolAPIFindNext(NITROFINDHANDLE hFind, NITRODEVICEID* pnDeviceID);
NITRODllImport  void                NITROToolAPIFindClose(NITROFINDHANDLE hFind);
NITRODllImport  NITRODEVICEHANDLE   NITROToolAPIDeviceOpen(NITRODEVICEID nDeviceID);
NITRODllImport  BOOL                NITROToolAPICheckConnect(NITRODEVICEHANDLE hNITRO);
NITRODllImport  void                NITROToolAPIDeviceClose(NITRODEVICEHANDLE hNITRO);
NITRODllImport  INT                 NITROToolAPIWriteROM(NITRODEVICEHANDLE hNITRO, const void* pBuf, ULONG nAdrs, ULONG nLength);
NITRODllImport  INT                 NITROToolAPIReadROM(NITRODEVICEHANDLE hNITRO, void* pBuf, ULONG nAdrs, ULONG nLength);
NITRODllImport  BOOL                NITROToolAPIGetROMSize(NITRODEVICEHANDLE hNITRO, ULONG *pnSize );
NITRODllImport  BOOL                NITROToolAPIReset(NITRODEVICEHANDLE hNITRO, BOOL bOnOff);
NITRODllImport  BOOL                NITROToolAPISyncWriteROM(NITRODEVICEHANDLE hNITRO, const void* pBuf, ULONG nAdrs, ULONG nLen);
NITRODllImport  BOOL                NITROToolAPISyncReadROM(NITRODEVICEHANDLE hNITRO, void* pBuf, ULONG nAdrs, ULONG nLen);
NITRODllImport  BOOL                NITROToolAPIStreamWrite(NITRODEVICEHANDLE hNITRO, USHORT nChn, const void* pBuf, ULONG nLen);
NITRODllImport  BOOL                NITROToolAPIStreamGetWritableLength(NITRODEVICEHANDLE hNITRO, ULONG *pLength );
NITRODllImport  BOOL                NITROToolAPISetReceiveStreamCallBackFunction(NITRODEVICEHANDLE hNITRO, NITROSTREAMCALLBACKFUNC cbFunc, DWORD dwUserValue );
NITRODllImport  BOOL                NITROToolAPICheckStreamReceive( NITRODEVICEHANDLE hNITRO );
NITRODllImport  BOOL                NITROToolAPISetSyncTimeout(NITRODEVICEHANDLE hNITRO, UINT nTimeoutMillSecond);
NITRODllImport  BOOL                NITROToolAPIGetDebugPrint(NITRODEVICEHANDLE hNITRO, NITROArch nArch, void *pBuf, INT *pnResult, INT nBufSize );
NITRODllImport  BOOL                NITROToolAPICardSlotPower(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
NITRODllImport  BOOL                NITROToolAPICartridgeSlotPower(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
NITRODllImport  BOOL                NITROToolAPICardSlotAutoPowerOff(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
NITRODllImport  BOOL                NITROToolAPICartridgeSlotAutoPowerOff(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
NITRODllImport  DWORD               NITROToolAPIGetLastError(NITRODEVICEHANDLE hNITRO);
NITRODllImport  BOOL                NITROToolAPIGetPowerStatus(NITRODEVICEHANDLE hNITRO, DWORD *pdwPowerMask );
NITRODllImport  UINT                NITROToolAPIGetErrorMessage(DWORD dwError, CHAR* buf, UINT nBufSize);

///////////////////////////////////////////////////////////////////////////////////////////////
// Dynamic Load

#define NITRO_FUNC_FINDOPEN             "NITROToolAPIFindOpen"
#define NITRO_FUNC_FINDNEXT             "NITROToolAPIFindNext"
#define NITRO_FUNC_FINDCLOSE            "NITROToolAPIFindClose"
#define NITRO_FUNC_SELECTOR             "NITROToolAPISelector"
#define NITRO_FUNC_OPEN                 "NITROToolAPIDeviceOpen"
#define NITRO_FUNC_CHECKCONNECT         "NITROToolAPICheckConnect"
#define NITRO_FUNC_CLOSE                "NITROToolAPIDeviceClose"
#define NITRO_FUNC_RESET                "NITROToolAPIReset"
#define NITRO_FUNC_READROM              "NITROToolAPIReadROM"
#define NITRO_FUNC_WRITEROM             "NITROToolAPIWriteROM"
#define NITRO_FUNC_SYNC_WRITEROM        "NITROToolAPISyncWriteROM"
#define NITRO_FUNC_SYNC_READROM         "NITROToolAPISyncReadROM"
#define NITRO_FUNC_ROMSIZE              "NITROToolAPIGetROMSize"
#define NITRO_FUNC_SET_SYNCTIMEOUT      "NITROToolAPISetSyncTimeout"
#define NITRO_FUNC_CHECKPOWER           "NITROToolAPIGetPowerStatus"
#define NITRO_FUNC_STREAM_WRITE         "NITROToolAPIStreamWrite"
#define NITRO_FUNC_STREAM_GETWL         "NITROToolAPIStreamGetWritableLength"
#define NITRO_FUNC_STREAM_SETCB         "NITROToolAPISetReceiveStreamCallBackFunction"
#define NITRO_FUNC_STREAM_CHECK         "NITROToolAPICheckStreamReceive"
#define NITRO_FUNC_DEBUGPRINT           "NITROToolAPIGetDebugPrint"
#define NITRO_FUNC_CARDSLOTPOWER        "NITROToolAPICardSlotPower"
#define NITRO_FUNC_CARTSLOTPOWER        "NITROToolAPICartridgeSlotPower"
#define NITRO_FUNC_CARDSLOTAUTOPOWEROFF "NITROToolAPICardSlotAutoPowerOff"
#define NITRO_FUNC_CARTSLOTAUTOPOWEROFF "NITROToolAPICartridgeSlotAutoPowerOff"
#define NITRO_FUNC_GETLASTERROR         "NITROToolAPIGetLastError"
#define NITRO_FUNC_GETERRORMESSAGE      "NITROToolAPIGetErrorMessage"

typedef NITROFINDHANDLE             (_cdecl *NITROTOOLAPI_FINDOPEN)();
typedef BOOL                        (_cdecl *NITROTOOLAPI_FINDNEXT)(NITROFINDHANDLE hFind, NITRODEVICEID* pnDeviceValue);
typedef void                        (_cdecl *NITROTOOLAPI_FINDCLOSE)(NITROFINDHANDLE hFind);
typedef BOOL                        (_cdecl *NITROTOOLAPI_DEVSELECTOR)( NITROTOOLAPI_ENUMDEV_CALLBACKFUNC funcCB, DWORD dwUser, HWND hWndParent, NITRODEVICEID *pDeviceID );
typedef NITRODEVICEHANDLE           (_cdecl *NITROTOOLAPI_OPEN)(NITRODEVICEID nDeviceValue);
typedef BOOL                        (_cdecl *NITROTOOLAPI_CHECKCONNECT)(NITRODEVICEHANDLE hNITRO);
typedef VOID                        (_cdecl *NITROTOOLAPI_CLOSE)(NITRODEVICEHANDLE hNITRO);
typedef BOOL                        (_cdecl *NITROTOOLAPI_RESET)(NITRODEVICEHANDLE hNITRO, BOOL bOnOff);
typedef INT                         (_cdecl *NITROTOOLAPI_WRITEROM)(NITRODEVICEHANDLE hNITRO, const void* pBuf, ULONG nAdrs, ULONG nLen);
typedef INT                         (_cdecl *NITROTOOLAPI_READROM)(NITRODEVICEHANDLE hNITRO, void* pBuf, ULONG nAdrs, ULONG nLen);
typedef BOOL                        (_cdecl *NITROTOOLAPI_SYNCWRITE)(NITRODEVICEHANDLE hNITRO, const void* pBuf, ULONG nAdrs, ULONG nLen);
typedef BOOL                        (_cdecl *NITROTOOLAPI_SYNCREAD)(NITRODEVICEHANDLE hNITRO, void* pBuf, ULONG nAdrs, ULONG nLen);
typedef BOOL                        (_cdecl *NITROTOOLAPI_ROMSIZE)(NITRODEVICEHANDLE hNITRO, ULONG *pnSize );
typedef BOOL                        (_cdecl *NITROTOOLAPI_SETSYNCTIMEOUT)(NITRODEVICEHANDLE hNITRO, UINT nMillSecondTimeOut);
typedef BOOL                        (_cdecl *NITROTOOLAPI_STREAMWRITE)(NITRODEVICEHANDLE hNITRO, USHORT nChn, const void* pBuf, ULONG nLen);
typedef BOOL                        (_cdecl *NITROTOOLAPI_STREAMGETWRITABLELEN)(NITRODEVICEHANDLE hNITRO, ULONG *pLength);
typedef BOOL                        (_cdecl *NITROTOOLAPI_STREAMSETCB)(NITRODEVICEHANDLE hNITRO, NITROSTREAMCALLBACKFUNC cbFunc, DWORD dwUserData);
typedef BOOL                        (_cdecl *NITROTOOLAPI_STREAMCHKRECV)(NITRODEVICEHANDLE hNITRO);
typedef BOOL                        (_cdecl *NITROTOOLAPI_GETDEBUGPRINT)(NITRODEVICEHANDLE hNITRO, NITROArch nArch, void *pBuf, INT *pnResult, INT nBufSize );
typedef DWORD                       (_cdecl *NITROTOOLAPI_GETLASTERROR)(NITRODEVICEHANDLE hNITRO);
typedef BOOL                        (_cdecl *NITROTOOLAPI_CARDSLOTPOWER)(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
typedef BOOL                        (_cdecl *NITROTOOLAPI_CARTRIDGESLOTPOWER)(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
typedef BOOL                        (_cdecl *NITROTOOLAPI_CARDSLOTAUTOPOWEROFF)(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
typedef BOOL                        (_cdecl *NITROTOOLAPI_CARTRIDGESLOTAUTOPOWEROFF)(NITRODEVICEHANDLE hNITRO, BOOL bEnable);
typedef BOOL                        (_cdecl *NITROTOOLAPI_CHECKPOWER)(NITRODEVICEHANDLE hNITRO, DWORD *pdwPowerMask );
typedef UINT                        (_cdecl *NITROTOOLAPI_GETERRORMESSAGE)(DWORD dwError, CHAR* buf, UINT nBufSize);


///////////////////////////////////////////////////////////////////////////////////////////////
// Device Value

enum enumNITRODevice {
    NITRODeviceCGBUSB       =   0x00000000,
    NITRODeviceCGBSCSI      =   0x10000000,
    NITRODeviceNITROUSB     =   0x20000000,
    NITRODeviceNITROUIC     =   0x30000000,
    NITRODeviceNITRODBG     =   0x40000000,
    NITRODeviceMASK         =   0xf0000000
};

#define MASK_SERIAL         0x0fffffff
#define MASK_CGBSCSIHOST    0x000000f0
#define MASK_CGBSCSIID      0x0000000f

#define MAKEDEVICEVALUE_CGBSCSI(nHost, nID) (NITRODeviceCGBSCSI | (nHost << 4) | (nID & 15))
#define MAKEDEVICEVALUE_CGBUSB(nSerial)     (NITRODeviceCGBUSB | nSerial)
#define MAKEDEVICEVALUE_NITROUSB(nSerial)   (NITRODeviceNITROUSB | nSerial)
#define MAKEDEVICEVALUE_NITROUIC(nSerial)   (NITRODeviceNITROUIC | nSerial)
#define MAKEDEVICEVALUE_NITRODBG(nSerial)   (NITRODeviceNITRODBG | nSerial)

#define IS_DEVICE_CGBUSB(nDeviceValue)      (((nDeviceValue & NITRODeviceMASK) == NITRODeviceCGBUSB ) ? TRUE : FALSE)
#define IS_DEVICE_CGBSCSI(nDeviceValue)     (((nDeviceValue & NITRODeviceMASK) == NITRODeviceCGBSCSI) ? TRUE : FALSE)
#define IS_DEVICE_NITROUSB(nDeviceValue)    (((nDeviceValue & NITRODeviceMASK) == NITRODeviceNITROUSB ) ? TRUE : FALSE)
#define IS_DEVICE_NITROUIC(nDeviceValue)    (((nDeviceValue & NITRODeviceMASK) == NITRODeviceNITROUIC ) ? TRUE : FALSE)
#define IS_DEVICE_NITRODBG(nDeviceValue)    (((nDeviceValue & NITRODeviceMASK) == NITRODeviceNITRODBG ) ? TRUE : FALSE)

#define GET_CGBUSB_SERIAL(nDeviceValue)     (nDeviceValue & MASK_SERIAL)
#define GET_NITROUSB_SERIAL(nDeviceValue)   (nDeviceValue & MASK_SERIAL)
#define GET_NITROUIC_SERIAL(nDeviceValue)   (nDeviceValue & MASK_SERIAL)
#define GET_NITRODBG_SERIAL(nDeviceValue)   (nDeviceValue & MASK_SERIAL)
#define GET_CGBSCSI_HOST(nDeviceValue)      (((nDeviceValue & MASK_CGBSCSIHOST) >> 4) & 0x0000000f)
#define GET_CGBSCSI_ID(nDeviceValue)        ((nDeviceValue & MASK_CGBSCSIID) & 0x0000000f)

enum enumNITROPowerMask {
    NITROPowerNITRO         =   0x0001,
    NITROPowerADBUS         =   0x0002,
    NITROPowerCARDBUS       =   0x0004,
    NITROPowerJTAG          =   0x0008,
    NITROPowerADBUSSlot     =   0x0010,
    NITROPowerCARDBUSSlot   =   0x0020
};

#define POWER_TARGET(PowerMask)             (((PowerMask) & NITROPowerNITRO) ? TRUE : FALSE )
#define POWER_ADBUS(PowerMask)              (((PowerMask) & NITROPowerADBUS) ? TRUE : FALSE )
#define POWER_CARDBUS(PowerMask)            (((PowerMask) & NITROPowerCARDBUS) ? TRUE : FALSE )
#define POWER_JTAG(PowerMask)               (((PowerMask) & NITROPowerJTAG) ? TRUE : FALSE )
#define POWER_ADBUSSLOT(PowerMask)          (((PowerMask) & NITROPowerADBUSSlot) ? TRUE : FALSE )
#define POWER_CARDBUSSLOT(PowerMask)        (((PowerMask) & NITROPowerCARDBUSSlot) ? TRUE : FALSE )

#undef  NITRODllImport

#ifdef __cplusplus
}
#endif

///////////////////////////////////////////////////////////////////////////////////////////////

#endif /* __ISNITRODLL_H__ */
