// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#pragma hdrstop

#include "BG.h"
#include "usefulFunctions.h"

//---------------------------------------------------------------------------

static const int BLOCK_UNIT = 32;

BG::BG() :
    m_rawData(NULL),
    m_palette(NULL),
    m_exPalette(NULL){
    m_bmp		= new TBITMAP;
    m_scaledBMP	= new TBITMAP;
}


BG::~BG(){
    delete m_bmp;
    delete m_scaledBMP;
}


void BG::SetBGInfo(const BG_Info &info){
    m_info = info;
}


void BG::SetRawData(const char *rawData){
    m_rawData = rawData;
}


void BG::SetNormalPalette(const Palette *palette){
    m_palette = palette;
}


void BG::SetExPalette(Palette *palette){
    m_exPalette = palette;
}


void BG::Init(
          const char      *rawData,
          const Palette   *normalPalette,
          Palette         *exPalette,
          const BG_Info   &info
         )
{
    SetBGInfo(info);
    SetRawData(rawData);
    SetNormalPalette(normalPalette);
    SetExPalette(exPalette);
    SetBMP();
}


TBITMAP*  BG::GetBMP() const{
    return m_scaledBMP;
    //return m_bmp;
}


bool BG::IsPaletteNormal(){
    return !m_info.extendedPalette;
}


int  BG::GetPaletteNum(int x, int y){
    int paletteNum = 0;
    switch(m_info.type){
        case TEXT_BG:
        case EXTENDED_AFFINE_BG:
        {
            unsigned short screenData = GetScreenDataFromMousePosition(x, y);

            //XN[f[^pbgԍ擾
            paletteNum = (screenData >> 12) & 0x000f;
        }
        break;

        default:
        break;
    }
    return paletteNum;
}


int  BG::GetSlotNum(int x, int y){
    if(m_info.extendedPalette){ return m_info.slotNum;  }
    else {                      return -1;              }
}


int  BG::GetCharaDataOffset(int x, int y){
    int charaOffset = UsefulFunctions::GetOffset(   m_info.charaBaseOffset, charaBaseOffsetSize,
                                                    m_info.charaBaseBlock, charaBaseBlockSize);
    switch(m_info.type){
        case TEXT_BG:
        case EXTENDED_AFFINE_BG:
        {
            unsigned short screenData   = GetScreenDataFromMousePosition(x, y);
            unsigned short charaName    = (screenData & 0x03ff);
            charaOffset += (charaName * m_info.charaDataSize);
        }
        break;

        case AFFINE_BG:
        {
            unsigned char charaName = GetCharaDataFromMousePosition(x, y);
            charaOffset += (charaName * m_info.charaDataSize);
        }
        break;

        case BITMAP_BG:
        default:
            //ShowMessage("Error: invalid BG type!");
        break;
    }

    return charaOffset;
}


void BG::SetBMP(){
    if(m_info.enable == false){
        m_bmp->Width    = 0;
        m_bmp->Height   = 0;
        m_scaledBMP->Assign(m_bmp);
        return;
    }

    m_bmp->Width    = m_info.screenWidth;
    m_bmp->Height   = m_info.screenHeight;

    switch(m_info.type){
        case TEXT_BG:
            SetBMP_TEXT();
        break;

        case AFFINE_BG:
            m_info.charaDataSize = 64;
            SetBMP_AFFINE();
        break;

        case EXTENDED_AFFINE_BG:
            m_info.charaDataSize = 64;
            SetBMP_ExAFFINE();
        break;

        case BITMAP_BG:
            SetBMP_BITMAP();
        break;

        default:
            //ShowMessage("Error: invalid BG type!");
        break;
    }

    m_scaledBMP->Assign(m_bmp);
}


void BG::SetBMP_TEXT(){
    //gppbg̑IƐݒ
    const Palette *paletteInUse = m_palette;
    if(m_info.extendedPalette && m_info.charaDataSize == 64){
        m_exPalette->SetSlot(m_info.slotNum);
        paletteInUse = m_exPalette;
    }

	const int width		= m_bmp->Width;
    const int height	= m_bmp->Height;
    
    unsigned char *tmpBMP = new unsigned char[width * height * 3];

    //LN^f[^ꊇĂ߂Ă
    int     charaDataAllSize    = m_info.charaDataSize * m_info.maxCharacters;
    char    *charaDataAll       = new unsigned char[charaDataAllSize];
    int     charaOffset         = UsefulFunctions::GetOffset(   m_info.charaBaseOffset, charaBaseOffsetSize,
                                                                m_info.charaBaseBlock, charaBaseBlockSize);
    memcpy(charaDataAll, &m_rawData[charaOffset], charaDataAllSize);

    //XN[f[^̃ItZbg擾
    int screenOffset = UsefulFunctions::GetOffset(  m_info.screenBaseOffset, screenBaseOffsetSize,
                                                    m_info.screenBaseBlock,  screenBaseBlockSize);

    //XN[PubNƂďs܂
    int xBlocks = width  / screenLength;
    int yBlocks = height / screenLength;
	int screens = xBlocks * yBlocks;
	unsigned short screenData;
	for(int screenIndex=0; screenIndex<screens; screenIndex++){
        //XN[ꖇϊĈꎞϐɕۑ
        memcpy( &screenData,
                &m_rawData[screenOffset + screenIndex * sizeof(unsigned short)],
                sizeof(unsigned short) );
       
        unsigned char screenBMP[ screenLength * screenLength * 3];
		UsefulFunctions::ConvertScreenDataToBMPForText(screenData, charaDataAll, m_info.charaDataSize, paletteInUse, screenBMP);

        //ꎞϐscreenBMPbitmapɃ}bsO
        //AhX}bsODS̎dlgbL[Ȃ̂ŒvȂ
        int xoffset = screenIndex % BLOCK_UNIT;
        int yoffset = screenIndex / BLOCK_UNIT;
        if(BLOCK_UNIT*BLOCK_UNIT<=screenIndex && screenIndex<BLOCK_UNIT*BLOCK_UNIT*2){
            if(width > height){
                xoffset += BLOCK_UNIT;
                yoffset -= BLOCK_UNIT;
            }    
        }
        else if(BLOCK_UNIT*BLOCK_UNIT*2<=screenIndex && screenIndex<BLOCK_UNIT*BLOCK_UNIT*3){
            yoffset -= BLOCK_UNIT;
        }
        else if(BLOCK_UNIT*BLOCK_UNIT*3<=screenIndex){
            xoffset += BLOCK_UNIT;
            yoffset -= BLOCK_UNIT*2;
        }
        xoffset *= screenLength;
        yoffset *= screenLength;

        UsefulFunctions::MapBMP(screenBMP,  screenLength,	screenLength,
                                tmpBMP,     width,			height,
                                xoffset,    yoffset);
	}

    m_bmp->PixelFormat = pf24bit;
    for(int y=0; y<height; y++){
        memcpy(m_bmp->ScanLine[y], &tmpBMP[width * y * 3], width * 3);
    }

    delete[] charaDataAll;
    delete[] tmpBMP;
}


void BG::SetBMP_AFFINE(){
    //TEXT BGƎĂ邯ǔɃAhX}bsO肷
    const int width		= m_bmp->Width;
    const int height	= m_bmp->Height;
    
    unsigned char *tmpBMP = new unsigned char[width * height * 3];

    //LN^f[^ꊇĂ߂Ă
    int charaDataAllSize    = m_info.charaDataSize * m_info.maxCharacters;
    char *charaDataAll      = new unsigned char[charaDataAllSize];
    int charaOffset         = UsefulFunctions::GetOffset(   m_info.charaBaseOffset, charaBaseOffsetSize,
                                                            m_info.charaBaseBlock, charaBaseBlockSize);
    memcpy(charaDataAll, &m_rawData[charaOffset], charaDataAllSize);

    //XN[f[^̃ItZbg擾
    int screenOffset = UsefulFunctions::GetOffset(  m_info.screenBaseOffset, screenBaseOffsetSize,
                                                    m_info.screenBaseBlock,  screenBaseBlockSize);

    //XN[PubNƂďs܂
    int xBlocks = width  / screenLength;
    int yBlocks = height / screenLength;
	int screens = xBlocks * yBlocks;
	for(int screenIndex=0; screenIndex<screens; screenIndex++){
        //XN[ꖇϊĈꎞϐɕۑ
        unsigned char screenData = m_rawData[screenOffset + screenIndex];
        unsigned char screenBMP[ screenLength * screenLength * 3];
		UsefulFunctions::ConvertScreenDataToBMPForAffine(screenData, charaDataAll, m_info.charaDataSize, m_palette, screenBMP);

        //ꎞϐscreenBMPbitmapɃ}bsO
        //AhX}bsODS̎dlgbL[Ȃ̂ŒvȂ
        int xoffset = screenIndex % xBlocks;
        int yoffset = screenIndex / xBlocks;
        xoffset *= screenLength;
        yoffset *= screenLength;

        UsefulFunctions::MapBMP(screenBMP,  screenLength,	screenLength,
                                tmpBMP,     width,   		height,
                                xoffset,    yoffset);
	}

	m_bmp->PixelFormat = pf24bit;
    for(int y=0; y<height; y++){
        memcpy(m_bmp->ScanLine[y], &tmpBMP[width * y * 3], width * 3);
    }
    
    delete[] charaDataAll;
    delete[] tmpBMP;
}


void BG::SetBMP_ExAFFINE(){
    SetBMP_TEXT();
}


void BG::SetBMP_BITMAP(){
    int screenOffset = m_info.screenBaseBlock * 16 * 1024;

    //Phbg̃f[^ƂɁApbgĐFɕϊ
    const int width		= m_bmp->Width;
    const int height	= m_bmp->Height;
    m_bmp->PixelFormat = pf24bit;

    for(int y=0; y<height; y++){
        unsigned char *colorArray = new unsigned char[width * 3];
        for(int x=0; x<width; x++){
        	unsigned char paletteIndex = screenOffset + x + y * width;
        	m_palette->GetColor256by1(paletteIndex, &colorArray[x*3]);
        }
        memcpy(m_bmp->ScanLine[y], colorArray, width*3);
    }
}


unsigned short BG::GetScreenDataFromMousePosition(int x, int y){
    //}EXʒu炻̃̕XN[f[^o
    int offset = UsefulFunctions::GetOffset(  m_info.screenBaseOffset, screenBaseOffsetSize,
                                              m_info.screenBaseBlock,  screenBaseBlockSize);
    if(256 <= x){   offset += 0x800;    }
    if(256 <= y){   offset += 0x1000;   }

    int xBlock = (x % 256) / 8;
    int yBlock = (y % 256) / 8;
    offset += (xBlock + yBlock * BLOCK_UNIT) * sizeof(unsigned short);

    unsigned short screenData;
    memcpy(&screenData, &m_rawData[offset], sizeof(unsigned short));

    return screenData;
}


unsigned short BG::GetCharaDataFromMousePosition(int x, int y){
    //}EXʒu炻̃̕XN[f[^o
    int offset = UsefulFunctions::GetOffset(  m_info.screenBaseOffset, screenBaseOffsetSize,
                                              m_info.screenBaseBlock,  screenBaseBlockSize);

    int xBlock = x / 8;
    int yBlock = y / 8;
    offset += (xBlock + yBlock * (m_bmp->Width/8) );

    return m_rawData[offset];
}


void BG::SetScale(int scale){
    m_scaledBMP->Assign(m_bmp);
    if(scale != 1){
        UsefulFunctions::ReadBMPFileWithScale(m_scaledBMP, scale);
    }
}

