// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#ifndef BGH
#define BGH

#include "palette.h"
#include "structs.h"
#include "constants.h"
#include "Unit4.h"
//---------------------------------------------------------------------------

class BG{
    public:
        BG();
        ~BG();

        void SetBGInfo(const BG_Info&);
        void SetRawData(const char *rawData);
        void SetNormalPalette(const Palette*);
        void SetExPalette(Palette *);
        void Init(
                    const char      *rawData,
                    const Palette   *normalPalette,
                    Palette         *exPalette,
                    const BG_Info   &info
                 );

        TBITMAP*  GetBMP() const;
        bool IsPaletteNormal();
        int  GetPaletteNum(		int x, int y);
        int  GetSlotNum(		int x, int y);
        int  GetCharaDataOffset(int x, int y);

        void SetScale(int);

    private:
        const char      *m_rawData;
        TBITMAP         *m_bmp;
        TBITMAP         *m_scaledBMP;

        const Palette   *m_palette;
        Palette         *m_exPalette;
        BG_Info         m_info;

        void SetBMP();
        void SetBMP_TEXT();
        void SetBMP_AFFINE();
        void SetBMP_ExAFFINE();
        void SetBMP_BITMAP();

        unsigned short GetScreenDataFromMousePosition(	int x, int y);
        unsigned short GetCharaDataFromMousePosition(	int x, int y);
};

#endif
 