// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#pragma hdrstop

#include "OAM.h"

//---------------------------------------------------------------------------

static const unsigned short ONE_BIT_MASK    = 1;
static const unsigned short TWO_BIT_MASK    = 3;
static const unsigned short FOUR_BIT_MASK   = 15;
static const unsigned short TEN_BIT_MASK    = 1023;

static const int OBJ_SHAPE_SHIFT        = 14;
static const int COLOR_MODE_SHIFT       = 13;
static const int OBJ_SIZE_SHIFT         = 14;
static const int COLOR_PARAMETER_SHIFT  = 12;
static const int OBJ_MODE_SHIFT         = 10;
static const int V_FLIP_SHIFT			= 13;
static const int H_FLIP_SHIFT			= 12;
static const int PRIORITY_SHIFT          =10;

static const int WIDTH[4][4] = {
    {8,     16,     32,     64},
    {16,    32,     32,     64},
    {8,     8,      16,     32},
    {NULL,  NULL,   NULL,   NULL}
};

static const int HEIGHT[4][4] = {
    {8,     16,     32,     64},
    {8,     8,      16,     32},
    {16,    32,     32,     64},
    {NULL,  NULL,   NULL,   NULL}
};

void OAM::GetOAM_Info(const char *rawData, OAM_Info info[OAMS]){
	for(int i=0; i<OAMS; i++){
        info[i].width             = 0;
        info[i].height            = 0;
        info[i].colorMode         = Color16;
        info[i].objMode           = NORMAL_OBJ;
        info[i].colorPaletteNum   = 0;
        info[i].characterName     = 0;
        info[i].priority          = 0;
    }

    unsigned short attribute0;
    unsigned short attribute1;
    unsigned short attribute2;
    unsigned short affineParam;

    for(int i=0; i<OAMS; i++){
    	memcpy(&attribute0,	    &rawData[i * 8],		2);
    	memcpy(&attribute1,	    &rawData[i * 8 + 2],	2);
    	memcpy(&attribute2,	    &rawData[i * 8 + 4],	2);
    	memcpy(&affineParam,	&rawData[i * 8 + 6],	2);
     
        info[i].colorMode       = (OAMColorMode)( (attribute0 >> COLOR_MODE_SHIFT) & ONE_BIT_MASK);
        info[i].objMode         = (OBJType)( (attribute0 >> OBJ_MODE_SHIFT) & TWO_BIT_MASK);
        info[i].colorPaletteNum	= (attribute2 >> COLOR_PARAMETER_SHIFT) & FOUR_BIT_MASK;
        int shape               = (attribute0 >> OBJ_SHAPE_SHIFT) & TWO_BIT_MASK;
        int size                = (attribute1 >> OBJ_SIZE_SHIFT) & TWO_BIT_MASK;
        info[i].width           = WIDTH[shape][size];
        info[i].height          = HEIGHT[shape][size];
        info[i].vFlip			= (attribute1 >> V_FLIP_SHIFT) & ONE_BIT_MASK;
        info[i].hFlip			= (attribute1 >> H_FLIP_SHIFT) & ONE_BIT_MASK;
        info[i].characterName   = attribute2 & TEN_BIT_MASK;
        info[i].priority        = (attribute2 >> PRIORITY_SHIFT) & TWO_BIT_MASK;
    }
}
