// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#pragma hdrstop
                                                   
#include "OBJ.h"
#include "usefulFunctions.h"

//---------------------------------------------------------------------------

static const int UnitObjSize = 64;
static const int DATASIZE_PER_TEXEL[4][2] = {  //bit   OBJType OAMColorMode
    {4, 8}, {4, 8}, {4, 8}, {16, 16}
};
static const int CHARANAME_UNIT[] = {32, 64, 128, 256};

OBJ::OBJ() :
    m_rawData(NULL),
    m_palette(NULL),
    m_exPalette(NULL),
    m_objNum(0){
    m_bmp       = new TBITMAP;
    m_objBMP    = new TBITMAP;
}


OBJ::~OBJ(){
    delete m_bmp;
    delete m_objBMP;
}


void OBJ::SetOBJInfo(const OBJ_Info &info){
    m_objInfo = info;
}


void OBJ::SetOAMInfo(const OAM_Info *info){
    for(int i=0; i<OAMS; i++){
        m_oamInfo[i] = info[i];
    }
}


void OBJ::SetRawData(const char *rawData){
    m_rawData = rawData;
}


void OBJ::SetNormalPalette(const Palette *palette){
    m_palette = palette;
}


void OBJ::SetExPalette(const Palette *palette){
    m_exPalette = palette;
}


void OBJ::Init(
                const char      *rawData,
                const Palette   *normalPalette,
                const Palette   *exPalette,
                const OBJ_Info  &objInfo,
                const OAM_Info  *oamInfo
              )
{
    SetOBJInfo(objInfo);
    SetOAMInfo(oamInfo);
    SetRawData(rawData);
    SetNormalPalette(normalPalette);
    SetExPalette(exPalette);
    SetBMP();
}


TBITMAP*  OBJ::GetBMP() const{
    return m_bmp;
}


TBITMAP*  OBJ::GetOBJBMP(int x, int y){
    //}EXʒuIuWFԍ𒲂ׂ
    const int xOAMS = 512 / UnitObjSize;
    m_objNum = x / UnitObjSize + y / UnitObjSize * xOAMS;

    //̃IuWF̃rbg}bv𐶐
    m_objBMP->Width         = m_oamInfo[m_objNum].width;
    m_objBMP->Height        = m_oamInfo[m_objNum].height;
    m_objBMP->PixelFormat   = pf24bit;

    const int width		= m_objBMP->Width;
    const int height	= m_objBMP->Height;

    unsigned char *objBMP  = new unsigned char[width * height * 3];
    int charaOffset = CHARANAME_UNIT[m_objInfo.vramCapacity] * m_oamInfo[m_objNum].characterName;
    SetBMP_AN_OBJ(objBMP, m_oamInfo[m_objNum], &m_rawData[charaOffset]);

    for(int y=0; y<height; y++){
        memcpy(m_objBMP->ScanLine[y], &objBMP[width * y * 3], width * 3);
    }

    UsefulFunctions::ReadBMPFileWithScale(m_objBMP, OBJ_SCALE); //KɂS{炢ɂĂ܂

    //^[
    delete[] objBMP;
    return m_objBMP;
}


TBITMAP*  OBJ::GetOBJBMPPrev(){
    return m_objBMP;
}


bool OBJ::IsPaletteNormal(){
    //16F[hƃtOɊ֌WȂWpbgg݂ci܂OAMԍɈˑj
    if(m_oamInfo[m_objNum].colorMode == Color16){
        return true;
    }
    else {
        return !m_objInfo.extendedPalette;
    }
}


int OBJ::GetPaletteNum(){
    //F[hŕς˂c
    if(!m_objInfo.extendedPalette && (m_oamInfo[m_objNum].colorMode == Color256) ){
        return 0;
    }

    //̃IuWFΉOAM񂩂pbgԍԂ
    return m_oamInfo[m_objNum].colorPaletteNum;
}


int  OBJ::GetCharaDataOffset(int x, int y){
    //擪ʒu
    int offset = CHARANAME_UNIT[m_objInfo.vramCapacity]
                    * m_oamInfo[m_objNum].characterName;

    //(8*8)ubNł̈ʒu
    int xBlock = x / 8;
    int yBlock = y / 8;
    int blockSize = (m_oamInfo[m_objNum].colorMode == Color16) ? 32 : 64; //Byte
    offset += (xBlock + yBlock * m_oamInfo[m_objNum].width / 8) * blockSize;

    return offset;
}


int OBJ::GetPriority(){
        return  m_oamInfo[m_objNum].priority;
}


void OBJ::SetBMP(){
    m_bmp->Width    = 512;
    m_bmp->Height   = 1024;

	const int width		= m_bmp->Width;
    const int height	= m_bmp->Height;

    unsigned char *tmpBMP = new unsigned char[width * height * 3];
    memset(tmpBMP, 128, width * height * 3);

    const int xOAMS = 512 / UnitObjSize;

    for(int i=0; i<OAMS; i++){
        //OAMɂ̃TCỸrbg}bv
        unsigned char *objBMP  = new unsigned char[m_oamInfo[i].width * m_oamInfo[i].height * 3];
        int charaOffset = CHARANAME_UNIT[m_objInfo.vramCapacity] * m_oamInfo[i].characterName;
        SetBMP_AN_OBJ(objBMP, m_oamInfo[i], &m_rawData[charaOffset]);

        //IuWF̃rbg}bv\rbg}bvɃ}bsO
        int xoffset = (i % xOAMS) * UnitObjSize;
        int yoffset = (i / xOAMS) * UnitObjSize;
        UsefulFunctions::MapBMP(objBMP,     m_oamInfo[i].width, m_oamInfo[i].height,
                                tmpBMP,     width,       		height,
                                xoffset,    yoffset);

        delete[] objBMP;
    }

	m_bmp->PixelFormat = pf24bit;
	for(int y=0; y<height; y++){
        memcpy(m_bmp->ScanLine[y], &tmpBMP[width * y * 3], width * 3);
    }
    
    delete[] tmpBMP;
}


void OBJ::SetBMP_AN_OBJ(unsigned char unitBMP[], const OAM_Info &info, const unsigned char *oamData){
    //IuWF̃rbg}bv쐬i8*8Pʂŏj
    const int xBlocks   = info.width / 8;
    const int yBlocks   = info.height / 8;
    const int dataSize  = 8 * 8 * DATASIZE_PER_TEXEL[info.objMode][info.colorMode] / 8;
    int offset = 0;
    for(int i=0; i<xBlocks * yBlocks; i++){
        unsigned char block[8*8*3];

        //IuWF[hɉď؂ւ
        switch(info.objMode){
            case NORMAL_OBJ:
            case TANSPARENT_OBJ:
            case OBJ_WINDOW:
                if(info.colorMode == Color16){
                    SetBMP_TEXT_16Color(block, &oamData[offset], info.colorPaletteNum);
                }
                else if(info.colorMode == Color256){
                    SetBMP_TEXT_256Color(block, &oamData[offset], info.colorPaletteNum);
                }
            break;

            case BITMAP_OBJ:
                SetBMP_BITMAP(block, &oamData[offset]);
            break;
        }

        //8*8f[^}bsO
        int xoffset = (i % xBlocks) * 8;
        int yoffset = (i / xBlocks) * 8;
        UsefulFunctions::MapBMP(block,      8,          8,
                                unitBMP,    info.width, info.height,
                                xoffset,    yoffset);

        offset += dataSize;
    }
    if(info.vFlip){	UsefulFunctions::FlipVertical(unitBMP, info.width, info.height);    }
    if(info.hFlip){	UsefulFunctions::FlipHorizontal(unitBMP, info.width, info.height);  }
}


void OBJ::SetBMP_TEXT_16Color(unsigned char bitmap[], const unsigned char *data, int paletteNum){
    //8*8PʂŏȂ΂ȂȂ̂Œӂ
    const int FOUR_BIT_MASK = 15;
    for(int i=0; i<8*8; i++){
        int paletteIndex;
        if(i % 2 == 0){	paletteIndex = (data[i * DATASIZE_PER_TEXEL[NORMAL_OBJ][Color16] / 8]) & FOUR_BIT_MASK;			}
        else {          paletteIndex = (data[i * DATASIZE_PER_TEXEL[NORMAL_OBJ][Color16] / 8] >> 4) & FOUR_BIT_MASK;	}
        
        m_palette->GetColor16by16(paletteNum, paletteIndex, &bitmap[i*3]);
    }
}


void OBJ::SetBMP_TEXT_256Color(unsigned char bitmap[], const unsigned char *data, int paletteNum){
    //8*8PʂŏȂ΂ȂȂ̂Œӂ
    for(int i=0; i<8*8; i++){
        if(m_objInfo.extendedPalette){
            m_exPalette->GetColor256by16(	
            								paletteNum, 
            								data[i * DATASIZE_PER_TEXEL[NORMAL_OBJ][Color256] / 8],
            								&bitmap[i*3]
            							);
        }
        else {
            m_palette->GetColor256by1(data[i * DATASIZE_PER_TEXEL[NORMAL_OBJ][Color256] / 8], &bitmap[i*3]);
        }
    }
}


void OBJ::SetBMP_BITMAP(unsigned char bitmap[], const unsigned char *data){
    //8*8PʂŏȂ΂ȂȂ̂Œӂ
    for(int i=0; i<8*8; i++){
        unsigned short bmpData;
        memcpy(&bmpData, &data[i * DATASIZE_PER_TEXEL[BITMAP_OBJ][0] / 8], 2);
        UsefulFunctions::ChangeBit16to24(bmpData, &bitmap[i*3]);
    }
}
