// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#ifndef OBJH
#define OBJH

#include "Unit4.h"
#include "palette.h"
#include "structs.h"
#include "constants.h"
//---------------------------------------------------------------------------

static const int OBJ_SCALE = 4;

class OBJ{
    public:
        OBJ();
        ~OBJ();

        void SetOBJInfo(const OBJ_Info&);
        void SetOAMInfo(const OAM_Info*);
        void SetRawData(const char *rawData);
        void SetNormalPalette(const Palette*);
        void SetExPalette(const Palette *);
        void Init(
                    const char      *rawData,
                    const Palette   *normalPalette,
                    const Palette   *exPalette,
                    const OBJ_Info  &objInfo,
                    const OAM_Info  *oamInfo
                 );

        TBITMAP*  GetBMP() const;
        TBITMAP*  GetOBJBMP(int x, int y);
        TBITMAP*  GetOBJBMPPrev();

        bool IsPaletteNormal();
        int  GetPaletteNum();
        int  GetCharaDataOffset(int x, int y);
        int  GetPriority();

    private:
        const char      *m_rawData;
        TBITMAP         *m_bmp;
        TBITMAP         *m_objBMP;
        int             m_objNum;

        const Palette   *m_palette;
        const Palette   *m_exPalette;
        OBJ_Info        m_objInfo;
        OAM_Info        m_oamInfo[OAMS];

        void SetBMP();
        void SetBMP_AN_OBJ(unsigned char[], const OAM_Info&, const unsigned char *oamData);
        void SetBMP_TEXT_16Color(	unsigned char[], const unsigned char *data, int paletteNum);
        void SetBMP_TEXT_256Color(	unsigned char[], const unsigned char *data, int paletteNum);
        void SetBMP_BITMAP(			unsigned char[], const unsigned char *data);
};

#endif
 