// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#pragma hdrstop

#include "Texture.h"
#include "Unit1.h"
#include "usefulFunctions.h"

//---------------------------------------------------------------------------
//TextureTypeʒ萔f[^i\̂ɂĂ悩IHj
static const int TEXTURE_WIDTH[]                = {256,     256,    256,    256,    256,    256,    256,    256 };
static const int TEXTURE_HEIGHT[]               = {256,     256,    8192,   4096,   2048,   256,    256,    1024};
static const int TEXEL_DATA_UNIT[]              = {NULL,    8,      2,      4,      8,      NULL,   8,      NULL}; //bit
static const unsigned char TEXEL_MASK[]         = {NULL,    255,    3,      15,     255,    NULL,   255,    NULL};


Texture::Texture() :
    m_rawData(NULL),
    m_palette(NULL),
    m_type(TF_COLOR16){
    m_bmp = new TBITMAP;
}


Texture::~Texture(){
    delete m_bmp;
}


void Texture::SetRawData(const char *rawData){
    m_rawData = rawData;
}


void Texture::SetPalette(const Palette *palette){
    m_palette = palette;
}


void Texture::SetTextureType(TextureType type){
    m_type = type;
    SetBMP();
}


void Texture::Init(
          const char    *rawData,
          const Palette *exPalette,
          TextureType   type
         )
{
    SetRawData(rawData);
    SetPalette(exPalette);
    SetTextureType(type);
}


TBITMAP*  Texture::GetBMP() const{
    return m_bmp;
}


void Texture::SetBMP(){
    m_bmp->Width    = TEXTURE_WIDTH[m_type];
    m_bmp->Height   = TEXTURE_HEIGHT[m_type];

    switch(m_type){
        case TF_NONE:
        break;

        case TF_COLOR4:
        case TF_COLOR16:
        case TF_COLOR256:
            SetBMP_4to256Color(m_type);
        break;

        case TF_CONPRESSED4BY4:
        case TF_A315:
        case TF_A513:
        break;

        case TF_DIRECT:
            SetBMP_Direct();
        break;

        default:
        break;
    }
}


void Texture::SetBMP_4to256Color(TextureType type){
    const int width		= m_bmp->Width;
    const int height	= m_bmp->Height;
    m_bmp->PixelFormat	= pf24bit;
    
	unsigned char *line = new unsigned char[width * 3];
    
    for(int y=0; y<height; y++){
    	for(int x=0; x<width; ){
    		int dataIndex = (x + width * y) * TEXEL_DATA_UNIT[type] / 8;
        	unsigned char texelData = static_cast<unsigned char>(m_rawData[dataIndex]);

        	for(int bit=0; bit<8; bit+=TEXEL_DATA_UNIT[type]){
            	unsigned char colorNum = (texelData >> bit) & TEXEL_MASK[type];
            	m_palette->GetColor256by1(colorNum, &line[x*3]);
            	x++;
        	}
    	}
    	memcpy(m_bmp->ScanLine[y], line, width * 3);
    }

    delete[] line;
}


void Texture::SetBMP_4by4Compressed(){
}


void Texture::SetBMP_A315(){
}


void Texture::SetBMP_A513(){
}


void Texture::SetBMP_Direct(){
	const int width		= m_bmp->Width;
    const int height	= m_bmp->Height;
	m_bmp->PixelFormat	= pf24bit;
	
	unsigned char *lineData = new unsigned char[width*3];
	
	for(int y=0; y<height; y++){
		for(int x=0; x<width; x++){
			unsigned short data;
			memcpy(&data, &m_rawData[(x+width*y) * sizeof(unsigned short)], sizeof(unsigned short));
			UsefulFunctions::ChangeBit16to24(data, &lineData[x*3]);
		}
		memcpy(m_bmp->ScanLine[y], lineData, width*3);
	}
}
