// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#ifndef TextureH
#define TextureH

#include "palette.h"
#include "structs.h"
#include "constants.h"
//---------------------------------------------------------------------------

class Texture{
    public:
        Texture();
        ~Texture();

        void SetRawData(const char *rawData);
        void SetPalette(const Palette*);
        void SetTextureType(TextureType);
        void Init(
                    const char      *rawData,
                    const Palette   *normalPalette,
                    TextureType     type
                 );

        TBITMAP*  GetBMP() const;

    private:
        const char      *m_rawData;
        TBITMAP         *m_bmp;
        TextureType     m_type;

        const Palette   *m_palette;

        void SetBMP();
        void SetBMP_4to256Color(TextureType);
        void SetBMP_4by4Compressed();
        void SetBMP_A315();
        void SetBMP_A513();
        void SetBMP_Direct();
};

#endif
 