// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#include <iostream>
#include <fstream>
#include <string>
#pragma hdrstop

#include "VRAM.h"
#include "usefulFunctions.h"

using namespace std;


//---------------------------------------------------------------------------

static const int VRAM_WIDTH     = 256;
static const int VRAM_HEIGHT[]  = {4096, 1024, 2048, 1024};  //RAW_DATA_TYPE - RDT_BG_VRAM_A
static const int SCALE          = 2;

VRAM::VRAM() :
    m_rawData(NULL),
    m_palette(NULL),
    m_exPalette(NULL),
    m_scaleOn(false),
    m_typeToDisplay(TEXT_BG),
    m_paletteNum(0){
    m_bmp = new TBITMAP;
}


VRAM::~VRAM(){
    delete m_bmp;
}


void VRAM::SetRawDataType(RAW_DATA_TYPE type){
    m_type = type;
}


void VRAM::SetRawData(const char *rawData){
    m_rawData = rawData;
}


void VRAM::SetNormalPalette(const Palette *palette){
    m_palette = palette;
}


void VRAM::SetExPalette(Palette *palette){
    m_exPalette = palette;
}


void VRAM::Init(
                    RAW_DATA_TYPE   type,
                    const char      *rawData,
                    const Palette   *normalPalette,
                    Palette   *exPalette
                )
{
    m_scaleOn       = false;
    m_typeToDisplay = TEXT_BG;
    m_paletteNum    = 0;
    SetRawDataType(type);
    SetRawData(rawData);
    SetNormalPalette(normalPalette);
    SetExPalette(exPalette);
    SetBMP();
}


TBITMAP*  VRAM::GetBMP() const{
    return m_bmp;
}


void VRAM::SetBMP(){
    m_bmp->Width    = VRAM_WIDTH;
    m_bmp->Height   = VRAM_HEIGHT[m_type - RDT_BG_VRAM_A];
    if(m_scaleOn){
        m_bmp->Width /= SCALE;
        m_bmp->Height *= SCALE;
    }
    if(m_typeToDisplay != TEXT_BG){
        m_bmp->Height /= 2;
    }

	const int width		= m_bmp->Width;
    const int height	= m_bmp->Height;
    
    unsigned char *tmpBMP = new unsigned char[width * height *3];

    int Xoffset = 0;
    int Yoffset = 0;
    dataIndex   = 0;
    //8*8Pʂŏ
    unsigned char panel[8*8*3];
    const int charas = width * height / (8*8);
    for(int j=0; j<charas; j++){
        //8*8̐F̏
        switch(m_typeToDisplay){
            case TEXT_BG:
                SetBMP_TEXT(panel);
                break;

            case AFFINE_BG:
                SetBMP_AFFINE(panel);
                break;

            case EXTENDED_AFFINE_BG:
                SetBMP_TEXT_EX(panel);
                break;

            case BITMAP_BG:
            default:
            break;
        }
        UsefulFunctions::MapBMP(
                                panel,      8,        8,
                                tmpBMP,     width,    height,
                                Xoffset,    Yoffset
                               );
        Xoffset+=8;
        if(Xoffset >= width){
            Xoffset = 0;
            Yoffset+=8;
        }
    }

    m_bmp->PixelFormat = pf24bit;
	for(int y=0; y<height; y++){
		memcpy(m_bmp->ScanLine[y], &tmpBMP[width*y*3], width * 3);
	}
    
    delete[] tmpBMP;

    if(m_scaleOn){
        UsefulFunctions::ReadBMPFileWithScale(m_bmp, SCALE);
    }
}


void VRAM::SetBMP_TEXT(unsigned char panel[]){
	const int chara = 8*8;
    for(int k=0; k<chara; k++){
        unsigned char charaData = m_rawData[dataIndex];
        if(k%2 == 0){
            charaData = charaData & 0x0f;
        }
        else{
            charaData = charaData >> 4;
            dataIndex++;
        }
        m_palette->GetColor16by16(m_paletteNum, charaData, &panel[k*3]);
    }
}


void VRAM::SetBMP_AFFINE(unsigned char panel[]){
    const int chara = 8*8;
    for(int k=0; k<chara; k++){
        unsigned char charaData = m_rawData[dataIndex];
        dataIndex++;

        m_palette->GetColor256by1(charaData, &panel[k*3]);
    }
}


void VRAM::SetBMP_TEXT_EX(unsigned char panel[]){
    const int chara = 8*8;
    for(int k=0; k<chara; k++){
        unsigned char charaData = m_rawData[dataIndex];
        dataIndex++;

        m_exPalette->GetColor256by16(m_paletteNum, charaData, &panel[k*3]);
    }
}


void VRAM::ScalingUp(bool on){
    m_scaleOn = on;

    SetBMP();
}


void VRAM::SetDisplayType(BGType type){
    m_typeToDisplay = type;

    SetBMP();
}


void VRAM::SetSlotNum(int slotNum){
    m_exPalette->SetSlot(slotNum);

    SetBMP();
}


void VRAM::SetPaletteNum(int paletteNum){
    m_paletteNum = paletteNum;

    SetBMP();
}


void VRAM::GetPosition(int charaOffset, int *x, int *y){
    int pixelUnit = (m_typeToDisplay == TEXT_BG) ? 4 : 8; //bit
    //8*8 block̉ڂvZ
    int blocks = charaOffset / (8*8*pixelUnit/8);
    int pixels = ( charaOffset % (8*8*pixelUnit/8) ) / pixelUnit;

    int xBlocks = m_bmp->Width / 8;
    if(m_scaleOn){
        xBlocks /= SCALE;
    }

    *x = (blocks % xBlocks) * 8;
    *y = (blocks / xBlocks) * 8;

    *x += (pixels % 8);
    *y += (pixels / 8);

    if(m_scaleOn){
        *x *= SCALE;
        *y *= SCALE;
    }
}


int  VRAM::GetScale(){
    if(m_scaleOn){
        return SCALE;
    }

    return 1;
}


int  VRAM::GetOneLineDataSize(){
    int pixelUnit = (m_typeToDisplay == TEXT_BG) ? 4 : 8; //bit
    return VRAM_WIDTH * pixelUnit / 8;
}
