// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#ifndef VRAMH
#define VRAMH

#include "palette.h"
#include "structs.h"
#include "constants.h"
//---------------------------------------------------------------------------

class VRAM{
    public:
        VRAM();
        ~VRAM();

        void SetRawDataType(RAW_DATA_TYPE);
        void SetRawData(const char *rawData);
        void SetNormalPalette(const Palette*);
        void SetExPalette(Palette *);
        void SetBMP();
        void Init(
                    RAW_DATA_TYPE   type,
                    const char      *rawData,
                    const Palette   *normalPalette,
                    Palette         *exPalette
                 );

        TBITMAP*  GetBMP() const;

        //|bvAbvj[p֐
        void ScalingUp(bool);
        void SetDisplayType(BGType);
        void SetSlotNum(int);
        void SetPaletteNum(int);

        void GetPosition(int charaOffset, int *x, int *y);
        int  GetScale();
        int  GetOneLineDataSize();

    private:
        const char      *m_rawData;
        TBITMAP         *m_bmp;

        const Palette   *m_palette;
        Palette         *m_exPalette;

        RAW_DATA_TYPE   m_type;

        void SetBMP_TEXT(	unsigned char panel[]);
        void SetBMP_AFFINE(	unsigned char panel[]);
        void SetBMP_TEXT_EX(unsigned char panel[]);

        //|bvAbvj[pϐ
        bool    m_scaleOn;
        BGType  m_typeToDisplay;
        int     m_paletteNum;

        //p
        int dataIndex;
};

#endif
