// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#include <iostream>
#include <fstream>
#include <string>
#pragma hdrstop

#include "VRAMViewerMain.h"
#include "Unit1.h"
#include "Unit2.h"
#include "Unit3.h"
#include "Unit4.h"
#include "constants.h"
#include "sendRAMData.h"
#include "usefulFunctions.h"
#include "register.h"
#include "OAM.h"
using namespace std;
//---------------------------------------------------------------------------

#ifdef DSVV_DEBUG
static AnsiString BIN_PATH[] = {  //DataType
    "RDT_REGISTER.bin",
    "RDT_BG_NORMAL_PALETTE_A.bin",
    "RDT_OBJ_NORMAL_PALETTE_A.bin",
    "RDT_BG_NORMAL_PALETTE_B.bin",
    "RDT_OBJ_NORMAL_PALETTE_B.bin",
    "RDT_LCDC.bin",
	"RDT_OAM_A.bin",
    "RDT_OAM_B.bin",
    "RDT_BG_VRAM_A.bin",
    "RDT_BG_VRAM_B.bin",
    "RDT_OBJ_VRAM_A.bin",
    "RDT_OBJ_VRAM_B.bin",
    "RDT_BG_EX_PALETTE_A.bin",
    "RDT_BG_EX_PALETTE_B.bin",
    "RDT_OBJ_EX_PALETTE_A.bin",
    "RDT_OBJ_EX_PALETTE_B.bin",
    "RDT_TEXTURE_PALETTE.bin",
    "RDT_TEXTURE_IMAGE.bin",
    "RDT_ALL_RAW_DATA.bin"
};
#endif


VRAMViewerMain::VRAMViewerMain() :
    activeEngineBG(ENGINE_A),
    activeBgNum(0),
    activeEngineOBJ(ENGINE_A),
    m_bgScale(1)
{
    for(int i=RDT_REGISTER; i<RDT_ALL_RAW_DATA; i++){
        m_rawData[i] = new char[ DATA_SIZE[i] ];
        memset(m_rawData[i], 0, DATA_SIZE[i]);
    }
}


VRAMViewerMain::~VRAMViewerMain(){
    for(int i=RDT_REGISTER; i<RDT_ALL_RAW_DATA; i++){
        delete[] m_rawData[i];
    }
}


void    VRAMViewerMain::LoadAllInOneRawData(const AnsiString &path){
    #ifdef DSVV_DEBUG
    UsefulFunctions::SetBaseTime();
    #endif


    //ǂݍ݃G[
	ifstream ifs(path.c_str(), ios_base::in | ios_base::binary);
	if( ifs.fail() ){
		cout << "Failed to read BINFile." << endl;
		return;
	}

    UsefulFunctions::InitProgressBar();

    //ꊇf[^ǂݍ
    for(int i=RDT_REGISTER; i<=RDT_OAM_B; i++){
        ifs.read(m_rawData[i], DATA_SIZE[i]);
        Form1->ProgressBar1->StepBy(DATA_SIZE[i]);
    }

    DisplayAll();

    #ifdef DSVV_DEBUG
    UsefulFunctions::PrintTime("\I");
    #endif
}


static RAW_DATA_TYPE type;
static int dataIndex = 0;
static int order = -1;
void    VRAMViewerMain::LoadDataFromDS(const void *pAdrs, DWORD nSize){
    //VOi̎M
    if(nSize == sizeof(unsigned char)){
        /*
        AnalizeFlow afType = *(AnalizeFlow*)pAdrs;
        type = static_cast<RAW_DATA_TYPE>( (afType - 1)/2 );//AnalaizeFlow̕ϊ
        dataIndex = 0;
        //f[^ۑOɃ[NA
        memset(m_rawData[type], 0, DATA_SIZE[type]);

        //ŏ̂Ƃ
        if(type == RDT_REGISTER){
            UsefulFunctions::InitProgressBar();
        }
        */

		//DS̑MvOɌˑ
		//f[^̑MԂȂǂς@\ȂȂ
        //AnalizeFlow̏ԂŃVOi󂯎Ă邱Ƃ肵Ă
        order += 2;
        type = static_cast<RAW_DATA_TYPE>( (order - 1)/2 );//AnalaizeFlow̕ϊ
        dataIndex = 0;
        
        //f[^ۑOɃ[NA
        memset(m_rawData[type], 0, DATA_SIZE[type]);

        //ŏ̂Ƃ
        if(order == 1){
            UsefulFunctions::InitProgressBar();
        }
    }
    //VOiȊOif[^j̎M
    else {
        //Ăf[^񕪃Rs[
        int size = nSize;
        if(size > DATA_SIZE[type] - dataIndex ){
            ShowMessage("G[FĂf[^");
            size = DATA_SIZE[type] - dataIndex;
        }
        memcpy(&m_rawData[type][dataIndex], pAdrs, size);
        dataIndex += size;
        Form1->ProgressBar1->StepBy(size);

        //Ō̂Ƃ
        if(type >= RDT_OAM_B && dataIndex >= DATA_SIZE[RDT_OAM_B]){
            DisplayAll();
            order = -1;
        }
    }
}


// ̓fobOɎg\̃\bhB
// ݂͎gpĂȂB
void    VRAMViewerMain::LoadData(RAW_DATA_TYPE type, const AnsiString &path){
    ifstream ifs(path.c_str(), ios_base::in | ios_base::binary);
	if( ifs.fail() ){
		cout << "Failed to read BINFile." << endl;
		return;
	}
    ifs.read(m_rawData[type], DATA_SIZE[type]);

    if(type == RDT_LCDC){
        DisplayAll();
    }
}


void    VRAMViewerMain::LoadData(RAW_DATA_TYPE type, const void *data){
    if(data == NULL){
        return;
    }

    memcpy(m_rawData[type], data, DATA_SIZE[type]);

    if(type == RDT_LCDC){
        DisplayAll();
    }
}


void    VRAMViewerMain::SaveAllInOneRawData(const AnsiString &path){
    //G[
	ofstream ofs(path.c_str(), ios_base::out | ios_base::trunc | ios_base::binary );
	if( ofs.fail() ){
		cout << "Cannot open BMPFile." << endl;
		return;
	}

	//ꊇf[^ۑ
    for(int i=RDT_REGISTER; i<=RDT_OAM_B; i++){
	    ofs.write(m_rawData[i], DATA_SIZE[i]);
    }

    #ifdef DSVV_DEBUG
    //וf[^ۑ
    for(int i=0; i<RDT_ALL_RAW_DATA; i++){
        AnsiString output(BIN_PATH[i]);
        ofstream ofs(output.c_str(), ios_base::out | ios_base::trunc | ios_base::binary );
	    ofs.write(m_rawData[i], DATA_SIZE[i]);
    }
    #endif
}


void    VRAMViewerMain::DisplayAll(){
    //ʃEBhEU
    Form2->Hide();
    Form3->Hide();
    Form4->Hide();

    //j[iENbNj̑I^Cv
    Form1->baoff->Checked       = true;
    Form1->banormal->Checked    = true;
    Form1->bap0->Checked        = true;
    Form1->baes0->Checked       = true;
    Form1->bboff->Checked       = true;
    Form1->bbnormal->Checked    = true;
    Form1->bbp0->Checked        = true;
    Form1->bbs0->Checked        = true;
    Form1->oaoff->Checked       = true;
    Form1->oanormal->Checked    = true;
    Form1->oap0->Checked        = true;
    Form1->oboff->Checked       = true;
    Form1->obnormal->Checked    = true;
    Form1->obp0->Checked        = true;

    //\[X̐
    ReconstructRawData();
    #ifdef DSVV_DEBUG
    UsefulFunctions::PrintTime("f[^̍č\z");
    #endif

    //e\[X̕\
    DisplayBG();
    #ifdef DSVV_DEBUG
    UsefulFunctions::PrintTime("BG\");
    #endif

    DisplayOBJ();
    #ifdef DSVV_DEBUG
    UsefulFunctions::PrintTime("OBJ\");
    #endif

    DisplayTexture();
    #ifdef DSVV_DEBUG
    UsefulFunctions::PrintTime("eNX`\");
    #endif

    //VRAMItZbgʒu̕\
    SetCaptionHeight();
}


void VRAMViewerMain::DisplayBGForAnotherForm(ENGINE engine, int bgNum){
    activeEngineBG  = engine;
    activeBgNum     = bgNum;

    InitForAnotherForm(true);

    //Form2\
    Form2->Show();

    //Form2Image1Ƀrbg}bv\t
    Form2->Image1->Picture->Bitmap->Width   = 1;
    Form2->Image1->Picture->Bitmap->Height  = 1;
    Form2->Image1->Picture->Assign( m_BG_Classes[engine].bg[bgNum].GetBMP());
}


void VRAMViewerMain::DisplayOBJForAnotherForm(ENGINE engine, int x, int y){
    activeEngineOBJ = engine;

    InitForAnotherForm(false);

    //Form3\
    Form3->Show();

    //Form3Image1Ƀrbg}bv\t
    Form3->Image1->Picture->Bitmap->Width   = 1;
    Form3->Image1->Picture->Bitmap->Height  = 1;
    Form3->Image1->Picture->Assign( m_OBJ_Classes[engine].obj.GetOBJBMP(x,y));
}


void VRAMViewerMain::DisplayPaletteInfo(int X, int Y, bool bg){
    //̊֐BGOBJʂŎĝŕ֋XIbgNum4OBJ_AAOBJ_BɊ蓖Ă܂
    if(bg){
        X /= m_bgScale; //scale{Ăꍇ̂Ōɂ
        Y /= m_bgScale;
        bool    normalPalette   = m_BG_Classes[activeEngineBG].bg[activeBgNum].IsPaletteNormal();
        int     slotNum         = m_BG_Classes[activeEngineBG].bg[activeBgNum].GetSlotNum(X, Y);
        int     paletteNum      = m_BG_Classes[activeEngineBG].bg[activeBgNum].GetPaletteNum(X, Y);

        Form4->Label3->Caption  = normalPalette ? "Wpbg" : "gpbg";
        Form4->Label4->Caption  = (slotNum == -1) ? AnsiString("Xbg͂܂") : IntToStr(slotNum);
        Form4->Label5->Caption  = IntToHex(paletteNum,1);
    }
    else{  //obj
        bool    normalPalette   = m_OBJ_Classes[activeEngineBG].obj.IsPaletteNormal();
        int     paletteNum      = m_OBJ_Classes[activeEngineBG].obj.GetPaletteNum();

        Form4->Label3->Caption  = normalPalette ? "Wpbg" : "gpbg";
        Form4->Label4->Caption  = "Xbg͂܂";
        Form4->Label5->Caption  = IntToHex(paletteNum,1);
        Form4->Label8->Caption  = m_OBJ_Classes[activeEngineBG].obj.GetPriority();
    }
    Form4->Show();
}


void VRAMViewerMain::DisplayCursor(int X, int Y, bool bg){
    //ʑɘgo
    if(bg){	DisplayCursorBG(X, Y);	}
    else {	DisplayCursorOBJ(X,Y);	}
}


void VRAMViewerMain::InitForAnotherForm(bool bg){
    if(bg){
        //BG̃XP[̏
        m_bgScale = 1;
        m_BG_Classes[activeEngineBG].bg[activeBgNum].SetScale(m_bgScale);

        //J[\̏
        BGCursors.clear();
        Form1->BG_A_VRAM->Picture->Assign( m_BG_Classes[ENGINE_A].bgVRAM.GetBMP() );
        Form1->BG_B_VRAM->Picture->Assign( m_BG_Classes[ENGINE_B].bgVRAM.GetBMP() );

        //ENbN̕\̏
        Form1->bgs1->Checked = true;
    }
    else {
        //J[\̏
        OBJCursors.clear();
        Form1->OBJ_A_VRAM->Picture->Assign( m_OBJ_Classes[ENGINE_A].objVRAM.GetBMP() );
        Form1->OBJ_B_VRAM->Picture->Assign( m_OBJ_Classes[ENGINE_B].objVRAM.GetBMP() );
    }
}


void VRAMViewerMain::ReconstructRawData(){
	//Clear Data before reconstructing.
	for(int i=RDT_BG_VRAM_A; i<RDT_ALL_RAW_DATA; i++){
        memset(m_rawData[i], 0, DATA_SIZE[i]);
    }
	
    //LCDCɂf[^zuȂ
    VRAM_Info   info[VRAMS];
    Register::GetVRAM_Info(m_rawData[RDT_REGISTER], info);

    int LCDC_Offset = 0;
    for(int i=VRAM_A; i<VRAMS; i++){
        //f[^Rs[
        if(info[i].enable){
            //G[`FbN
            if(info[i].dataType == RDT_LCDC || info[i].dataType >= RDT_ALL_RAW_DATA){
            }
            else if((int)VRAM_SIZE[i] > (int)DATA_SIZE[ info[i].dataType ] - (int)info[i].offset ){
                //G[̏ꍇȊOVRAM_Eɂꍇ
                memcpy( &m_rawData[ info[i].dataType ][ info[i].offset ],
                        &m_rawData[RDT_LCDC][ LCDC_Offset ],
                        DATA_SIZE[ info[i].dataType ] - info[i].offset);
            }
            else {
                //
                memcpy( &m_rawData[ info[i].dataType ][ info[i].offset ],
                        &m_rawData[RDT_LCDC][ LCDC_Offset ],
                        VRAM_SIZE[i]);
            }
        }
        LCDC_Offset += VRAM_SIZE[i];
    }
}


void VRAMViewerMain::DisplayBG(){
    OfferResourceBG();	//eNXɃ\[X񋟁ijFԈˑȂ̂ŋC܂傤
    AssignResultBG();	//eNXrbg}bv󂯎
}


void VRAMViewerMain::DisplayOBJ(){
    OfferResourceOBJ();	//eNXɃ\[X񋟁ijFԈˑȂ̂ŋC܂傤
    AssignResultOBJ();	//eNXrbg}bv󂯎
}


void VRAMViewerMain::DisplayTexture(){
    //eNXɃ\[X񋟁ijFԈˑȂ̂ŋC܂傤
    TextureType textureType= (TextureType)Form1->textureBox->ItemIndex;

    //eNX`^Cvpbg^Cvɕϊ
    PaletteType paletteType;
    switch(textureType){
        case TF_COLOR4:
        case TF_COLOR16:
        case TF_COLOR256:
        case TF_CONPRESSED4BY4:
            paletteType = (PaletteType)textureType;
        break;

        case TF_A315:
            paletteType = TEXTURE_A315;
        break;

        case TF_A513:
            TEXTURE_A513;
        break;

        case TF_DIRECT:
        case TF_NONE:
        default:
            paletteType = TEXTURE_16COLOR;  //͓K
        break;
    }

    m_textureClasses.palette.Init(paletteType, m_rawData[RDT_TEXTURE_PALETTE], 0);
    m_textureClasses.texture.Init(m_rawData[RDT_TEXTURE_IMAGE], &m_textureClasses.palette, textureType);

    //eNXrbg}bv󂯎
    Form1->Texture_Palette  ->Picture->Assign( m_textureClasses.palette.GetBMP()    );
    Form1->Texture          ->Picture->Assign( m_textureClasses.texture.GetBMP()    );
}


void VRAMViewerMain::SetCaptionHeight(){
    BG_Info info[ENGINES][BGS];
    Register::GetBG_Info(m_rawData[RDT_REGISTER], info);

    TLabel *labels[2 * 4 * 2];
    labels[0]   = Form1->screen0A;
    labels[1]   = Form1->character0A;
    labels[2]   = Form1->screen1A;
    labels[3]   = Form1->character1A;
    labels[4]   = Form1->screen2A;
    labels[5]   = Form1->character2A;
    labels[6]   = Form1->screen3A;
    labels[7]   = Form1->character3A;
    labels[8]   = Form1->screen0B;
    labels[9]   = Form1->character0B;
    labels[10]  = Form1->screen1B;
    labels[11]  = Form1->character1B;
    labels[12]  = Form1->screen2B;
    labels[13]  = Form1->character2B;
    labels[14]  = Form1->screen3B;
    labels[15]  = Form1->character3B;

    for(int engine = ENGINE_A; engine <= ENGINE_B; engine++){
        //ŃItZbglLvVʒuɕϊ܂
        const int oneLineDataSize = m_BG_Classes[engine].bgVRAM.GetOneLineDataSize();

        int maxOffset   = (engine == ENGINE_A) ? DATA_SIZE[RDT_BG_VRAM_A] : DATA_SIZE[RDT_BG_VRAM_B];
        int scale       = m_BG_Classes[engine].bgVRAM.GetScale();

        for(int bgNum = 0; bgNum < 4; bgNum++){
            int charaOffset     = charaBaseOffsetSize   * info[engine][bgNum].charaBaseOffset
                                + charaBaseBlockSize    * info[engine][bgNum].charaBaseBlock;
            int screenOffset    = screenBaseOffsetSize  * info[engine][bgNum].screenBaseOffset
                                + screenBaseBlockSize   * info[engine][bgNum].screenBaseBlock;
            if(!info[engine][bgNum].enable){
                charaOffset     = maxOffset;
                screenOffset    = maxOffset;
            }

            int charaRelativeHeight     = charaOffset   / (oneLineDataSize/scale) * scale;
            int screenRelativeHeight    = screenOffset  / (oneLineDataSize/scale) * scale;

            labels[ 2*bgNum + engine*8 +1   ]->Top = charaRelativeHeight;
            labels[ 2*bgNum + engine*8      ]->Top = screenRelativeHeight;
        }
    }
}


void    VRAMViewerMain::SetPopupInfoScale(bool bg, ENGINE engine, bool on){
    if(bg){ m_BG_Classes[engine].bgVRAM.ScalingUp(on);      }
    else {  m_OBJ_Classes[engine].objVRAM.ScalingUp(on);    }

    ReDrawVRAM(bg, engine);
    SetCaptionHeight();
}


void    VRAMViewerMain::SetPopupInfoDisplayType(bool bg, ENGINE engine, BGType type){
    if(bg){ m_BG_Classes[engine].bgVRAM.SetDisplayType(type);    }
    else {  m_OBJ_Classes[engine].objVRAM.SetDisplayType(type);  }

    ReDrawVRAM(bg, engine);
    SetCaptionHeight();
}


void    VRAMViewerMain::SetPopupInfoPaletteNum(bool bg, ENGINE engine, int paletteNum){
    if(bg){ m_BG_Classes[engine].bgVRAM.SetPaletteNum(paletteNum);      }
    else {  m_OBJ_Classes[engine].objVRAM.SetPaletteNum(paletteNum);    }

    ReDrawVRAM(bg, engine);
}


void    VRAMViewerMain::SetPopupInfoPaletteSlot(bool bg, ENGINE engine, int slotNum){
    if(bg){ m_BG_Classes[engine].bgVRAM.SetSlotNum(slotNum);    }
    else {  m_OBJ_Classes[engine].objVRAM.SetSlotNum(slotNum);  }

    ReDrawVRAM(bg, engine);
}


void VRAMViewerMain::ReDrawVRAM(bool bg, ENGINE engine){
    if(bg){
        if(engine == ENGINE_A){ Form1->BG_A_VRAM->Picture->Assign( m_BG_Classes[engine].bgVRAM.GetBMP() ); }
        else {                  Form1->BG_B_VRAM->Picture->Assign( m_BG_Classes[engine].bgVRAM.GetBMP() ); }

        for(PositionList::iterator i=BGCursors.begin(); i!=BGCursors.end(); i++){
            //ʑł(x,y)VRAMł(x,y)ɕϊ
            int charaOffset = m_BG_Classes[engine].bg[activeBgNum].GetCharaDataOffset( (*i).x, (*i).y);
            int vramX, vramY;
            m_BG_Classes[engine].bgVRAM.GetPosition(charaOffset, &vramX, &vramY);
            int scale = m_BG_Classes[engine].bgVRAM.GetScale();

            //VRAM̕`
            if(engine == ENGINE_A){ UsefulFunctions::DrawBox(Form1->BG_A_VRAM->Picture->Bitmap, vramX, vramY, scale); }
            else {                  UsefulFunctions::DrawBox(Form1->BG_B_VRAM->Picture->Bitmap, vramX, vramY, scale); }

        }
    }
    else {
        if(engine == ENGINE_A){ Form1->OBJ_A_VRAM->Picture->Assign( m_OBJ_Classes[engine].objVRAM.GetBMP() ); }
        else {                  Form1->OBJ_B_VRAM->Picture->Assign( m_OBJ_Classes[engine].objVRAM.GetBMP() ); }

        for(PositionList::iterator i=OBJCursors.begin(); i!=OBJCursors.end(); i++){
            //ʑł(x,y)VRAMł(x,y)ɕϊ
            int charaOffset = m_OBJ_Classes[engine].obj.GetCharaDataOffset( (*i).x, (*i).y);
            int vramX, vramY;
            m_OBJ_Classes[engine].objVRAM.GetPosition(charaOffset, &vramX, &vramY);
            int scale = m_OBJ_Classes[engine].objVRAM.GetScale();

            //VRAM̕`
            if(engine == ENGINE_A){ UsefulFunctions::DrawBox(Form1->OBJ_A_VRAM->Picture->Bitmap, vramX, vramY, scale); }
            else {                  UsefulFunctions::DrawBox(Form1->OBJ_B_VRAM->Picture->Bitmap, vramX, vramY, scale); }

        }
    }
}


void VRAMViewerMain::ReDrawExPalette(bool bg, ENGINE engine){
    if(bg){
        if(engine == ENGINE_A){ Form1->BG_A_ExPalette->Picture->Assign( m_BG_Classes[engine].exPalette.GetBMP() ); }
        else {                  Form1->BG_B_ExPalette->Picture->Assign( m_BG_Classes[engine].exPalette.GetBMP() ); }
    }
    else {
        if(engine == ENGINE_A){ Form1->OBJ_A_ExPalette->Picture->Assign( m_OBJ_Classes[engine].exPalette.GetBMP() ); }
        else {                  Form1->OBJ_B_ExPalette->Picture->Assign( m_OBJ_Classes[engine].exPalette.GetBMP() ); }
    }
}


void VRAMViewerMain::SetPullDownPaletteNum(  bool bg, ENGINE engine, int paletteNum){
    if(bg){ m_BG_Classes[engine].exPalette.SetPaletteNum(paletteNum);  }
    else{   m_OBJ_Classes[engine].exPalette.SetPaletteNum(paletteNum);  }
    ReDrawExPalette(bg, engine);
}


void VRAMViewerMain::SetPullDownSlotNum(     bool bg, ENGINE engine, int slotNum){
    if(bg){ m_BG_Classes[engine].exPalette.SetSlot(slotNum);  }
    ReDrawExPalette(bg, engine);
}


void VRAMViewerMain::SetPullDownTextureType(TextureType type){
    m_textureClasses.texture.Init(m_rawData[RDT_TEXTURE_IMAGE], &m_textureClasses.palette, type);	//eNX`̕`
    Form1->Texture->Picture->Assign( m_textureClasses.texture.GetBMP()    );						//eNXrbg}bv󂯎
}


void VRAMViewerMain::ScaleBGForAnotherForm(int scale){
    m_bgScale = scale;
    m_BG_Classes[activeEngineBG].bg[activeBgNum].SetScale(scale);
    Form2->Image1->Picture->Assign( m_BG_Classes[activeEngineBG].bg[activeBgNum].GetBMP());
    for(PositionList::iterator i=BGCursors.begin(); i!=BGCursors.end(); i++){
        UsefulFunctions::DrawBox(Form2->Image1->Picture->Bitmap, (*i).x*m_bgScale, (*i).y*m_bgScale, m_bgScale);	//ʑ̕`
    }
}


void VRAMViewerMain::JumpCursor(TScrollBox *box, int y){
    int destination	= (y - box->Height/2 > 0) ? y - box->Height/2 : 0;
    int nowPos		= box->VertScrollBar->Position;
    if( abs(destination-nowPos) < 30){
        return;
    }
    while( abs(destination-nowPos) > 4 ){
        int nextPos = (nowPos * 9 + destination) / 10;
        if(nowPos == nextPos){
            if(destination-nowPos > 0){	nowPos++;	}
            else {		                nowPos--;   }
        }
        else {
            nowPos = nextPos;
        }
        box->VertScrollBar->Position = nowPos;
    }
}


void VRAMViewerMain::DisplayCursorBG(int X, int Y){
	int charaUnit = 8 * m_bgScale;
    int x = (X / charaUnit ) * 8;
    int y = (Y / charaUnit ) * 8;

    //g̒ǉ𔻒f
    bool erase = false;
    for(PositionList::iterator i=BGCursors.begin(); i!=BGCursors.end(); i++){
        if( (*i).x == x && (*i).y == y ){
            erase = true;
            BGCursors.erase(i);
            break;
        }
    }

    if(erase){
        //S`
        Form2->Image1->Picture->Assign( m_BG_Classes[activeEngineBG].bg[activeBgNum].GetBMP());
        if(activeEngineBG == ENGINE_A){ Form1->BG_A_VRAM->Picture->Assign( m_BG_Classes[ENGINE_A].bgVRAM.GetBMP() ); }
        else {                          Form1->BG_B_VRAM->Picture->Assign( m_BG_Classes[ENGINE_B].bgVRAM.GetBMP() ); }

        for(PositionList::iterator i=BGCursors.begin(); i!=BGCursors.end(); i++){
            //ʑ̕`
            UsefulFunctions::DrawBox(Form2->Image1->Picture->Bitmap, (*i).x*m_bgScale, (*i).y*m_bgScale, m_bgScale);

            //ʑł(x,y)VRAMł(x,y)ɕϊ
            int charaOffset = m_BG_Classes[activeEngineBG].bg[activeBgNum].GetCharaDataOffset( (*i).x, (*i).y);
            int vramX, vramY;
            m_BG_Classes[activeEngineBG].bgVRAM.GetPosition(charaOffset, &vramX, &vramY);
            int scale = m_BG_Classes[activeEngineBG].bgVRAM.GetScale();

            //VRAM̕`
            if(activeEngineBG == ENGINE_A){ UsefulFunctions::DrawBox(Form1->BG_A_VRAM->Picture->Bitmap, vramX, vramY, scale); }
            else {                          UsefulFunctions::DrawBox(Form1->BG_B_VRAM->Picture->Bitmap, vramX, vramY, scale); }
        }
    }
    else{   //ǉ
        //ǉĕʑɘg`
        Position pos = {x, y};
        BGCursors.push_back(pos);
        UsefulFunctions::DrawBox(Form2->Image1->Picture->Bitmap, x*m_bgScale, y*m_bgScale, m_bgScale);

        //VRAM̒ǉ`

        //ʑł(x,y)VRAMł(x,y)ɕϊ
        int charaOffset = m_BG_Classes[activeEngineBG].bg[activeBgNum].GetCharaDataOffset(x, y);
        int vramX, vramY;
        m_BG_Classes[activeEngineBG].bgVRAM.GetPosition(charaOffset, &vramX, &vramY);
        int scale = m_BG_Classes[activeEngineBG].bgVRAM.GetScale();

        //VRAM̕`
        if(activeEngineBG == ENGINE_A){
            UsefulFunctions::DrawBox(Form1->BG_A_VRAM->Picture->Bitmap, vramX, vramY, scale);
            JumpCursor(Form1->ScrollBox1, vramY);
        }
        else {
            UsefulFunctions::DrawBox(Form1->BG_B_VRAM->Picture->Bitmap, vramX, vramY, scale);
            JumpCursor(Form1->ScrollBox7, vramY);
        }
    }
}


void VRAMViewerMain::DisplayCursorOBJ(int X, int Y){
    int charaUnit = 8 * OBJ_SCALE;
    int x = (X / charaUnit ) * 8;
    int y = (Y / charaUnit ) * 8;

    //g̒ǉ𔻒f
    bool erase = false;
    for(PositionList::iterator i=OBJCursors.begin(); i!=OBJCursors.end(); i++){
        if( (*i).x == x && (*i).y == y ){
            erase = true;
            OBJCursors.erase(i);
            break;
        }
    }

    if(erase){
        //S`
        Form3->Image1->Picture->Assign( m_OBJ_Classes[activeEngineOBJ].obj.GetOBJBMPPrev());
        if(activeEngineOBJ == ENGINE_A){ Form1->OBJ_A_VRAM->Picture->Assign( m_OBJ_Classes[ENGINE_A].objVRAM.GetBMP() ); }
        else {                          Form1->OBJ_B_VRAM->Picture->Assign( m_OBJ_Classes[ENGINE_B].objVRAM.GetBMP() ); }

        for(PositionList::iterator i=OBJCursors.begin(); i!=OBJCursors.end(); i++){
            //ʑ̕`
            UsefulFunctions::DrawBox(Form3->Image1->Picture->Bitmap, (*i).x*OBJ_SCALE, (*i).y*OBJ_SCALE, OBJ_SCALE);

            //ʑł(x,y)VRAMł(x,y)ɕϊ
            int charaOffset = m_OBJ_Classes[activeEngineOBJ].obj.GetCharaDataOffset( (*i).x, (*i).y);
            int vramX, vramY;
            m_OBJ_Classes[activeEngineOBJ].objVRAM.GetPosition(charaOffset, &vramX, &vramY);
            int scale = m_OBJ_Classes[activeEngineOBJ].objVRAM.GetScale();

            //VRAM̕`
            if(activeEngineOBJ == ENGINE_A){	UsefulFunctions::DrawBox(Form1->OBJ_A_VRAM->Picture->Bitmap, vramX, vramY, scale); }
            else {                          	UsefulFunctions::DrawBox(Form1->OBJ_B_VRAM->Picture->Bitmap, vramX, vramY, scale); }
        }
    }
    else{   //ǉ
        //ǉĕʑɘg`
        Position pos = {x, y};
        OBJCursors.push_back(pos);
        UsefulFunctions::DrawBox(Form3->Image1->Picture->Bitmap, x*OBJ_SCALE, y*OBJ_SCALE, OBJ_SCALE);

        //VRAM̒ǉ`

        //ʑł(x,y)VRAMł(x,y)ɕϊ
        int charaOffset = m_OBJ_Classes[activeEngineOBJ].obj.GetCharaDataOffset(x, y);
        int vramX, vramY;
        m_OBJ_Classes[activeEngineOBJ].objVRAM.GetPosition(charaOffset, &vramX, &vramY);
        int scale = m_OBJ_Classes[activeEngineOBJ].objVRAM.GetScale();

        //VRAM̕`
        if(activeEngineOBJ == ENGINE_A){
            UsefulFunctions::DrawBox(Form1->OBJ_A_VRAM->Picture->Bitmap, vramX, vramY, scale);
            JumpCursor(Form1->ScrollBox12, vramY);
        }
        else {
            UsefulFunctions::DrawBox(Form1->OBJ_B_VRAM->Picture->Bitmap, vramX, vramY, scale);
            JumpCursor(Form1->ScrollBox13, vramY);
        }
    }
}


void VRAMViewerMain::OfferResourceBG(){
	BG_Info info[ENGINES][BGS];
    Register::GetBG_Info(m_rawData[RDT_REGISTER], info);



    m_BG_Classes[ENGINE_A].palette.Init(    NORMAL,     m_rawData[RDT_BG_NORMAL_PALETTE_A], 0);
    m_BG_Classes[ENGINE_A].exPalette.Init(  EXTENDED,   m_rawData[RDT_BG_EX_PALETTE_A],     0);
    m_BG_Classes[ENGINE_A].bgVRAM.Init(     RDT_BG_VRAM_A,
                                            m_rawData[RDT_BG_VRAM_A],
                                            &m_BG_Classes[ENGINE_A].palette,
                                            &m_BG_Classes[ENGINE_A].exPalette);
    
    m_BG_Classes[ENGINE_B].palette.Init(    NORMAL,     m_rawData[RDT_BG_NORMAL_PALETTE_B], 0);
    m_BG_Classes[ENGINE_B].exPalette.Init(  EXTENDED,   m_rawData[RDT_BG_EX_PALETTE_B],     0);
    m_BG_Classes[ENGINE_B].bgVRAM.Init(     RDT_BG_VRAM_B,
                                            m_rawData[RDT_BG_VRAM_B],
                                            &m_BG_Classes[ENGINE_B].palette,
                                            &m_BG_Classes[ENGINE_B].exPalette);
    for(int bgNum=0; bgNum<4; bgNum++){
        m_BG_Classes[ENGINE_A].bg[bgNum].Init(  m_rawData[RDT_BG_VRAM_A],
                                                &m_BG_Classes[ENGINE_A].palette,
                                                &m_BG_Classes[ENGINE_A].exPalette,
                                                info[ENGINE_A][bgNum]
                                             );
        m_BG_Classes[ENGINE_B].bg[bgNum].Init(  m_rawData[RDT_BG_VRAM_B],
                                                &m_BG_Classes[ENGINE_B].palette,
                                                &m_BG_Classes[ENGINE_B].exPalette,
                                                info[ENGINE_B][bgNum]
                                             );
    }
}


void VRAMViewerMain::AssignResultBG(){
	Form1->BG_A_Palette     ->Picture->Assign( m_BG_Classes[ENGINE_A].palette.GetBMP()  );
    Form1->BG_A_ExPalette   ->Picture->Assign( m_BG_Classes[ENGINE_A].exPalette.GetBMP());
    Form1->BG_A_VRAM        ->Picture->Assign( m_BG_Classes[ENGINE_A].bgVRAM.GetBMP()   );
    Form1->BG_A_0           ->Picture->Assign( m_BG_Classes[ENGINE_A].bg[0].GetBMP()    );
    Form1->BG_A_1           ->Picture->Assign( m_BG_Classes[ENGINE_A].bg[1].GetBMP()    );
    Form1->BG_A_2           ->Picture->Assign( m_BG_Classes[ENGINE_A].bg[2].GetBMP()    );
    Form1->BG_A_3           ->Picture->Assign( m_BG_Classes[ENGINE_A].bg[3].GetBMP()    );

    Form1->BG_B_Palette     ->Picture->Assign( m_BG_Classes[ENGINE_B].palette.GetBMP()  );
    Form1->BG_B_ExPalette   ->Picture->Assign( m_BG_Classes[ENGINE_B].exPalette.GetBMP());
    Form1->BG_B_VRAM        ->Picture->Assign( m_BG_Classes[ENGINE_B].bgVRAM.GetBMP()   );
    Form1->BG_B_0           ->Picture->Assign( m_BG_Classes[ENGINE_B].bg[0].GetBMP()    );
    Form1->BG_B_1           ->Picture->Assign( m_BG_Classes[ENGINE_B].bg[1].GetBMP()    );
    Form1->BG_B_2           ->Picture->Assign( m_BG_Classes[ENGINE_B].bg[2].GetBMP()    );
    Form1->BG_B_3           ->Picture->Assign( m_BG_Classes[ENGINE_B].bg[3].GetBMP()    );
}


void VRAMViewerMain::OfferResourceOBJ(){
	OBJ_Info objInfo[ENGINES];
    Register::GetOBJ_Info(m_rawData[RDT_REGISTER], objInfo);

    OAM_Info oamInfo[ENGINES][OAMS];
    OAM::GetOAM_Info(m_rawData[RDT_OAM_A], oamInfo[ENGINE_A]);
    OAM::GetOAM_Info(m_rawData[RDT_OAM_B], oamInfo[ENGINE_B]);

    m_OBJ_Classes[ENGINE_A].palette.Init(   NORMAL,     m_rawData[RDT_OBJ_NORMAL_PALETTE_A], 0);
    m_OBJ_Classes[ENGINE_A].exPalette.Init( EXTENDED,   m_rawData[RDT_OBJ_EX_PALETTE_A],     0);
    m_OBJ_Classes[ENGINE_A].obj.Init(  m_rawData[RDT_OBJ_VRAM_A],
                                       &m_OBJ_Classes[ENGINE_A].palette,
                                       &m_OBJ_Classes[ENGINE_A].exPalette,
                                       objInfo[ENGINE_A],
                                       oamInfo[ENGINE_A]
                                    );
    m_OBJ_Classes[ENGINE_A].objVRAM.Init(   RDT_OBJ_VRAM_A,
                                            m_rawData[RDT_OBJ_VRAM_A],
                                            &m_OBJ_Classes[ENGINE_A].palette,
                                            &m_OBJ_Classes[ENGINE_A].exPalette
                                        );

    m_OBJ_Classes[ENGINE_B].palette.Init(   NORMAL,     m_rawData[RDT_OBJ_NORMAL_PALETTE_B], 0);
    m_OBJ_Classes[ENGINE_B].exPalette.Init( EXTENDED,   m_rawData[RDT_OBJ_EX_PALETTE_B],     0);
    m_OBJ_Classes[ENGINE_B].obj.Init(  m_rawData[RDT_OBJ_VRAM_B],
                                       &m_OBJ_Classes[ENGINE_B].palette,
                                       &m_OBJ_Classes[ENGINE_B].exPalette,
                                       objInfo[ENGINE_B],
                                       oamInfo[ENGINE_B]
                                    );
    m_OBJ_Classes[ENGINE_B].objVRAM.Init(   RDT_OBJ_VRAM_B,
                                            m_rawData[RDT_OBJ_VRAM_B],
                                            &m_OBJ_Classes[ENGINE_B].palette,
                                            &m_OBJ_Classes[ENGINE_B].exPalette
                                        );
}


void VRAMViewerMain::AssignResultOBJ(){
	Form1->OBJ_A_Palette    ->Picture->Assign( m_OBJ_Classes[ENGINE_A].palette.GetBMP()     );
    Form1->OBJ_A_ExPalette  ->Picture->Assign( m_OBJ_Classes[ENGINE_A].exPalette.GetBMP()   );
    Form1->OBJ_A            ->Picture->Assign( m_OBJ_Classes[ENGINE_A].obj.GetBMP()         );
    Form1->OBJ_A_VRAM       ->Picture->Assign( m_OBJ_Classes[ENGINE_A].objVRAM.GetBMP()     );

    Form1->OBJ_B_Palette    ->Picture->Assign( m_OBJ_Classes[ENGINE_B].palette.GetBMP()     );
    Form1->OBJ_B_ExPalette  ->Picture->Assign( m_OBJ_Classes[ENGINE_B].exPalette.GetBMP()   );
    Form1->OBJ_B            ->Picture->Assign( m_OBJ_Classes[ENGINE_B].obj.GetBMP()         );
    Form1->OBJ_B_VRAM       ->Picture->Assign( m_OBJ_Classes[ENGINE_B].objVRAM.GetBMP()     );
}
