// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#ifndef VRAMViewerMainH
#define VRAMViewerMainH

#include <system.hpp>

#include "palette.h"
#include "BG.h"
#include "OBJ.h"
#include "VRAM.h"
#include "texture.h"
#include "enums.h"
#include <list>
//---------------------------------------------------------------------------
struct Position{
    int x;
    int y;
};

typedef std::list<Position> PositionList;

//#define DSVV_DEBUG

struct BG_Classes {
	Palette palette;
    Palette exPalette;
    BG      bg[BGS];
    VRAM    bgVRAM;
};

struct OBJ_Classes {
	Palette palette;
    Palette exPalette;
    OBJ     obj;
    VRAM    objVRAM;
};

struct TextureClasses {
	Palette palette;
    Texture texture;
};


class VRAMViewerMain{
    public:
        VRAMViewerMain();
        ~VRAMViewerMain();

        void    LoadAllInOneRawData(const AnsiString &path);		//ǍpFpbNf[^ǂݍ
        void    LoadDataFromDS(const void *pAdrs, DWORD nSize);		//ǍpFDSf[^Mēǂݍ
        void    LoadData(RAW_DATA_TYPE, const AnsiString &path); 	//ǍpFNITRO_DEBUGGERǂݍ
        void    LoadData(RAW_DATA_TYPE, const void *); 	            //ǍpFENSATAǂݍ

        void    SaveAllInOneRawData(const AnsiString &path);		//o͗pFpbNf[^ۑ

        //}EX{^Cxgp
        void    DisplayBGForAnotherForm(ENGINE, int bgNum);
        void    DisplayOBJForAnotherForm(ENGINE, int x, int y);
        void    DisplayPaletteInfo( int X, int Y, bool bg);
        void    DisplayCursor(      int X, int Y, bool bg);
        void    InitForAnotherForm(bool bg);

        //|bvAbvj[p
        void    SetPopupInfoScale(      bool bg, ENGINE, bool);
        void    SetPopupInfoDisplayType(bool bg, ENGINE, BGType);
        void    SetPopupInfoPaletteNum( bool bg, ENGINE, int);
        void    SetPopupInfoPaletteSlot(bool bg, ENGINE, int);
        void    ScaleBGForAnotherForm(int scale);

        //v_Ej[p
        void    SetPullDownPaletteNum(  bool bg, ENGINE, int);
        void    SetPullDownSlotNum(     bool bg, ENGINE, int);
        void    SetPullDownTextureType( TextureType         );
		void	DisplayAll();

    private:
        char            *m_rawData[RDT_ALL_RAW_DATA];

        BG_Classes      m_BG_Classes[ENGINES];
        OBJ_Classes     m_OBJ_Classes[ENGINES];
        TextureClasses  m_textureClasses;

		ENGINE			activeEngineBG;
        ENGINE			activeEngineOBJ;
        int				activeBgNum;
        int				m_bgScale;
        PositionList	BGCursors;
        PositionList	OBJCursors;
        
        void	ReconstructRawData();
        void	DisplayBG();
        void	DisplayOBJ();
        void	DisplayTexture();
        void	SetCaptionHeight();
        void	OfferResourceBG();
        void	AssignResultBG();
        void	OfferResourceOBJ();
        void	AssignResultOBJ();

        //|bvAbvj[p
        void	ReDrawVRAM(bool bg, ENGINE);
        void	ReDrawExPalette(bool bg, ENGINE);

		//J[\
        void	JumpCursor(TScrollBox*, int y);
        void	DisplayCursorBG(	int X, int Y);
        void	DisplayCursorOBJ(	int X, int Y);
};

#endif
 