
// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#pragma hdrstop

#include "palette.h"
#include "usefulFunctions.h"
//---------------------------------------------------------------------------

static const int PALETTE_WIDTH[]    = {16,  16,     256/4, 256/4,   256/4,  256/4,  256/4,  256/4 };  //PaletteType
static const int PALETTE_HEIGHT[]   = {16,  256,    28*4,  192*4,   192*4,  192*4,  192*4,  192*4};  //PaletteType

static const int SLOT_LENGTH = 0x2000;


static const int NORMAL_EX_SCALE = 16;
static const int TEXTURE_SCALE   = 4;


Palette::Palette() :
    m_rawData(NULL),
    m_slot(0),
    m_paletteNum(0),
    m_type(NORMAL),
    m_colorData(NULL){
    m_bmp = new TBITMAP;
}


Palette::~Palette(){
    delete[] m_colorData;
    delete m_bmp;
}


void Palette::SetPaletteType(PaletteType type){
    m_type = type;
    delete[] m_colorData;
    m_colorData = NULL; 
    m_colorData = new unsigned char[ PALETTE_WIDTH[type] * PALETTE_HEIGHT[type] * 3];
}


void Palette::SetRawData(const char *rawData){
    m_rawData = rawData;
}


void Palette::SetSlot(int slotNum){
    if(m_type == EXTENDED){
        m_slot = slotNum;
    }
    else {
        m_slot = 0;
    }
    SetBMP();
}


void Palette::SetPaletteNum(int paletteNum){
    m_paletteNum = paletteNum;
    SetBMP();
}


void Palette::Init(
                    PaletteType type,
                    const char  *rawData,
                    int         slot
                 )
{
    SetPaletteType(type);
    SetRawData(rawData);
    SetSlot(slot);
}


TBITMAP*  Palette::GetBMP() const{
    return m_bmp;
}


void Palette::GetColor16by16(int paletteNum,		int paletteIndex, unsigned char dst[]) const{
	dst[0] = m_colorData[ (paletteNum*16 + paletteIndex) * 3 ];
	dst[1] = m_colorData[ (paletteNum*16 + paletteIndex) * 3 + 1];
	dst[2] = m_colorData[ (paletteNum*16 + paletteIndex) * 3 + 2];
}


void Palette::GetColor256by1(					int paletteIndex, unsigned char dst[]) const{
	dst[0] = m_colorData[ paletteIndex * 3 ];
	dst[1] = m_colorData[ paletteIndex * 3 + 1];
	dst[2] = m_colorData[ paletteIndex * 3 + 2];
}


void Palette::GetColor256by16(int paletteNum,	int paletteIndex, unsigned char dst[]) const{
	dst[0] = m_colorData[ (paletteNum*256 + paletteIndex) * 3 ];
	dst[1] = m_colorData[ (paletteNum*256 + paletteIndex) * 3 + 1];
	dst[2] = m_colorData[ (paletteNum*256 + paletteIndex) * 3 + 2];
}


PaletteType Palette::GetPaletteType() const{
    return m_type;
}


void Palette::SetBMP(){

    m_bmp->Width    = PALETTE_WIDTH[m_type];
    m_bmp->Height   = PALETTE_HEIGHT[m_type];

    //1sNZf[^Ƃɏ
    switch(m_type){
        case NORMAL:
        case EXTENDED:
            SetBMP_NORMALandEX();
        break;

        case TEXTURE_4COLOR:
        case TEXTURE_16COLOR:
        case TEXTURE_256COLOR:
        case TEXTURE_4BY4COMPRESSED:
        case TEXTURE_A315:
        case TEXTURE_A513:
            SetBMP_TEXTURE();
        break;
    }

    Scaling();
}


void Palette::SetBMP_NORMALandEX(){
    int width = m_bmp->Width;
    int height = m_bmp->Height;
    m_bmp->PixelFormat = pf24bit;
    
    for(int y=0; y<height; y++){
    	for(int x=0; x<width; x++){
			//DS16bitJ[irbg}bvɂ͐ɑΉĂȂj
    		unsigned short colorData16bit;
    		memcpy( 
    				&colorData16bit,
					&m_rawData[(x + width * y) * sizeof(unsigned short) + m_slot * SLOT_LENGTH],
            		sizeof(unsigned short)
            	  );
            UsefulFunctions::ChangeBit16to24(colorData16bit, &m_colorData[(x+width*y)*3]);
    	}

    	//Ήpbgԍ̂Ƃ̓rbg}bvɂf[^
    	if(m_paletteNum == y/16 ){
    		int	row = y - (m_paletteNum * 16);
    		memcpy(m_bmp->ScanLine[row], &m_colorData[width * y * 3], width*3);
    	}
    }
}


void Palette::SetBMP_TEXTURE(){
    int width = m_bmp->Width;
    int height = m_bmp->Height;
    m_bmp->PixelFormat = pf24bit;

    for(int y=0; y<height; y++){
    	for(int x=0; x<width; x++){
			//DS16bitJ[irbg}bvɂ͐ɑΉĂȂj
    		unsigned short colorData16bit;
    		memcpy(
    				&colorData16bit,
					&m_rawData[(x + width *  y) * sizeof(unsigned short)],
            		sizeof(unsigned short)
            	  );
            UsefulFunctions::ChangeBit16to24(colorData16bit, &m_colorData[(x+width*y)*3]);
    	}
		memcpy(m_bmp->ScanLine[y], &m_colorData[y*width*3], width*3);
    }
}


void Palette::Scaling(){
    switch(m_type){
        case NORMAL:
        case EXTENDED:
            UsefulFunctions::ReadBMPFileWithScale(m_bmp, NORMAL_EX_SCALE);
        break;

        case TEXTURE_4COLOR:
        case TEXTURE_16COLOR:
        case TEXTURE_256COLOR:
        case TEXTURE_4BY4COMPRESSED:
        case TEXTURE_A315:
        case TEXTURE_A513:
            UsefulFunctions::ReadBMPFileWithScale(m_bmp, TEXTURE_SCALE);
        break;
    }
}
