// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#ifndef paletteH
#define paletteH

#include "structs.h"
#include "constants.h"
//---------------------------------------------------------------------------

class Palette{
    public:
        Palette();
        ~Palette();

        void SetPaletteType(PaletteType);
        void SetRawData(const char *rawData);
        void SetSlot(int slotNum);
        void SetPaletteNum(int paletteNum);
        void Init(
                    PaletteType type,
                    const char  *rawData,
                    int         slot
                 );

        TBITMAP*  GetBMP() const;

        void GetColor16by16(int paletteNum,		int paletteIndex, unsigned char dst[]) const;
        void GetColor256by1(					int paletteIndex, unsigned char dst[]) const;
        void GetColor256by16(int paletteNum,	int paletteIndex, unsigned char dst[]) const;
    
        PaletteType GetPaletteType() const;

    private:
        const char		*m_rawData;
        TBITMAP 		*m_bmp;
        unsigned char	*m_colorData;

        int 			m_slot;
        int         	m_paletteNum;
        PaletteType		m_type;

        void SetBMP();
        void SetBMP_NORMALandEX();
        void SetBMP_TEXTURE();

        void Scaling();
};

#endif
