// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#pragma hdrstop

#include "register.h"
#include "Unit1.h"
//---------------------------------------------------------------------------

static int rowIndex = 1;

//̃vOŎgp萔f[^
static const int SCREEN_WIDTH[4][4][4] = {  //bgNum, screenSize, bgType
    //BG0
    {
        {256,   NULL,   NULL,   NULL}, 
        {512,   NULL,   NULL,   NULL},
        {256,   NULL,   NULL,   NULL},
        {512,   NULL,   NULL,   NULL}
    },
    //BG1
    {
        {256,   NULL,   NULL,   NULL},
        {512,   NULL,   NULL,   NULL},
        {256,   NULL,   NULL,   NULL},
        {512,   NULL,   NULL,   NULL}
    },
    //BG2
    {
        {256,   128,    128,    512},
        {512,   256,    256,    1024},
        {256,   512,    512,    NULL},
        {512,   1024,   1024,   NULL}
    },
    //BG3
    {
        {256,   128,    128,    512},
        {512,   256,    256,    1024},
        {256,   512,    512,    NULL},
        {512,   1024,   1024,   NULL}
    }
};

static const int SCREEN_HEIGHT[4][4][4] = {  //bgNum, screenSize, bgType
    //BG0
    {
        {256,   NULL,   NULL,   NULL},
        {256,   NULL,   NULL,   NULL},
        {512,   NULL,   NULL,   NULL},
        {512,   NULL,   NULL,   NULL}
    },
    //BG1
    {
        {256,   NULL,   NULL,   NULL},
        {256,   NULL,   NULL,   NULL},
        {512,   NULL,   NULL,   NULL},
        {512,   NULL,   NULL,   NULL}
    },
    //BG2
    {
        {256,   128,    128,    1024},
        {256,   256,    256,    512},
        {512,   512,    512,    NULL},
        {512,   1024,   1024,   NULL}
    },
    //BG3
    {
        {256,   128,    128,    1024},
        {256,   256,    256,    512},
        {512,   512,    512,    NULL},
        {512,   1024,   1024,   NULL}
    }
};

static const int MAX_CHARACTERS[] = { 1024, 256, 1024, NULL };  //BG_Type

static const BGType BG_TYPE[7][4] = {  //BG_mode, bgNum
    {TEXT_BG,   TEXT_BG,    TEXT_BG,            TEXT_BG},
    {TEXT_BG,   TEXT_BG,    TEXT_BG,            AFFINE_BG},
    {TEXT_BG,   TEXT_BG,    AFFINE_BG,          AFFINE_BG},
    {TEXT_BG,   TEXT_BG,    TEXT_BG,            EXTENDED_AFFINE_BG},
    {TEXT_BG,   TEXT_BG,    AFFINE_BG,          EXTENDED_AFFINE_BG},
    {TEXT_BG,   TEXT_BG,    EXTENDED_AFFINE_BG, EXTENDED_AFFINE_BG},
    {TYPE_ERROR,TYPE_ERROR, BITMAP_BG,          TYPE_ERROR}
};

static const RAW_DATA_TYPE DATA_TYPE[VRAMS][8] = {   //VRAM, mst
    //VRAM_A
    {
        RDT_LCDC,
        RDT_BG_VRAM_A,
        RDT_OBJ_VRAM_A,
        RDT_TEXTURE_IMAGE,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_B
    {
        RDT_LCDC,
        RDT_BG_VRAM_A,
        RDT_OBJ_VRAM_A,
        RDT_TEXTURE_IMAGE,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_C
    {
        RDT_LCDC,
        RDT_BG_VRAM_A,
        RDT_ALL_RAW_DATA,
        RDT_TEXTURE_IMAGE,
        RDT_BG_VRAM_B,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_D
    {
        RDT_LCDC,
        RDT_BG_VRAM_A,
        RDT_ALL_RAW_DATA,
        RDT_TEXTURE_IMAGE,
        RDT_OBJ_VRAM_B,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_E
    {
        RDT_LCDC,
        RDT_BG_VRAM_A,
        RDT_OBJ_VRAM_A,
        RDT_TEXTURE_PALETTE,
        RDT_BG_EX_PALETTE_A,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_F
    {
        RDT_LCDC,
        RDT_BG_VRAM_A,
        RDT_OBJ_VRAM_A,
        RDT_TEXTURE_PALETTE,
        RDT_BG_EX_PALETTE_A,
        RDT_OBJ_EX_PALETTE_A,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_G
    {
        RDT_LCDC,
        RDT_BG_VRAM_A,
        RDT_OBJ_VRAM_A,
        RDT_TEXTURE_PALETTE,
        RDT_BG_EX_PALETTE_A,
        RDT_OBJ_EX_PALETTE_A,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_H
    {
        RDT_LCDC,
        RDT_BG_VRAM_B,
        RDT_BG_EX_PALETTE_B,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    },
    //VRAM_I
    {
        RDT_LCDC,
        RDT_BG_VRAM_B,
        RDT_OBJ_VRAM_B,
        RDT_OBJ_EX_PALETTE_B,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA,
        RDT_ALL_RAW_DATA
    }
};
static const int VRAM_DATA_POS[VRAMS] = {
    0x240,
    0x241,
    0x242,
    0x243,
    0x244,
    0x245,
    0x246,
    0x248,
    0x249
};


static const int VRAM_OFFSET[VRAMS][8][4] = {   //VRAM, mst, ofs
    //VRAM_A
    {
        {NULL,  NULL,       NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {0,     0x20000,    NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_B
    {
        {NULL,  NULL,       NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {0,     0x20000,    NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_C
    {
        {NULL,  NULL,       NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {0,     0x20000,    NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_D
    {
        {NULL,  NULL,       NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {0,     0x20000,    NULL,       NULL},
        {0,     0x20000,    0x40000,    0x60000},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_E
    {
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {0,     0,          0,          0},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_F
    {
        {NULL,  NULL,       NULL,       NULL},
        {0,     0x4000,     0x10000,    0x14000},
        {0,     0x4000,     0x10000,    0x14000},
        {0,     0x4000,     0x10000,    0x14000},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_G
    {
        {NULL,  NULL,       NULL,       NULL},
        {0,     0x4000,     0x10000,    0x14000},
        {0,     0x4000,     0x10000,    0x14000},
        {0,     0x4000,     0x10000,    0x14000},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_H
    {
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    },
    //VRAM_I
    {
        {NULL,  NULL,       NULL,       NULL},
        {0x8000,0x8000,     0x8000,     0x8000},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL},
        {NULL,  NULL,       NULL,       NULL}
    }
};

static const int MST_MASK[VRAMS] = {3, 3, 7, 7, 7, 7, 7, 3, 3};

static const char OFS_MASK = 3;

static const char OFS_SHIFT = 3;

static const char ENABLE_SHIFT = 7;

static const int SLOT_NUM[4][2] = { //bgNum,cnt
    {0,2}, {1,3}, {2,2}, {3,3}
};

//////////////////////////////////////////////

void Register::GetVRAM_Info(   const char *rawData, VRAM_Info  info[VRAMS]){
    for(int i=VRAM_A; i<VRAMS; i++){
        info[i].enable = rawData[ VRAM_DATA_POS[i] ] >> ENABLE_SHIFT;
        if(info[i].enable){
            char mst =  rawData[ VRAM_DATA_POS[i] ] & MST_MASK[i];
            char ofs = (rawData[ VRAM_DATA_POS[i] ] >> OFS_SHIFT) & OFS_MASK;
            info[i].dataType = DATA_TYPE[i][mst];
            info[i].offset   = VRAM_OFFSET[i][mst][ofs];
        }
        else {
            //ꉞ_~[Ă
            info[i].dataType = DATA_TYPE[i][0];
            info[i].offset   = VRAM_OFFSET[i][0][0];
        }
    }
}


void Register::GetBG_Info(     const char *rawData, BG_Info    info[ENGINES][BGS]){
    rowIndex = 1;
	
	//
    for(int i=0; i<BGS; i++){
        for(int engine = ENGINE_A; engine <= ENGINE_B; engine++){
            info[engine][i].screenWidth        = 0;
            info[engine][i].screenHeight       = 0;
            info[engine][i].charaDataSize      = 0;
            info[engine][i].maxCharacters      = 0;
            info[engine][i].charaBaseBlock     = 0;
            info[engine][i].charaBaseOffset    = 0;
            info[engine][i].screenBaseBlock    = 0;
            info[engine][i].screenBaseOffset   = 0;

            info[engine][i].type               = TEXT_BG;
            info[engine][i].enable             = false;
        }
    }

    char reg;           //WX^f[^PoCg
    int result;         //WX^f[^̏ʈꎞۑp
    AnsiString keyName; //o͕\FL[
    AnsiString value;   //o͕\Fl

    RegPrivate::InsertRow("ENGINE_A", " ");
    {
        memcpy(&reg, &rawData[0], 1);
        char BGmodeMask = 0x07;
        keyName = "BG[h";
        result = (int)(reg & BGmodeMask);
        value = result;
        RegPrivate::InsertRow(keyName, value);
        RegPrivate::SetMaxCharaAndBGType(result, info[ENGINE_A]);

        keyName = "OBJ}bsO[h";
        result = (int)( (reg>>4) & 1);
        value = result ? "P}bsO" : "Q}bsOiΉj";
        RegPrivate::InsertRow(keyName, value);
    }

    {
        memcpy(&reg, &rawData[1], 1);
        char mask = 0x01;
        for(int i=0; i<4; i++){
            keyName = i;
            keyName.Insert("BG",0);
            if((reg>>i)& mask){
                value = "\܂";
                info[ENGINE_A][i].enable = true;
            }
            else {
                value = "\܂";
                info[ENGINE_A][i].enable = false;
            }
            RegPrivate::InsertRow(keyName, value);
        }
    }

    {
        memcpy(&reg, &rawData[3], 1);

        char baseOffsetMask = 0x07;
        keyName = "LN^x[XItZbg";
        result = (int)(reg & baseOffsetMask);
        value = result;
        RegPrivate::InsertRow(keyName, value);
        for(int vram_a=0; vram_a<4; vram_a++){
            info[ENGINE_A][vram_a].charaBaseOffset = result;
        }

        keyName = "XN[x[XItZbg";
        result = (int)( (reg>>3) & baseOffsetMask);
        value = result;
        RegPrivate::InsertRow(keyName, value);
        for(int vram_a=0; vram_a<4; vram_a++){
            info[ENGINE_A][vram_a].screenBaseOffset = result;
        }

        char mask = 0x01;
        keyName = "BGgpbg";
        result = (int)( (reg>>6) & mask);
        value = result ? "g":"gȂ";
        RegPrivate::InsertRow(keyName, value);
        for(int vram_a=0; vram_a<4; vram_a++){
            info[ENGINE_A][vram_a].extendedPalette = result;
        }
    }

    for(int BG =0; BG<4; BG++){
        AnsiString name = BG;
        name.Insert("",2);
        name.Insert("BG",0);
        RegPrivate::InsertRow(name, " ");

        {
            memcpy(&reg, &rawData[8 + 2*BG], 1);

            char priorityMask = 0x03;
            keyName = "D揇";
            result = (int)( reg & priorityMask);
            value = result;
            RegPrivate::InsertRow(keyName, value);

            char charaBaseMask = 0x0f;
            keyName = "LN^x[XubN";
            result = (int)( (reg>>2) & charaBaseMask);
            value = result;
            RegPrivate::InsertRow(keyName, value);
            info[ENGINE_A][BG].charaBaseBlock = result;

            char colorModeMask = 0x01;
            keyName = "J[[h";
            if( (reg>>7) & colorModeMask ){
                value = "256F[h";
                info[ENGINE_A][BG].charaDataSize = 64;
            }
            else {
                value = "16F[h";
                info[ENGINE_A][BG].charaDataSize = 32;
            }
            RegPrivate::InsertRow(keyName, value);
        }

        {
            memcpy(&reg, &rawData[9 + 2*BG], 1);

            char screenBaseMask = 0x1f;
            keyName = "XN[x[XubN";
            result = (int)( reg & screenBaseMask);
            value = result;
            RegPrivate::InsertRow(keyName, value);
            info[ENGINE_A][BG].screenBaseBlock = result;

            char mask = 0x1;
            char slot = (reg>>5) & mask;
            RegPrivate::SetSlotNum(slot, BG, info[ENGINE_A][BG]);

            char screenSizeMask = 0x03;
            keyName = "XN[TCY";
            char sizeType = (reg>>6) & screenSizeMask;
            value = RegPrivate::SetScreenSize(sizeType, info[ENGINE_A][BG], info[ENGINE_A][BG].type, BG);
            RegPrivate::InsertRow(keyName, value);
        }
    }

    RegPrivate::InsertRow("", " ");
    RegPrivate::InsertRow("ENGINE_B", " ");
    {
        memcpy(&reg, &rawData[0x1000], 1);

        char BGmodeMask = 0x07;
        keyName = "BG[h";
        result = (int)(reg & BGmodeMask);
        value = result;
        RegPrivate::InsertRow(keyName, value);
        RegPrivate::SetMaxCharaAndBGType(result, info[ENGINE_B]);

        keyName = "OBJ}bsO[h";
        result = (int)( (reg>>4) & 1);
        value = result ? "P}bsO" : "Q}bsOiΉj";
        RegPrivate::InsertRow(keyName, value);
    }

    {
        memcpy(&reg, &rawData[0x1001], 1);

        char mask = 0x01;
        for(int i=0; i<4; i++){
            keyName = i;
            keyName.Insert("BG",0);
            if((reg>>i)& mask){
                value = "\܂";
                info[ENGINE_B][i].enable = true;
            }
            else {
                value = "\܂";
                info[ENGINE_B][i].enable = false;
            }
            RegPrivate::InsertRow(keyName, value);
        }

        for(int vram_b=0; vram_b<4; vram_b++){
            info[ENGINE_B][vram_b].charaBaseOffset = 0;
            info[ENGINE_B][vram_b].screenBaseOffset = 0;
        }
    }

    {
        memcpy(&reg, &rawData[0x1003], 1);
        
        char mask = 0x01;
        keyName = "BGgpbg";
        result = (int)( (reg>>6) & mask);
        value = result ? "g":"gȂ";
        RegPrivate::InsertRow(keyName, value);
        for(int vram_a=0; vram_a<4; vram_a++){
            info[ENGINE_B][vram_a].extendedPalette = result;
        }
    }

    for(int BG =0; BG<4; BG++){
        //RegPrivate::InsertRow(" ", " ");
        AnsiString name = BG;
        name.Insert("",2);
        name.Insert("BG",0);
        RegPrivate::InsertRow(name, " ");

        {
            memcpy(&reg, &rawData[0x1008 + 2*BG], 1);

            char priorityMask = 0x03;
            keyName = "D揇";
            result = (int)( reg & priorityMask);
            value = result;
            RegPrivate::InsertRow(keyName, value);

            char charaBaseMask = 0x0f;
            keyName = "LN^x[XubN";
            result = (int)( (reg>>2) & charaBaseMask);
            value = result;
            RegPrivate::InsertRow(keyName, value);
            info[ENGINE_B][BG].charaBaseBlock = result;

            char colorModeMask = 0x01;
            keyName = "J[[h";
            if( (reg>>7) & colorModeMask ){
                value = "256F[h";
                info[ENGINE_B][BG].charaDataSize = 64;
            }
            else {
                value = "16F[h";
                info[ENGINE_B][BG].charaDataSize = 32;
            }
            RegPrivate::InsertRow(keyName, value);
        }

        {
            memcpy(&reg, &rawData[0x1009 + 2*BG], 1);

            char screenBaseMask = 0x1f;
            keyName = "XN[x[XubN";
            result = (int)( reg & screenBaseMask);
            value = result;
            RegPrivate::InsertRow(keyName, value);
            info[ENGINE_B][BG].screenBaseBlock = result;

            char mask = 0x1;
            char slot = (reg>>5) & mask;
            RegPrivate::SetSlotNum(slot, BG, info[ENGINE_B][BG]);

            char screenSizeMask = 0x03;
            keyName = "XN[TCY";
            char sizeType = (reg>>6) & screenSizeMask;
            value = RegPrivate::SetScreenSize(sizeType, info[ENGINE_B][BG], info[ENGINE_B][BG].type, BG);
            RegPrivate::InsertRow     (keyName, value);
        }
    }
}


void Register::GetOBJ_Info(    const char *rawData, OBJ_Info   info[ENGINES]){
    char reg;           //WX^f[^PoCg
	{
        reg = rawData[0];
        info[ENGINE_A].mappingMode = (reg>>4) & 1;
    }
	{
        reg = rawData[2];
        info[ENGINE_A].vramCapacity = (reg>>4) & 3;
    }
    {
        reg = rawData[3];
        info[ENGINE_A].extendedPalette = (reg>>7) & 1;
    }
	{
        reg = rawData[1000];
        info[ENGINE_B].mappingMode = (reg>>4) & 1;
    }
	{
        reg = rawData[1002];
        info[ENGINE_B].vramCapacity = (reg>>4) & 3;
    }
    {
        reg = rawData[1003];
        info[ENGINE_B].extendedPalette = (reg>>7) & 1;
    }
}


AnsiString RegPrivate::SetScreenSize(int screenSize, BG_Info &info, BGType type, int bgNum){
    info.screenWidth    = SCREEN_WIDTH[bgNum][screenSize][type];
    info.screenHeight   = SCREEN_HEIGHT[bgNum][screenSize][type];

    AnsiString width    = info.screenWidth;
    AnsiString height   = info.screenHeight;
    AnsiString widthAndHeight = "*";
    widthAndHeight.Insert(height, 2);
    widthAndHeight.Insert(width, 0);
    return widthAndHeight;
}


void RegPrivate::SetMaxCharaAndBGType(int BGMode, BG_Info info[4]){
    for(int bgNum = 0; bgNum < 4; bgNum++){
        info[bgNum].type            = BG_TYPE[BGMode][bgNum];
        info[bgNum].maxCharacters   = MAX_CHARACTERS[info[bgNum].type];
    }
}


void RegPrivate::SetSlotNum(int cnt, int bgNum, BG_Info& info){
    info.slotNum = SLOT_NUM[bgNum][cnt];
}


void RegPrivate::InsertRow(const AnsiString &key, const AnsiString &value){
    if(rowIndex < 1){
        return;
    }
    Form1->StringGrid1->Cells[0][rowIndex] = key;
    Form1->StringGrid1->Cells[1][rowIndex] = value;
    rowIndex++;
    
}
