#ifndef structsH
#define structsH

#include "enums.h"

#include <Graphics.hpp>
#define TBITMAP Graphics::TBitmap

#pragma pack(push, 1)

struct VRAM_Info{
	bool			enable;
	RAW_DATA_TYPE	dataType;
	int				offset;
};

struct BG_Info{
    int     screenWidth;        //fBXvC
    int     screenHeight;       //fBXvCc
    int     charaDataSize;      //PXN[̃LN^f[^̃oCg
    int     maxCharacters;      //LN^̍ő吔
    int     charaBaseBlock;
    int     charaBaseOffset;
    int     screenBaseBlock;
    int     screenBaseOffset;
    bool    extendedPalette;
    int     slotNum;
    BGType  type;
    bool    enable;
    ENGINE  engine;
};

struct OBJ_Info{
    int		vramCapacity;
    int		mappingMode;
	bool    extendedPalette;
};

struct OAM_Info{
    int             width;
    int             height;
    OAMColorMode    colorMode;
    OBJType         objMode;
    int             colorPaletteNum;
    int             characterName;
    bool			vFlip;
    bool			hFlip;
    ENGINE          engine;
    int             priority;
};

struct Texture_Info {
    int     format;
    int     size;
    int     offset;
};


#pragma pack(pop)

#endif
