// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------
#include <iostream>
#include <fstream>
#pragma hdrstop

#include "usefulFunctions.h"
#include "Unit1.h"
#include "Graphics.hpp"
//---------------------------------------------------------------------------

const char colorConverter = 3;    //16bitJ[ۂɎgp
const char RED_SHIFT    = 10;
const char GREEN_SHIFT  = 5;
const char BLUE_SHIFT   = 0;


void    UsefulFunctions::ReadBMPFileWithVFlip(TBITMAP *bmp){
	const int height		= bmp->Height;
	const int heightHalf	= bmp->Height/2;
	const int widthSize		= bmp->Width*3*sizeof(unsigned char);
	bmp->PixelFormat		= pf24bit;
	unsigned char *tmp		= new unsigned char[widthSize];

	for(int y=0; y<heightHalf; y++){
			unsigned char *upper	= (unsigned char*)bmp->ScanLine[y];
			unsigned char *lower	= (unsigned char*)bmp->ScanLine[height-y];

			memcpy(tmp,		upper,	widthSize);
			memcpy(upper,	lower,	widthSize);
			memcpy(lower,	tmp,	widthSize);
	}
	
	delete[] tmp;
}


void    UsefulFunctions::ReadBMPFileWithScale(TBITMAP *bmp, int scale){
	if(scale <= 1){
		return;
	}
    int limitX          = bmp->Width  - 1;
    int limitY          = bmp->Height - 1;

    bmp->Width	*= scale;
	bmp->Height *= scale;
    bmp->PixelFormat    = pf24bit;
    const int pixelSize = 3*sizeof(unsigned char);
    const int lineSize  = bmp->Width*3*sizeof(unsigned char);

    unsigned char *src;
    unsigned char *dst;
    //ꃉC̏
    for(int y=limitY; y>=0; y--){
        src = (unsigned char*)bmp->ScanLine[y];
        int dstY = y*scale;
        for(int j=0; j<scale; j++){
            dst = (unsigned char*)bmp->ScanLine[dstY+j];
            //ŏ̈ڂXɃRs[
            if(j==0){
                for(int x=limitX; x>=0; x--){
                    int dstX = x*scale;
                    for(int i=0; i<scale; i++){
                        memcpy(&dst[(dstX+i)*pixelSize], &src[x*pixelSize], pixelSize);
                    }
                }
                //Qڂ͈xg債ICRs[邽߂̏
                src = (unsigned char*)bmp->ScanLine[dstY];
            }
            //Qڂ͈xg債ICRs[
            else{
                memcpy(dst, src, lineSize);
            }
        }
    }
}


void  UsefulFunctions::ChangeBit16to24(unsigned short colorData, unsigned char dst[]){    //16bitJ[24bitJ[ɕϊ
	//RGBɕ
    dst[0]	= (unsigned char)( (colorData >> RED_SHIFT	) << colorConverter );
    dst[1]	= (unsigned char)( (colorData >> GREEN_SHIFT) << colorConverter );
    dst[2]	= (unsigned char)( (colorData >> BLUE_SHIFT	) << colorConverter );
}


void	UsefulFunctions::FlipHorizontal(	unsigned char bitmap[], int width, int height){
    unsigned char tmp[3];
    int left;
    int right;
    const int widthHalf = width/2;
    for(int y=0; y<height; y++){
        for(int x=0; x<widthHalf; x++){
            left    = ( x + y * width ) * 3;
            right   = ( (width-x-1) + y*width ) * 3;
            memcpy(tmp,				&bitmap[right],	3);
			memcpy(&bitmap[right],  &bitmap[left],	3);
			memcpy(&bitmap[left],	tmp,			3);
        }
    }
}


void	UsefulFunctions::FlipVertical(	unsigned char bitmap[], int width, int height){
    unsigned char *tmp = new unsigned char[width * 3];
    const int heightHalf = height/2;
	for(int y=0; y<heightHalf; y++){
        int upper = ( y * width ) * 3;
        int lower = ( (height-y-1) * width ) * 3;
        memcpy(tmp,		&bitmap[upper],	width*3);
        memcpy(&bitmap[upper],	&bitmap[lower],	width*3);
        memcpy(&bitmap[lower],	tmp,		width*3);
    }
    delete[] tmp;
}


void	UsefulFunctions::FlipScreenHorizontal(unsigned char screen[screenLength*screenLength*3]){
	FlipHorizontal(screen, screenLength, screenLength);
}


void	UsefulFunctions::FlipScreenVertical(unsigned char screen[screenLength*screenLength*3]){
	FlipVertical(screen, screenLength, screenLength);
}


void	UsefulFunctions::InitProgressBar(){
	Form1->ProgressBar1->Max = 0;
    for(int i=0; i<RDT_OAM_B; i++){
        Form1->ProgressBar1->Max += DATA_SIZE[i];
    }
    Form1->ProgressBar1->Min        = 0;
    Form1->ProgressBar1->Position   = 0;
    Form1->ProgressBar1->Smooth     = 1;
}


void	UsefulFunctions::ConvertScreenDataToBMPForText(
            unsigned short	screenData,
			const char		*charaDataAll,
			int				charaDataSize,
			const Palette	*palette,
			unsigned char	screenBMP[screenLength*screenLength*3]){
	//XN[f[^LN^l[ƃtbvƃpbgԍɕ
	unsigned short charaName        = screenData         & 0x03ff;
    unsigned short horizontalFlip   = (screenData >> 10) & 0x0001;
    unsigned short verticalFlip	    = (screenData >> 11) & 0x0001;
	unsigned short colorPalette	    = (screenData >> 12) & 0x000f;

    //charaNamegăLN^[f[^ʒuɈړf[^ǂ
    unsigned char *charaData = new unsigned char[charaDataSize];
	char dotMask = 0x0f;
    memcpy(charaData, &charaDataAll[charaName * charaDataSize], charaDataSize);

    //L̃hbgFɕϊ

    //PhbgSrbgȂ̂ŁAQhbgiPoCgj܂
    if(charaDataSize == 32){
        int screenBMPIndex = 0;
        for(int i=0; i<charaDataSize; i++){
		    //PsNZ
		    char paletteOffset =  charaData[i] & dotMask;
		    palette->GetColor16by16(colorPalette, paletteOffset, &screenBMP[screenBMPIndex*3]);
		    screenBMPIndex++;

		    //QsNZ
		    paletteOffset = (charaData[i] >> 4) & dotMask;
		    palette->GetColor16by16(colorPalette, paletteOffset, &screenBMP[screenBMPIndex*3]);
		    screenBMPIndex++;
        }
    }
    //PhbgWrbgȂ̂ŁAPhbg܂
    else if(charaDataSize == 64){
        if(palette->GetPaletteType() == EXTENDED){
            for(int i=0; i<charaDataSize; i++){
                palette->GetColor256by16(colorPalette, charaData[i], &screenBMP[i*3]);
            }
        }
        else {
            for(int i=0; i<charaDataSize; i++){
                palette->GetColor256by1(charaData[i], &screenBMP[i*3]);
            }
        }
	}
    //ُn
    else {
        ShowMessage("Error:UsefulFunctions::ConvertScreenDataToBMP");
    }

    delete[] charaData;

    //Kv΃tbv
    if(horizontalFlip){ FlipScreenHorizontal(screenBMP);    }
    if(verticalFlip){   FlipScreenVertical(screenBMP);      }
}


void    UsefulFunctions::ConvertScreenDataToBMPForAffine(
                                                unsigned char   screenData,
                                                const char		*charaDataAll,
			                                    int				charaDataSize,
			                                    const Palette	*palette,
                                                unsigned char   screenBMP[ screenLength * screenLength * 3]
                                               )
{
    //screenDatâ܂܃LN^ԍȂ̂ŁÂ܂܎găLN^[f[^ʒuɈړf[^ǂ
	unsigned char *charaData = new unsigned char[charaDataSize];
    memcpy(charaData, &charaDataAll[screenData * charaDataSize], charaDataSize);

    //PhbgWrbgȂ̂ŁAPhbgFɕϊ܂
    for(int i=0; i<charaDataSize; i++){
        palette->GetColor256by1(charaData[i], &screenBMP[i*3]);
    }

    delete[] charaData;
}


void	UsefulFunctions::MapBMP(
				unsigned char	*in,
				int				inWidth,
				int				inHeight,
				unsigned char	*out,
				int				outWidth,
				int				outHeight,
				int				dstX,
				int				dstY
			  ){
	const int offset		= (dstX + dstY * outWidth) * 3;
    const int inLineSize	= inWidth * 3;
    const int outLineSize	= outWidth * 3;	
	for(int y=0; y<inHeight; y++){
        memcpy(&out[y * outLineSize + offset], &in[ y * inLineSize ], inLineSize);//PCƂɃ}bsO
    }
}


int		UsefulFunctions::GetOffset(	int baseOffset,	int baseOffsetSize,
					                int baseBlock, 	int baseBlockSize){
	return baseOffsetSize * baseOffset + baseBlockSize * baseBlock;
}


void    UsefulFunctions::DrawBox(TBITMAP *bitmap, int x, int y, int scale){
    TColor color = clRed;
    int width   = 8 * scale;
    int height  = 8 * scale;
    for(int i=0; i<width; i++){
        bitmap->Canvas->Pixels[x+i][y] = color;
        bitmap->Canvas->Pixels[x+i][y+height-1] = color;
    }
    for(int j=0; j<height; j++){
        bitmap->Canvas->Pixels[x][y+j] = color;
        bitmap->Canvas->Pixels[x+width-1][y+j] = color;
    }
}



static double base = 0;
void    UsefulFunctions::SetBaseTime(){
    base = GetTickCount();
    std::ofstream ofs("output.txt", std::ios_base::trunc);
    if( ofs.fail() ){
		ShowMessage("Cannot open BMPFile.");
		return;
	}
}


void    UsefulFunctions::PrintTime(const char *in1){
    double time = GetTickCount();
    std::ofstream ofs("output.txt", std::ios_base::app);
    if( ofs.fail() ){
		ShowMessage("Cannot open BMPFile.");
		return;
	}

    double diff = time - base;
    ofs << diff << " (msec)  ";

    if(in1 != NULL){
        ofs << in1;
    }
    ofs << std::endl;
}
