// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO
//---------------------------------------------------------------------------

#ifndef usefulFunctionsH
#define usefulFunctionsH

#include <system.hpp>

#include "structs.h"
#include "palette.h"
#include "constants.h"
#include "enums.h"
//---------------------------------------------------------------------------

namespace UsefulFunctions{
    void    ReadBMPFileWithVFlip(TBITMAP *bmp);
	void    ReadBMPFileWithScale(TBITMAP *bmp, int scale);
    void	ChangeBit16to24(unsigned short, unsigned char dst[]);    //16bitJ[24bitJ[ɕϊ
	void	FlipHorizontal(	unsigned char bitmap[], int width, int height);
	void	FlipVertical(	unsigned char bitmap[], int width, int height);
	void	FlipScreenHorizontal(	unsigned char screen[screenLength*screenLength*3]);
	void	FlipScreenVertical(		unsigned char screen[screenLength*screenLength*3]);
	void	InitProgressBar();
	void	ConvertScreenDataToBMPForText(
                                	unsigned short	screenData,
									const char		*charaData,
									int				charaDataSize,
									const Palette	*palette,
									unsigned char	screenBMP[ screenLength * screenLength * 3]
								  );
    void	ConvertScreenDataToBMPForAffine(
                                	unsigned char	screenData,
									const char		*charaData,
									int				charaDataSize,
									const Palette	*palette,
									unsigned char	screenBMP[ screenLength * screenLength * 3]
								  );
	void	MapBMP(	unsigned char	*in,
					int				inWidth,
					int				inHeight,
					unsigned char	*out,
					int				outWidth,
					int				outHeight,
					int				dstX,
					int				dstY
				  );
	int		GetOffset(	int baseOffset,		int baseOffsetSize,
						int blockOffset, 	int blockOffsetSize);

    void    DrawBox(TBITMAP *bitmap, int x, int y, int scale);

    void    SetBaseTime();
    void    PrintTime(const char *);
};

#endif
 