#ifndef	ENSATA_INTERFACE_H
#define	ENSATA_INTERFACE_H

#include "plugin_base.h"

#define	PLUGIN_VER		(1)

namespace Ensata {

// VRAM֘AB
enum {
	VRAM_A = 0,
	VRAM_B,
	VRAM_C,
	VRAM_D,
	VRAM_E,
	VRAM_F,
	VRAM_G,
	VRAM_H,
	VRAM_I,
	VRAM_NUM
};

enum {
	VRAM_A_SIZE = 128 * 1024,
	VRAM_B_SIZE = 128 * 1024,
	VRAM_C_SIZE = 128 * 1024,
	VRAM_D_SIZE = 128 * 1024,
	VRAM_E_SIZE = 64 * 1024,
	VRAM_F_SIZE = 16 * 1024,
	VRAM_G_SIZE = 16 * 1024,
	VRAM_H_SIZE = 32 * 1024,
	VRAM_I_SIZE = 16 * 1024
};

struct VramData {
	unsigned char		a[VRAM_A_SIZE];
	unsigned char		b[VRAM_B_SIZE];
	unsigned char		c[VRAM_C_SIZE];
	unsigned char		d[VRAM_D_SIZE];
	unsigned char		e[VRAM_E_SIZE];
	unsigned char		f[VRAM_F_SIZE];
	unsigned char		g[VRAM_G_SIZE];
	unsigned char		h[VRAM_H_SIZE];
	unsigned char		i[VRAM_I_SIZE];
};

// COMM֘AB
enum {
	COMM_ERR_EXIST_SAME_NAME = -1
};

// R[obN֐^`B
typedef void (__cdecl *BREAK_CALLBACK)(void *);
typedef void (__cdecl *COMM_RESET_CALLBACK)(void *);
typedef void (__cdecl *COMM_RECV_CALLBACK)(void *, const unsigned long *, unsigned long);

struct CommCallback {
	COMM_RESET_CALLBACK		reset;
	COMM_RECV_CALLBACK		recv;
};

}

#ifndef USE_FROM_ENSATA

//----------------------------------------------------------
// ensataւ̃C^tF[XNXB
// ensataւ̊֐QpbP[Ŵ́B
//----------------------------------------------------------
class CEnsataIF {
public:
	// vOCC^tF[Xw肵܂B
	static void SetPlugin(IPluginBase *plugin);
	// [_\JnB߂lFALSEȂ烂[_\֎~B
	static BOOL BeginModal();
	// [_\IB
	static void EndModal();
	// [hB
	static void ReadMemory(unsigned long addr, unsigned long size, void *data);
	// VRAM[hBkindVRAM_A/B/...wB
	static void ReadVram(unsigned long kind, unsigned long offset, unsigned long size, void *data);
	// SVRAM[hB
	static void ReadVramAll(Ensata::VramData *data);
	// ensata~ʒmR[obNݒB
	static void SetBreakCallback(Ensata::BREAK_CALLBACK func, void *arg);
	// f[^M@\B
	static void CommInit(const char *id_str, const Ensata::CommCallback *func,
		void *arg, long *id);
	// f[^M@\f[^MB
	static void CommSend(long id, const unsigned long *data, unsigned long size);
	// s~B
	static void Stop();
};

#endif

#endif
