#include <vcl.h>
#pragma hdrstop
#include "main.h"
#include "plugin_base.h"
#include "ensata_interface.h"
#include "common.h"
#include "Unit1.h"
#include "Unit2.h"
#include "Unit3.h"
#include "Unit4.h"

//----------------------------------------------------------
// CNXB
//----------------------------------------------------------
class CMain : public IPluginBase {
private:
	AnsiString		m_PluginName;

public:
	// IPluginBaseB
	virtual void Attach(HWND top_wnd, const char *path_name);
	virtual void Detach();
	virtual void Name(unsigned long lang, char *name, unsigned long size);
	virtual void Execute();
};

static CMain	mn;

//----------------------------------------------------------
// B
//----------------------------------------------------------
void init()
{
	CEnsataIF::SetPlugin(&mn);
}

//----------------------------------------------------------
// A^b`B
//----------------------------------------------------------
void CMain::Attach(HWND top_wnd, const char *path_name)
{
	m_PluginName = ExtractFileName(path_name);
	TForm1::m_TempParent = top_wnd;
	Form1 = new TForm1(NULL);
	TForm2::m_TempParent = top_wnd;
	Form2 = new TForm2(NULL);
	TForm3::m_TempParent = top_wnd;
	Form3 = new TForm3(NULL);
	TForm4::m_TempParent = top_wnd;
	Form4 = new TForm4(NULL);
	CreateDir(path_name);
	Form1->Init(path_name, m_PluginName);
}

//----------------------------------------------------------
// f^b`B
//----------------------------------------------------------
void CMain::Detach()
{
	Form1->Finish();
	delete Form1;
	delete Form2;
	delete Form3;
	delete Form4;
}

//----------------------------------------------------------
// vOCB
//----------------------------------------------------------
void CMain::Name(unsigned long lang, char *name, unsigned long size)
{
	if (0 < size) {
		strncpy(name, m_PluginName.c_str(), size);
		name[size - 1] = '\0';
	}
}

//----------------------------------------------------------
// vOCsB
//----------------------------------------------------------
void CMain::Execute()
{
	Form1->Show();
}
