#include <vcl.h>
#pragma hdrstop

#include "common.h"
#include "transport.h"
#include "ensata_interface.h"
#include "constants.h"
#include "VRAMViewerMain.h"

void Transport::OnOpen(VRAMViewerMain *vram_main)
{
	enum {
		NEED_DATA_SIZE = RDT_OAM_B + 1
	};
	static const u32 read_addr[] = {
		0x4000000,
		0x5000000,
		0x5000200,
		0x5000400,
		0x5000600,
		0,
		0x7000000,
		0x7000400
	};
	u8		*data;

	for (u32 i = 0; i <= NEED_DATA_SIZE; i++) {
		u32		addr = read_addr[i];

		if (addr != 0) {
			data = new u8[DATA_SIZE[i]];
			CEnsataIF::ReadMemory(addr, DATA_SIZE[i], data);
			vram_main->LoadData((RAW_DATA_TYPE)i, data);
			delete[] data;
		}
	}
	// ŌVRAM(LCDC)f[^ođMB
	// ōĕ`̃gKB
	data = new u8[DATA_SIZE[RDT_LCDC]];
	CEnsataIF::ReadVramAll((Ensata::VramData *)data);
	vram_main->LoadData(RDT_LCDC, data);
	delete[] data;
}

BOOL Transport::OnBeginModal()
{
	return CEnsataIF::BeginModal();
}

void Transport::OnEndModal()
{
	CEnsataIF::EndModal();
}
