////////////////////////////////////////////////////////////////////////////////////////////////////
/// IS-NITRO-EMULATOR DLL Interface
/// Copyright (c)2003-2004 INTELLIGENT SYSTEMS Co.,Ltd.
/// 

#ifndef __NITRODLL_H__
#define	__NITRODLL_H__

#include "ISNITRODLL.h"

#ifdef _MFC_VER
#define	LOADLIBRARY	AfxLoadLibrary
#define	FREELIBRARY	AfxFreeLibrary
#else
#define	LOADLIBRARY	LoadLibrary
#define	FREELIBRARY	FreeLibrary
#endif

/////////////////////////////////////////////////////////////
/// CNITRODLL
///

class CNITRODLL {

protected:
	HINSTANCE 						m_hDLL;
	NITRODEVICEHANDLE				m_hNITRO;

	// public function
	NITROTOOLAPI_FINDOPEN			m_lpfnFindOpen;
	NITROTOOLAPI_FINDNEXT			m_lpfnFindNext;
	NITROTOOLAPI_FINDCLOSE			m_lpfnFindClose;
	NITROTOOLAPI_DEVSELECTOR		m_lpfnSelector;
	NITROTOOLAPI_OPEN				m_lpfnOpen;
	NITROTOOLAPI_CHECKCONNECT		m_lpfnChkConn;
	NITROTOOLAPI_CLOSE				m_lpfnClose;
	NITROTOOLAPI_WRITEROM			m_lpfnWrite;
	NITROTOOLAPI_READROM			m_lpfnRead;
	NITROTOOLAPI_RESET				m_lpfnReset;
	NITROTOOLAPI_SYNCWRITE			m_lpfnSyncWrite;
	NITROTOOLAPI_SYNCREAD			m_lpfnSyncRead;
	NITROTOOLAPI_STREAMWRITE		m_lpfnStreamWrite;
	NITROTOOLAPI_STREAMGETWRITABLELEN m_lpfnStreamWriteLen;
	NITROTOOLAPI_STREAMSETCB		m_lpfnStreamSetCallback;
	NITROTOOLAPI_STREAMCHKRECV		m_lpfnStreamChkRecv;
	NITROTOOLAPI_SETSYNCTIMEOUT		m_lpfnSetSyncTimeOut;
	NITROTOOLAPI_GETDEBUGPRINT		m_lpfnGetDebugPrint;
	NITROTOOLAPI_ROMSIZE			m_lpfnGetROMSize;
	NITROTOOLAPI_CHECKPOWER			m_lpfnCheckPower;
	NITROTOOLAPI_CARDSLOTPOWER		m_lpfnCardSlot;
	NITROTOOLAPI_CARTRIDGESLOTPOWER	m_lpfnCartridgeSlot;
	NITROTOOLAPI_GETLASTERROR		m_lpfnGetLastError;
	NITROTOOLAPI_GETERRORMESSAGE	m_lpfnGetLastErrorMesg;

public:
	typedef enum { 
		ISNITRODLL_ERR_SUCCESS, 
		ISNITRODLL_ERR_CANNOT_FOUND_DLL, 
		ISNITRODLL_ERR_CANNOT_OPEN,
	} ISNITRODLL_ERR;

public:
	BOOL	IsDLLLoaded(void) const											{ return m_hDLL ? TRUE : FALSE; }
	NITROFINDHANDLE	FindOpen()												{ return (m_lpfnFindOpen) ? (*m_lpfnFindOpen)() : FALSE;							}
	BOOL	FindNext(NITROFINDHANDLE hFind, NITRODEVICEID* pnDeviceValue)	{ return (m_lpfnFindNext) ? (*m_lpfnFindNext)(hFind, pnDeviceValue) : FALSE;		}
	void	FindClose(NITROFINDHANDLE hFind)								{ if( m_lpfnFindClose) (*m_lpfnFindClose)( hFind ) ;	}
	BOOL	DeviceSelector( NITROTOOLAPI_ENUMDEV_CALLBACKFUNC funcCB, DWORD dwUser, HWND hWndParent, NITRODEVICEID *pDeviceID )
																			{ return m_lpfnSelector ? 
																				(*m_lpfnSelector)( funcCB, dwUser, hWndParent, pDeviceID ) : FALSE; }
	BOOL	IsDevSelSupported() const 										{ return m_lpfnSelector ? TRUE : FALSE; }

protected:
	NITRODEVICEHANDLE	_Open(NITRODEVICEID nDevice)						{ return (m_lpfnOpen) ? (*m_lpfnOpen)(nDevice) : NULL;								}

public:
	BOOL	CheckConnect()													{ return (m_lpfnChkConn) ? (*m_lpfnChkConn)(m_hNITRO) : FALSE; }
	VOID	Close()															{ if (m_lpfnClose) (*m_lpfnClose)(m_hNITRO); m_hNITRO = NULL;							}
	UINT	Write(const void* pBuf, ULONG adrs, ULONG len)					{ return (m_lpfnWrite) ? (*m_lpfnWrite)(m_hNITRO, pBuf, adrs, len) : 0;				}
	UINT	Read(void* pBuf, ULONG adrs, ULONG len)							{ return (m_lpfnRead) ? (*m_lpfnRead)(m_hNITRO, pBuf, adrs, len) : 0;				}
	BOOL	Reset(BOOL bOnOff)												{ return (m_lpfnReset) ? (*m_lpfnReset)(m_hNITRO, bOnOff) : FALSE;					}
	UINT	SyncWrite(const void* pBuf, ULONG adrs, ULONG len)				{ return (m_lpfnSyncWrite) ? (*m_lpfnSyncWrite)(m_hNITRO, pBuf, adrs, len) : FALSE;	}
	UINT	SyncRead(void* pBuf, ULONG adrs, ULONG len)						{ return (m_lpfnSyncRead) ? (*m_lpfnSyncRead)(m_hNITRO, pBuf, adrs, len) : FALSE;	}
	BOOL	StreamWrite( USHORT nChn, const void* pBuf, ULONG nLen)			{ return (m_lpfnStreamWrite) ? (*m_lpfnStreamWrite)(m_hNITRO, nChn, pBuf, nLen) : FALSE; }
	INT		StreamGetWritableLength( ULONG *pLength )						{ return (m_lpfnStreamWriteLen) ? (*m_lpfnStreamWriteLen)(m_hNITRO, pLength) : -1;	}
	BOOL	StreamSetReceiveStreamCallBackFunction( NITROSTREAMCALLBACKFUNC cbFunc, DWORD dwUserValue )
																			{ return (m_lpfnStreamSetCallback) ? 
																				(*m_lpfnStreamSetCallback)( m_hNITRO, cbFunc, dwUserValue ) : FALSE; }
	BOOL	StreamCheckReceive()											{ return (m_lpfnStreamChkRecv) ? (*m_lpfnStreamChkRecv)( m_hNITRO ) : FALSE;			}
	UINT	SetSyncTimeOut(UINT nTimeoutMillSecond)							{ return (m_lpfnSetSyncTimeOut) ? 
																				(*m_lpfnSetSyncTimeOut)(m_hNITRO, nTimeoutMillSecond ) : FALSE; }
	BOOL	GetDebugPrint( NITROArch nArch, void *pBuf, INT *pnResult, INT nBufSize ) 
																			{ return (m_lpfnGetDebugPrint) ? 
																				(*m_lpfnGetDebugPrint)(m_hNITRO, nArch, pBuf, pnResult, nBufSize ) : FALSE; }
	BOOL	GetROMSize( ULONG *pnSize )										{ *pnSize  = 0;  return (m_lpfnGetROMSize) ? (*m_lpfnGetROMSize)( m_hNITRO, pnSize ) : FALSE; }
	BOOL	GetPowerStatus( DWORD *pdwPowerMask )							{ *pdwPowerMask = 0; 
																			  return (m_lpfnCheckPower) ? (*m_lpfnCheckPower)( m_hNITRO, pdwPowerMask ) : FALSE; }
	BOOL	SetCardSlotPower( BOOL bEnable)									{ return (m_lpfnCardSlot) ? (*m_lpfnCardSlot)(m_hNITRO, bEnable ) : FALSE; }
	BOOL	SetCartridgeSlotPower( BOOL bEnable)							{ return (m_lpfnCartridgeSlot) ? (*m_lpfnCartridgeSlot)(m_hNITRO, bEnable ) : FALSE; }

	DWORD	GetLastError()													{ return (m_lpfnGetLastError) ? (*m_lpfnGetLastError)(m_hNITRO) : 0; }
	DWORD	GetErrorMessage(DWORD dwError, CHAR* buf, UINT nBufSize)		{ return (m_lpfnGetLastErrorMesg) ? (*m_lpfnGetLastErrorMesg)( dwError, buf, nBufSize) : FALSE; }

public:
	CNITRODLL() :	
		m_hDLL(NULL), 
		m_hNITRO(NULL),	
		m_lpfnFindOpen(NULL), 
		m_lpfnFindNext(NULL), 
		m_lpfnFindClose(NULL),
		m_lpfnSelector(NULL),
		m_lpfnOpen(NULL), 
		m_lpfnChkConn(NULL),
		m_lpfnClose(NULL), 
		m_lpfnWrite(NULL),
		m_lpfnRead(NULL), 
		m_lpfnReset(NULL),
		m_lpfnSyncWrite(NULL), 
		m_lpfnSyncRead(NULL), 
		m_lpfnStreamWrite(NULL),
		m_lpfnStreamWriteLen(NULL),
		m_lpfnStreamSetCallback(NULL),
		m_lpfnStreamChkRecv(NULL),
		m_lpfnSetSyncTimeOut(NULL),
		m_lpfnGetDebugPrint(NULL),
		m_lpfnGetROMSize(NULL),
		m_lpfnCardSlot(NULL),
		m_lpfnCartridgeSlot(NULL),
		m_lpfnGetLastError(NULL),
		m_lpfnGetLastErrorMesg(NULL)
	{
		m_hDLL = LOADLIBRARY( NITROEMUDLL_NAME );

		//
		// ISNITRO.DLL̓o[WAbvɔexport֐Ă邱Ƃ܂B
		// [U[̃vOł͕KAgpexport֐gpo邩ǂs
		// fĕKvȊ֐Ȃꍇɂ́AG[̓[U[
		// VIS-NITRO-EMULATOR/IS-NITRO-DEBUGGER\tgEFACXg[Ă炤悤
		// x\sƂ߂܂B
		//
		// ȈISNITRO.DLLbp[NXł CNITRODLL ۂ̃vOŗpꍇɂ́A
		// G[ȂǕKvȃR[hǉČ䗘p邱Ƃ߂܂B
		///

		if (m_hDLL) {
			m_lpfnFindOpen			=	(NITROTOOLAPI_FINDOPEN)GetProcAddress(m_hDLL, NITRO_FUNC_FINDOPEN);
			m_lpfnFindNext			=	(NITROTOOLAPI_FINDNEXT)GetProcAddress(m_hDLL, NITRO_FUNC_FINDNEXT);
			m_lpfnFindClose			=	(NITROTOOLAPI_FINDCLOSE)GetProcAddress(m_hDLL, NITRO_FUNC_FINDCLOSE);
			m_lpfnSelector			=	(NITROTOOLAPI_DEVSELECTOR)GetProcAddress(m_hDLL, NITRO_FUNC_SELECTOR);
			m_lpfnOpen				=	(NITROTOOLAPI_OPEN)GetProcAddress(m_hDLL, NITRO_FUNC_OPEN);
			m_lpfnChkConn			=	(NITROTOOLAPI_CHECKCONNECT)GetProcAddress(m_hDLL, NITRO_FUNC_CHECKCONNECT);
			m_lpfnClose				=	(NITROTOOLAPI_CLOSE)GetProcAddress(m_hDLL, NITRO_FUNC_CLOSE);
			m_lpfnWrite				=	(NITROTOOLAPI_WRITEROM)GetProcAddress(m_hDLL, NITRO_FUNC_WRITEROM);
			m_lpfnRead				=	(NITROTOOLAPI_READROM)GetProcAddress(m_hDLL, NITRO_FUNC_READROM);
			m_lpfnReset				=	(NITROTOOLAPI_RESET)GetProcAddress(m_hDLL, NITRO_FUNC_RESET);
			m_lpfnCheckPower		=	(NITROTOOLAPI_CHECKPOWER)GetProcAddress(m_hDLL, NITRO_FUNC_CHECKPOWER);
			m_lpfnCardSlot			=	(NITROTOOLAPI_CARDSLOTPOWER)GetProcAddress(m_hDLL, NITRO_FUNC_CARDSLOTPOWER);
			m_lpfnCartridgeSlot		=	(NITROTOOLAPI_CARTRIDGESLOTPOWER)GetProcAddress(m_hDLL, NITRO_FUNC_CARTSLOTPOWER);
			m_lpfnGetLastError		=	(NITROTOOLAPI_GETLASTERROR)GetProcAddress(m_hDLL, NITRO_FUNC_GETLASTERROR);
			m_lpfnGetLastErrorMesg	=	(NITROTOOLAPI_GETERRORMESSAGE)GetProcAddress(m_hDLL, NITRO_FUNC_GETERRORMESSAGE);

			m_lpfnSyncWrite			=	(NITROTOOLAPI_SYNCWRITE)GetProcAddress(m_hDLL, NITRO_FUNC_SYNC_WRITEROM);
			m_lpfnSyncRead			=	(NITROTOOLAPI_SYNCREAD)GetProcAddress(m_hDLL, NITRO_FUNC_SYNC_READROM);
			m_lpfnStreamWrite		=	(NITROTOOLAPI_STREAMWRITE)GetProcAddress(m_hDLL, NITRO_FUNC_STREAM_WRITE);
			m_lpfnStreamWriteLen	=	(NITROTOOLAPI_STREAMGETWRITABLELEN)GetProcAddress(m_hDLL, NITRO_FUNC_STREAM_GETWL);
			m_lpfnStreamSetCallback =	(NITROTOOLAPI_STREAMSETCB)GetProcAddress(m_hDLL, NITRO_FUNC_STREAM_SETCB);
			m_lpfnStreamChkRecv		=	(NITROTOOLAPI_STREAMCHKRECV)GetProcAddress(m_hDLL, NITRO_FUNC_STREAM_CHECK);
			m_lpfnSetSyncTimeOut	=	(NITROTOOLAPI_SETSYNCTIMEOUT)GetProcAddress(m_hDLL, NITRO_FUNC_SET_SYNCTIMEOUT);
			m_lpfnGetDebugPrint		=	(NITROTOOLAPI_GETDEBUGPRINT)GetProcAddress(m_hDLL, NITRO_FUNC_DEBUGPRINT);
		}
	}

	virtual	~CNITRODLL()
	{
		if (m_hNITRO) Close();
		if (m_hDLL) {
			FREELIBRARY(m_hDLL);
			m_hDLL = NULL;
		}
	}

	BOOL	Open(NITRODEVICEID nDevice)
	{
		BOOL		bRet	=	FALSE;
		if (m_hNITRO) Close();
		if( m_hDLL ){
			m_hNITRO = _Open(nDevice);
			if( m_hNITRO ){
				bRet	=	TRUE;
			}
		}
		return bRet;
	}
};

#endif	// __NITRODLL_H__

