// (C) 2006 Nintendo Co.,Ltd.
// Coded by Norihito ITO

#include "SendRAMData.h"

static const u8 reg_sig		= REGISTER_SIGNAL;
static const u8 bgPalA_sig	= BG_PALETTE_A_SIGNAL;
static const u8 objPalA_sig	= OBJ_PALETTE_A_SIGNAL;
static const u8 bgPalB_sig	= BG_PALETTE_B_SIGNAL;
static const u8 objPalB_sig	= OBJ_PALETTE_B_SIGNAL;
static const u8 oamA_sig	= OAM_A_SIGNAL;
static const u8 oamB_sig	= OAM_B_SIGNAL;
static const u8 lcdc_sig	= LCDC_SIGNAL;

static const SendDataInfo sendInfo[AnalizeFlowEND] = {
	{ NULL, 			NULL		},
	{ (u8*)&reg_sig,	sizeof(u8)	},
	{ (u8*)0x04000000,	0x1100		},
	{ (u8*)&bgPalA_sig,	sizeof(u8)	},
	{ (u8*)0x05000000,	0x200		},
	{ (u8*)&objPalA_sig,sizeof(u8)	},
	{ (u8*)0x05000200,	0x200		},
	{ (u8*)&bgPalB_sig,	sizeof(u8)	},
	{ (u8*)0x05000400,	0x200		},
	{ (u8*)&objPalB_sig,sizeof(u8)	},
	{ (u8*)0x05000600,	0x200		},
	{ (u8*)&lcdc_sig,	sizeof(u8)	},
	{ (u8*)0x06800000,	0xA4000		},
	{ (u8*)&oamA_sig,	sizeof(u8)	},
	{ (u8*)0x07000000,	0x400		},
	{ (u8*)&oamB_sig,	sizeof(u8)	},
	{ (u8*)0x07000400,	0x400		}
};

static BOOL initialized = FALSE;

static GXVRamBG				SRD_bg;
static GXVRamOBJ			SRD_obj;
static GXVRamBGExtPltt		SRD_bgExtPltt;
static GXVRamOBJExtPltt		SRD_objExtPltt;
static GXVRamTex			SRD_tex;
static GXVRamTexPltt		SRD_texPltt;
static GXVRamClearImage		SRD_CI;
static GXVRamSubBG			SRD_Sbg;
static GXVRamSubOBJ			SRD_Sobj;
static GXVRamSubBGExtPltt	SRD_SbgExtPltt;
static GXVRamSubOBJExtPltt	SRD_SobjExtPltt;

void SendRAMDataToPC(){
	if(!initialized){
		MemSendInit();
		initialized = TRUE;
	}

	if(MemSendIsSending()){
		//肦ȂG[
		return;
	}

	for(AnalizeFlow i=REGISTER_SIGNAL; i<AnalizeFlowEND; i=static_cast<AnalizeFlow>(i+1)){
		//OIȏFLCDCo͂̑OVRAM̊蓖ĂLCDCɐ؂ւ܂
		
		if(i == LCDC){
			SRD_bg			= GX_GetBankForBG();
			SRD_obj			= GX_GetBankForOBJ();
			SRD_bgExtPltt	= GX_GetBankForBGExtPltt();
			SRD_objExtPltt	= GX_GetBankForOBJExtPltt();
			SRD_tex			= GX_GetBankForTex();
			SRD_texPltt		= GX_GetBankForTexPltt();
			SRD_CI			= GX_GetBankForClearImage();
			SRD_Sbg			= GX_GetBankForSubBG();
			SRD_Sobj		= GX_GetBankForSubOBJ();
			SRD_SbgExtPltt	= GX_GetBankForSubBGExtPltt();
			SRD_SobjExtPltt	= GX_GetBankForSubOBJExtPltt();

			(void)GX_ResetBankForTex();
			(void)GX_ResetBankForTexPltt();
			(void)GX_ResetBankForClearImage();
			(void)GX_ResetBankForBG();
			(void)GX_ResetBankForOBJ();
			(void)GX_ResetBankForBGExtPltt();
			(void)GX_ResetBankForOBJExtPltt();
			(void)GX_ResetBankForSubBG();
			(void)GX_ResetBankForSubOBJ();
			(void)GX_ResetBankForSubBGExtPltt();
			(void)GX_ResetBankForSubOBJExtPltt();
		}
		MemSendData(sendInfo[i].address, sendInfo[i].size);
		while( MemSendIsSending() ){
			MemSendLoop();
			OS_WaitVBlankIntr();           // Waiting the end of VBlank interrupt
		}
		if(i == LCDC){
			GX_SetBankForBG(			SRD_bg);
			GX_SetBankForOBJ(			SRD_obj);
			GX_SetBankForBGExtPltt(		SRD_bgExtPltt);
			GX_SetBankForOBJExtPltt(	SRD_objExtPltt);
			GX_SetBankForTex(			SRD_tex);
			GX_SetBankForTexPltt(		SRD_texPltt);
			GX_SetBankForClearImage(	SRD_CI);
			GX_SetBankForSubBG(			SRD_Sbg);
			GX_SetBankForSubOBJ(		SRD_Sobj);
			GX_SetBankForSubBGExtPltt(	SRD_SbgExtPltt);
			GX_SetBankForSubOBJExtPltt(	SRD_SobjExtPltt);
		}
	}
}