#include <vcl.h>
#include <dir.h>
#include <io.h>
#pragma hdrstop

#include "FrmMain.h"
#include "FrmProperty.h"
#include "FrmAddDir.h"
#include "token.h"
#include "symbol.h"

#pragma package(smart_init)
#pragma link "cdiroutl"
#pragma resource "*.dfm"
TFormMain *FormMain;

#define	VTAGS_VER		"# vtags file ver 1.0"

// public
__fastcall TFormMain::TFormMain(TComponent* Owner)
    : TForm(Owner)
{
	m_OpenVTagsFilePath = ExtractFileDir(Application->ExeName);
	m_AddFilePath = m_OpenVTagsFilePath;
	token_init();
	sym_init();

	m_Update = false;
	m_pMenuItemNewClick(this);
}

// __published
void __fastcall TFormMain::FormCloseQuery(TObject *Sender, bool &CanClose)
{
	if (m_Update) {
		int		res;

		res = MessageDlg(ExtractFileName(m_VTagsFileName) + "͕ύXĂ܂Bۑ܂H",
				mtWarning, mbYesNoCancel, 0);
		if (res == mrCancel) {
			CanClose = false;
		} else if (res == mrYes) {
			m_pMenuItemSaveClick(this);
		}
	}
}

// __published
void __fastcall TFormMain::FormClose(TObject *Sender, TCloseAction &Action)
{
	sym_clear();
	sym_finish();
	token_finish();
}

// __published
void __fastcall TFormMain::m_pMenuItemNewClick(TObject *Sender)
{
	if (m_Update) {
		int		res;

		res = MessageDlg(ExtractFileName(m_VTagsFileName) + "͕ύXĂ܂Bۑ܂H",
				mtWarning, mbYesNoCancel, 0);
		if (res == mrYes) {
			m_pMenuItemSaveClick(this);
		}
	}
	m_VTagsFileName = "";
	m_pListView->Clear();
	sym_clear();
	m_DoneSym = true;
	m_Update = false;
	SetTitle();
}

// __published
void __fastcall TFormMain::m_pMenuItemOpenClick(TObject *Sender)
{
	if (m_Update) {
		int		res;

		res = MessageDlg(ExtractFileName(m_VTagsFileName) + "͕ύXĂ܂Bۑ܂H",
				mtWarning, mbYesNoCancel, 0);
		if (res == mrYes) {
			m_pMenuItemSaveClick(this);
		}
	}
	m_pOpenDialog->Options >> ofAllowMultiSelect;
	m_pOpenDialog->InitialDir = m_OpenVTagsFilePath;
	m_pOpenDialog->FileName = "";
	m_pOpenDialog->Filter = "*.tag|*.TAG";
	if (m_pOpenDialog->Execute()) {
		m_VTagsFileName = m_pOpenDialog->FileName;
		m_OpenVTagsFilePath = ExtractFileDir(m_VTagsFileName);
		m_pListView->Clear();
		sym_clear();
		m_Update = false;
		OpenVTagsFile();
		SetTitle();
	}
}

// __published
void __fastcall TFormMain::m_pMenuItemSaveClick(TObject *Sender)
{
	if (m_VTagsFileName == "") {
		m_pMenuItemSaveAsClick(this);
	} else {
		if (!m_DoneSym) {
			int		res;

			res = MessageDlg("oĂ܂B܂H",
					mtWarning, mbYesNoCancel, 0);
			if (res == mrYes) {
				m_pMenuItemSymbolClick(this);
			}
		}
		SaveVTagsFile();
		m_Update = false;
		SetTitle();
	}
}

// __published
void __fastcall TFormMain::m_pMenuItemSaveAsClick(TObject *Sender)
{
	m_pSaveDialog->FileName = m_VTagsFileName;
	if (m_pSaveDialog->Execute()) {
		m_VTagsFileName = m_pSaveDialog->FileName;
		SetTitle();
		m_OpenVTagsFilePath = ExtractFileDir(m_VTagsFileName);
		m_pMenuItemSaveClick(this);
	}
}

// __published
void __fastcall TFormMain::m_pMenuItemSymbolClick(TObject *Sender)
{
	AnsiString		path;

	sym_clear();
	for (int i = 0; i < m_pListView->Items->Count; i++) {
		path = m_pListView->Items->Item[i]->Caption;
		extract_symbol(path, m_pListView->Items->Item[i]->SubItems->Strings[0]);
	}
	sym_sort_cut();
	m_DoneSym = true;
}

// __published
void __fastcall TFormMain::m_pMenuItemAddFileClick(TObject *Sender)
{
	m_pOpenDialog->Options << ofAllowMultiSelect;
	m_pOpenDialog->InitialDir = m_AddFilePath;
	m_pOpenDialog->FileName = "";
	m_pOpenDialog->Filter = "*.*|*.*";
	if (m_pOpenDialog->Execute()) {
		TStringList		*ext_pat = new TStringList();
		AnsiString		type = IndexToType(FormProperty->m_pRadioGroup->ItemIndex);

		ext_pat->CommaText = FormProperty->m_pEditFilter->Text;
		for (int i = 0; i < m_pOpenDialog->Files->Count; i++) {
			AnsiString		path = m_pOpenDialog->Files->Strings[i];

			AddFile(path, type, ext_pat);
		}
		delete ext_pat;
		m_AddFilePath = ExtractFileDir(m_pOpenDialog->FileName);
		m_DoneSym = false;
		m_Update = true;
		SetTitle();
	}
}

// __published
void __fastcall TFormMain::m_pMenuItemDelClick(TObject *Sender)
{
	m_pListView->DeleteSelected();
	m_Update = true;
	SetTitle();
}

// __published
void __fastcall TFormMain::m_pMenuItemPropertyClick(TObject *Sender)
{
	FormProperty->ShowModal();
}

// private
void TFormMain::SetTitle()
{
	AnsiString		updt;

	updt = m_Update ? "*" : "";
	if (m_VTagsFileName != "") {
		Caption = ExtractFileName(m_VTagsFileName) + updt + " - vtags";
	} else {
		Caption = "vtags" + updt + " - vtags";
	}
}

// private
void TFormMain::OpenVTagsFile()
{
	TStringList		*vtags = new TStringList();
	AnsiString		path;

	vtags->LoadFromFile(m_VTagsFileName);
	if (vtags->Strings[0] != VTAGS_VER) {
		ShowMessage("^Ot@Cł͂܂");
		delete vtags;
		return;
	}
	SetCurrentDir(m_OpenVTagsFilePath);

	for (int i = 1; i < vtags->Count; i++) {
		path = vtags->Strings[i];

		if (5 <= path.Length() && CompareStr(path.SubString(1, 3), "## ") == 0) {
			TListItem		*item;

			item = m_pListView->Items->Add();
			item->Caption = ExpandFileName(path.SubString(6, path.Length() - 5));
			item->SubItems->Append(path.SubString(4, 1));
		}
	}
	m_DoneSym = false;
	delete vtags;
}

// private
void TFormMain::SaveVTagsFile()
{
	TStringList		*vtags = new TStringList();

	vtags->Append(VTAGS_VER);
	vtags->Append("");
	for (int i = 0; i < m_pListView->Items->Count; i++) {
		vtags->Append("## " + m_pListView->Items->Item[i]->SubItems->Strings[0] + " " +
				ExtractRelativePath(m_OpenVTagsFilePath + "\\", m_pListView->Items->Item[i]->Caption));
	}
	vtags->Append("");
	sym_save(vtags, m_OpenVTagsFilePath + "\\");
	vtags->SaveToFile(m_VTagsFileName);
	delete vtags;
}

// private
void TFormMain::AddFile(AnsiString fn, AnsiString type, TStringList *ext_pat)
{
	TListItem		*item;
	AnsiString		ext;

	ext = ExtractFileExt(fn);
	if (FormProperty->m_pCheckBoxFilter->Checked) {
		int		i;

		if (ext.IsEmpty()) {
			return;
		}
		for (i = 0; i < ext_pat->Count; i++) {
			if (ext == ("." + ext_pat->Strings[i])) {
				break;
			}
		}
		if (i == ext_pat->Count) {
			return;
		}
	}

	item = m_pListView->FindCaption(0, fn, false, true, false);
	if (!item) {
		item = m_pListView->Items->Add();

		item->Caption = fn;
	}
	item->SubItems->Clear();
	item->SubItems->Append(type);
}

// private
AnsiString TFormMain::IndexToType(int id)
{
	AnsiString		type;

	switch (id) {
	case 1:
		type = "S";
		break;
	case 2:
		type = "X";
		break;
	default:
		type = "C";
	}

	return type;
}

//----------------------------------------------------------
// tH_o^B
//----------------------------------------------------------
void __fastcall TFormMain::MIAddDirClick(TObject *Sender)
{
	TAddDirForm		*add_dir;

	add_dir = new TAddDirForm(this);
	if (add_dir->ShowModal() == mrOk) {
		TStringList		*ext_pat = new TStringList();
		AnsiString		type = IndexToType(FormProperty->m_pRadioGroup->ItemIndex);

		ext_pat->CommaText = FormProperty->m_pEditFilter->Text;
		AddDirRec(add_dir->DLBDir->Directory.c_str(), type, ext_pat);
		delete ext_pat;
		m_DoneSym = false;
		m_Update = true;
		SetTitle();
	}
}

//----------------------------------------------------------
// tH_o^̍ċAB
//----------------------------------------------------------
void TFormMain::AddDirRec(AnsiString dir, AnsiString type, TStringList *ext_pat)
{
	struct _finddata_t	f_data;
	long				find_id;

	find_id = _findfirst((char *)(dir + "\\*.*").c_str(), &f_data);
	if (find_id != -1) {
		long	res;

		do {
			if (f_data.attrib & _A_SUBDIR) {
				AnsiString	sub = f_data.name;

				if (sub != "." && sub != "..") {
					AddDirRec(dir + "\\" + sub, type, ext_pat);
				}
			} else {
				AddFile(dir + "\\" + f_data.name, type, ext_pat);
			}
			res = _findnext(find_id, &f_data);
		} while (res == 0);
	}
	_findclose(find_id);
}

//----------------------------------------------------------
// \B
//----------------------------------------------------------
void __fastcall TFormMain::FormShow(TObject *Sender)
{
	::PostMessage(Handle, WM_EXECUTE_SCRIPT, 0, 0);
}

//----------------------------------------------------------
// XNvgsB
//----------------------------------------------------------
void __fastcall TFormMain::DoExecuteScript(Messages::TMessage& Message)
{
	TStringList					*script_file;
	TStringList					*script_line;
	int							line_num;
	static const StScriptTable	table[] = {
		{ "add_dir", &TFormMain::ScriptAddDir },
		{ "save_to", &TFormMain::ScriptSaveTo },
		{ "save", &TFormMain::ScriptSave },
		{ "symbol", &TFormMain::ScriptSymbol },
		{ "", NULL }
	};

	if (m_ScriptFile == "") {
		return;
	}

	script_file = new TStringList();
	script_line = new TStringList();
	try {
		script_file->LoadFromFile(m_ScriptFile);
	} catch (...) {
		ShowMessage(AnsiString("XNvgt@CJ܂F") + m_ScriptFile);
		delete script_file;
		delete script_line;
		return;
	}
	script_line->Delimiter = '\t';

	line_num = script_file->Count;
	for (int i = 0; i < line_num; i++) {
		AnsiString	line_buf = script_file->Strings[i];
		AnsiString	cmd;
		BOOL		found;

		if (line_buf[1] == '#') {
			continue;
		}
		script_line->DelimitedText = line_buf;
		if (script_line->Count == 0) {
			continue;
		}
		cmd = script_line->Strings[0];
		found = FALSE;
		for (int j = 0; table[j].func; j++) {
			if (cmd == table[j].name) {
				if (!(this->*table[j].func)(script_line)) {
					delete script_file;
					delete script_line;
					return;
				}
				found = TRUE;
				break;
			}
		}
		if (!found) {
			ShowMessage(AnsiString("XNvgR}hُłF") + line_buf);
			delete script_file;
			delete script_line;
			return;
		}
	}
	delete script_file;
	delete script_line;
	::PostMessage(Handle, WM_CLOSE, 0, 0);
}

//----------------------------------------------------------
// XNvg|tH_ǉB
//----------------------------------------------------------
BOOL TFormMain::ScriptAddDir(TStringList *arg)
{
	TStringList		*ext_pat;

	if (arg->Count != 4) {
		ShowMessage(AnsiString("XNvgp[^ُłF") + arg->Strings[0]);
		return FALSE;
	}

	FormProperty->m_pCheckBoxFilter->Checked = true;
	ext_pat = new TStringList();
	ext_pat->CommaText = arg->Strings[3];
	AddDirRec(ExpandFileName(arg->Strings[1]), arg->Strings[2], ext_pat);
	delete ext_pat;
	return TRUE;
}

//----------------------------------------------------------
// XNvg|t@CwۑB
//----------------------------------------------------------
BOOL TFormMain::ScriptSaveTo(TStringList *arg)
{
	if (arg->Count != 2) {
		ShowMessage(AnsiString("XNvgp[^ُłF") + arg->Strings[0]);
		return FALSE;
	}

	m_VTagsFileName = arg->Strings[1];
	m_OpenVTagsFilePath = ExtractFileDir(ExpandFileName(m_VTagsFileName));
	SaveVTagsFile();
	return TRUE;
}

//----------------------------------------------------------
// XNvg|ۑB
//----------------------------------------------------------
BOOL TFormMain::ScriptSave(TStringList *arg)
{
	if (arg->Count != 1) {
		ShowMessage(AnsiString("XNvgp[^ُłF") + arg->Strings[0]);
		return FALSE;
	}

	SaveVTagsFile();
	return TRUE;
}

//----------------------------------------------------------
// XNvg|V{oB
//----------------------------------------------------------
BOOL TFormMain::ScriptSymbol(TStringList *arg)
{
	if (arg->Count != 1) {
		ShowMessage(AnsiString("XNvgp[^ُłF") + arg->Strings[0]);
		return FALSE;
	}

	m_pMenuItemSymbolClick(this);
	return TRUE;
}

//----------------------------------------------------------
// XNvgt@CwB
//----------------------------------------------------------
void TFormMain::SetScriptFile(AnsiString script)
{
	m_ScriptFile = script;
}
