#ifndef FrmMainH
#define FrmMainH

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <ImgList.hpp>
#include <Dialogs.hpp>
#include "cdiroutl.h"
#include <Grids.hpp>
#include <Outline.hpp>
#include <ActnCtrls.hpp>
#include <ActnMan.hpp>
#include "analyze.h"

#define	WM_EXECUTE_SCRIPT		(WM_USER + 0)

class TFormMain : public TForm {
__published:	// IDE Ǘ̃R|[lg
    TMainMenu *m_pMainMenu;
    TMenuItem *m_pMenuItemFile;
    TMenuItem *m_pMenuItemNew;
    TMenuItem *m_pMenuItemOpen;
    TMenuItem *m_pMenuItemSave;
    TMenuItem *m_pMenuItemSaveAs;
    TMenuItem *m_pMenuItemSep1;
    TMenuItem *m_pMenuItemSymbol;
    TMenuItem *m_pMenuItemEdit;
    TMenuItem *m_pMenuItemAddFile;
    TMenuItem *m_pMenuItemSetting;
    TMenuItem *m_pMenuItemProperty;
    TMenuItem *m_pMenuItemDel;
    TToolBar *m_pToolBar;
    TToolButton *m_pToolButtonNew;
    TListView *m_pListView;
    TStatusBar *m_pStatusBar;
    TToolButton *m_pToolButtonOpen;
    TToolButton *m_pToolButtonSave;
    TToolButton *m_pToolButtonSep1;
    TToolButton *m_pToolButtonSymbol;
    TToolButton *m_pToolButtonSep2;
    TToolButton *m_pToolButtonAddFile;
    TToolButton *m_pToolButtonDel;
    TToolButton *m_pToolButtonSep3;
    TToolButton *m_pToolButtonProperty;
    TImageList *m_pImageList;
    TOpenDialog *m_pOpenDialog;
    TSaveDialog *m_pSaveDialog;
	TToolButton *TBAddDir;
	TMenuItem *MIAddDir;
    void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall m_pMenuItemNewClick(TObject *Sender);
    void __fastcall m_pMenuItemOpenClick(TObject *Sender);
    void __fastcall m_pMenuItemSaveClick(TObject *Sender);
    void __fastcall m_pMenuItemSaveAsClick(TObject *Sender);
    void __fastcall m_pMenuItemSymbolClick(TObject *Sender);
    void __fastcall m_pMenuItemAddFileClick(TObject *Sender);
    void __fastcall m_pMenuItemDelClick(TObject *Sender);
    void __fastcall m_pMenuItemPropertyClick(TObject *Sender);
	void __fastcall MIAddDirClick(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);

private:	// [U[錾
	typedef BOOL (TFormMain::*ScriptFunc)(TStringList *arg);
	struct StScriptTable {
		const char		*name;
		ScriptFunc		func;
	};

    bool				m_Update;
    bool				m_DoneSym;
	AnsiString			m_VTagsFileName;
	AnsiString			m_OpenVTagsFilePath;
	AnsiString			m_AddFilePath;
	AnsiString			m_ScriptFile;

	void SetTitle();
	void OpenVTagsFile();
	void SaveVTagsFile();
	void AddFile(AnsiString fn, AnsiString type, TStringList *ext_pat);
	AnsiString IndexToType(int id);
	void AddDirRec(AnsiString dir, AnsiString type, TStringList *ext_pat);
	BOOL ScriptAddDir(TStringList *arg);
	BOOL ScriptSaveTo(TStringList *arg);
	BOOL ScriptSave(TStringList *arg);
	BOOL ScriptSymbol(TStringList *arg);

public:		// [U[錾
	__fastcall TFormMain(TComponent* Owner);
	void SetScriptFile(AnsiString script);
	void __fastcall DoExecuteScript(Messages::TMessage& Message);

BEGIN_MESSAGE_MAP
	VCL_MESSAGE_HANDLER(WM_EXECUTE_SCRIPT, TMessage, DoExecuteScript)
END_MESSAGE_MAP(TForm)
};

extern PACKAGE TFormMain *FormMain;

#endif
