#pragma hdrstop

#include "analyze.h"
#include "token.h"
#include "symbol.h"

typedef bool (*CHECK_FUNC)(void);
typedef void (*OTHER_FUNC)(void);

typedef struct {
	int					num;
	const CHECK_FUNC	*check_func;
	OTHER_FUNC			other_func;
} ST_ANALYSIS_PAT;

static bool check_prepro(void);
static bool check_class(void);
static bool check_enum(void);
static bool check_typedef(void);
static void check_other_c(void);

static const CHECK_FUNC		c_check_func[] = {
	check_prepro,
	check_class,
	check_enum,
	check_typedef
};

static const ST_ANALYSIS_PAT		c_analysis_pat = {
	sizeof(c_check_func) / sizeof(*c_check_func),
	c_check_func,
	check_other_c
};

static bool check_macro(void);
static bool check_label(void);
static void check_other_label(void);

static const CHECK_FUNC		s_check_func[] = {
	check_prepro,
	check_macro,
	check_label
};

static const ST_ANALYSIS_PAT		s_analysis_pat = {
	sizeof(s_check_func) / sizeof(*s_check_func),
	s_check_func,
	check_other_label
};

static void check_message_id(void);

static const ST_ANALYSIS_PAT		x_analysis_pat = {
	0,
	NULL,
	check_message_id
};

static AnsiString	st_path;
static int			st_line_cnt;

static ST_TOKEN *get_next_token_c_skip_semi(void);
static ST_TOKEN *open_par2_or_semicolon(ST_TOKEN *t);
static void check_enum_item(void);
static void sub_check_class(void);
static void sub_check_enum(void);
static void sub_check_def_sym(void);
static int comma_or_semicolon(void);
static void search_token_c(int token);
static bool is_classy_ident(ST_TOKEN *t);
static bool is_user_label(ST_TOKEN *t);
static bool sym_check(ST_TOKEN *t, const char *str);
static bool sym_check_i(ST_TOKEN *t, const char *str);
static void skip_scope(ST_TOKEN *t);
static void skip_scope_easy(ST_TOKEN *t);
static void skip_par(ST_TOKEN *t);
static void skip_par3(ST_TOKEN *t);
static ST_TOKEN *get_next_token_c(void);
static void skip_next_new_line_c(void);
static void skip_next_new_line(void);
static bool comment_path(ST_TOKEN *t);
static void search_token(int token);
static void add_symbol(ST_TOKEN *t);

/*
 * CvOŜɌ邱ƂǁA#if ` #endiflĂ܂B
 * Ȃ̂ŁA͂ɉeyڂƂŎgꂽꍇ͋B
 */

void extract_symbol(AnsiString path, AnsiString type)
{
	const ST_ANALYSIS_PAT	*pt;

	if (type == "S") {
		pt = &s_analysis_pat;
	} else if (type == "X") {
		pt = &x_analysis_pat;
	} else {
		pt = &c_analysis_pat;
	}

	st_path = path;
	token_start(path);
	do {
		int		i;

		for (i = 0; i < pt->num; i++) {
			if (pt->check_func[i]()) {
				break;
			}
			token_set_pos_to_start();
		}
		if (i == pt->num) {
			pt->other_func();
		}
		token_restart();
	} while (!token_is_end());
	token_end();
}

static bool check_prepro(void)
{
	ST_TOKEN	*t = get_next_token_c_skip_semi();

	if (t->token != TOKEN_SHARP) {
		return false;
	}
	t = get_next_token_c();
	if (t->token == TOKEN_IDENT && sym_check(t, "define")) {
		t = get_next_token_c();
		if (t->token == TOKEN_IDENT) {
			add_symbol(t);
		}
	}
	// #݂̂kƂď̂ǁAӂ`gȂB
	// igƁA̍sǔ΂Ⴂ܂j
	skip_next_new_line_c();

	return true;
}

static bool check_class(void)
{
	ST_TOKEN	*t = get_next_token_c_skip_semi();
	ST_TOKEN	sym;

	if (t->token != TOKEN_IDENT || !is_classy_ident(t)) {
		return false;
	}

	t = get_next_token_c();
	if (t->token == TOKEN_IDENT) {
		sym = *t;
		t = get_next_token_c();
		t = open_par2_or_semicolon(t);
		if (t->token == TOKEN_OPEN_PAR2) {		// `B
			add_symbol(&sym);
			skip_scope(t);
			sub_check_def_sym();
		} else {
			return false;
		}
	}

	return true;
}

static bool check_enum(void)
{
	ST_TOKEN	*t = get_next_token_c_skip_semi();
	ST_TOKEN	sym;

	if (t->token != TOKEN_IDENT || !sym_check(t, "enum")) {
		return false;
	}
	t = get_next_token_c();
	if (t->token == TOKEN_IDENT) {
		sym = *t;
		t = get_next_token_c();
	}
	if (t->token == TOKEN_OPEN_PAR2) {
		if (sym.token == TOKEN_IDENT) {
			add_symbol(&sym);
		}
		check_enum_item();
		sub_check_def_sym();
	} else {
		return false;
	}

	return true;
}

static bool check_typedef(void)
{
	ST_TOKEN	*t = get_next_token_c_skip_semi();

	if (t->token != TOKEN_IDENT || !sym_check(t, "typedef")) {
		return false;
	}
	t = get_next_token_c();
	if (t->token == TOKEN_IDENT) {
		if (is_classy_ident(t)) {
			sub_check_class();
		} else if (sym_check(t, "enum")) {
			sub_check_enum();
		} else {
			sub_check_def_sym();
		}
	}
	return true;
}

static void check_other_c(void)
{
	ST_TOKEN	*t = get_next_token_c_skip_semi();
	ST_TOKEN	sym;
	int			bookmark;

	if (t->token == TOKEN_IDENT && sym_check(t, "extern")) {
		t = get_next_token();
		if (t->token == TOKEN_DQUART) {
			t = get_next_token();
			if (sym_check(t, "C")) {
				t = get_next_token();
				if (t->token == TOKEN_DQUART) {
					// "C"̑OɉmȂB܂Aextern "C" { ͑
					// wb_Œ`đŜ̂ŁA}͖̕B
					skip_next_new_line_c();
					return;
				}
			}
		}
		if (t->token != TOKEN_SEMICOLON) {
			search_token_c(TOKEN_SEMICOLON);
		}
		return;
	}
	bookmark = bookmark_token();
	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_COMMA || t->token == TOKEN_EQUAL || t->token == TOKEN_SEMICOLON) {
			// ϐ`B
			go_bookmark_token(bookmark);
			sub_check_def_sym();
			return;
		} else if (t->token == TOKEN_OPEN_PAR) {
			skip_par(t);
			t = get_next_token_c();
			if (t->token == TOKEN_OPEN_PAR) {
				// ϐ`B
				go_bookmark_token(bookmark);
				sub_check_def_sym();
			} else if (sym.token == TOKEN_IDENT) {
				// ֐錾or`B
				t = open_par2_or_semicolon(t);
				if (t->token == TOKEN_OPEN_PAR2) {		// 錾łȂB
					add_symbol(&sym);
					skip_scope_easy(t);
				}
			}
			return;
		} else if (t->token == TOKEN_IDENT) {
			if (sym_check(t, "__attribute__")) {
				search_token_c(TOKEN_OPEN_PAR);
				t = get_next_token_c();
				skip_par(t);
			} else {
				sym = *t;
			}
		}
	}
}

static bool check_macro(void)
{
	ST_TOKEN	*t = get_next_token_c();

	if (t->token != TOKEN_DOT) {
		return false;
	}
	t = get_next_token_c();
	if (t->token != TOKEN_IDENT || !sym_check_i(t, "macro")) {
		return false;
	}

	t = get_next_token_c();
	if (t->token == TOKEN_IDENT) {
		add_symbol(t);
		for (;!(t->token == TOKEN_EOF || (t->token == TOKEN_IDENT && sym_check_i(t, "endm")));
			t = get_next_token_c())
		{
			search_token_c(TOKEN_DOT);
		}
	}
	skip_next_new_line_c();

	return true;
}

static bool check_label(void)
{
	ST_TOKEN	*t = get_next_token_c();

	if (t->token != TOKEN_IDENT || !is_user_label(t)) {
		return false;
	}

	t = get_next_token_c();
	if (t->token == TOKEN_IDENT) {
		add_symbol(t);
	}
	skip_next_new_line_c();

	return true;
}

static void check_other_label(void)
{
	ST_TOKEN	*t = get_next_token_c();
	ST_TOKEN	sym;

	if (t->token == TOKEN_IDENT) {
		sym = *t;
		t = get_next_token_c();
		if (t->token == TOKEN_COLON) {
			add_symbol(&sym);
		}
	}
	token_set_pos_to_start();
	skip_next_new_line_c();
}

static void check_message_id(void)
{
	ST_TOKEN	*t;

	get_next_token();
	t = get_next_token();
	if (t->token == TOKEN_IDENT && sym_check(t, "row")) {
		t = get_next_token();
		if (t->token == TOKEN_IDENT && sym_check(t, "id")) {
			t = get_next_token();
			if (t->token == TOKEN_EQUAL) {
				t = get_next_token();
				if (t->token == TOKEN_DQUART) {
					t = get_next_token();
					if (t->token == TOKEN_IDENT) {
						add_symbol(t);
					}
				}
			}
		}
	}
	token_set_pos_to_start();
	skip_next_new_line();
}

static ST_TOKEN *get_next_token_c_skip_semi(void)
{
	ST_TOKEN	*t;

	t = get_next_token_c();
	for (; t->token == TOKEN_SEMICOLON; t = get_next_token_c()) {
		;
	}

	return t;
}

static ST_TOKEN *open_par2_or_semicolon(ST_TOKEN *t)
{
	while (t->token != TOKEN_EOF) {
		if (t->token == TOKEN_OPEN_PAR2 || t->token == TOKEN_SEMICOLON) {
			break;
		}
		t = get_next_token_c();
	}

	return t;
}

static void check_enum_item(void)
{
	ST_TOKEN	*t = get_next_token_c();
	ST_TOKEN	sym;

	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_COMMA) {
			if (sym.token == TOKEN_IDENT) {
				add_symbol(&sym);
				sym.token = TOKEN_OTHER;
			}
		} else if (t->token == TOKEN_CLOSE_PAR2) {
			if (sym.token == TOKEN_IDENT) {
				add_symbol(&sym);
			}
			break;
		} else if (t->token == TOKEN_IDENT && sym.token != TOKEN_IDENT) {
			sym = *t;
		}
	}
}

static void sub_check_class(void)
{
	ST_TOKEN	*t = get_next_token_c();
	ST_TOKEN	sym;
	int			bookmark;

	if (t->token == TOKEN_OPEN_PAR2) {
		skip_scope(t);
		sub_check_def_sym();
	} else if (t->token == TOKEN_IDENT) {
		sym = *t;
		bookmark = bookmark_token();
		t = get_next_token_c();
		t = open_par2_or_semicolon(t);
		if (t->token == TOKEN_SEMICOLON) {		// NXtypedef`ɗpꂽB
			go_bookmark_token(bookmark);
			sub_check_def_sym();
		} else {
			// t->token == TOKEN_OPEN_PAR2B
			add_symbol(&sym);
			skip_scope(t);
			sub_check_def_sym();
		}
	}
}

static void sub_check_enum(void)
{
	ST_TOKEN	*t = get_next_token_c();
	ST_TOKEN	sym;
	int			bookmark;

	bookmark = bookmark_token();
	if (t->token == TOKEN_IDENT) {
		sym = *t;
		t = get_next_token_c();
	}
	if (t->token == TOKEN_OPEN_PAR2) {
		if (sym.token == TOKEN_IDENT) {
			add_symbol(&sym);
		}
		check_enum_item();
	} else {
		go_bookmark_token(bookmark);
	}
	sub_check_def_sym();
}

static void sub_check_def_sym(void)
{
	ST_TOKEN	*t = get_next_token_c();
	ST_TOKEN	sym;

	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_OPEN_PAR) {
			// ֐^̏ꍇB
			t = get_next_token_c();
			for (sym.token = TOKEN_OTHER; t->token != TOKEN_EOF; t = get_next_token_c()) {
				if (t->token == TOKEN_CLOSE_PAR) {
					if (sym.token == TOKEN_IDENT) {
						add_symbol(&sym);
						sym.token = TOKEN_OTHER;
					}
					t = get_next_token_c();
					skip_par(t);
					if (comma_or_semicolon() == TOKEN_SEMICOLON) {
						return;
					}
					break;
				} else if (t->token == TOKEN_OPEN_PAR3) {
					skip_par3(t);
				} else if (t->token == TOKEN_IDENT) {
					sym = *t;
				}
			}
		} else if (t->token == TOKEN_COMMA || t->token == TOKEN_EQUAL || t->token == TOKEN_SEMICOLON) {
			// ϐ^̏ꍇB
			if (sym.token == TOKEN_IDENT) {
				add_symbol(&sym);
				sym.token = TOKEN_OTHER;
			}
			if (t->token == TOKEN_SEMICOLON) {
				return;
			} else if (t->token == TOKEN_EQUAL) {
				if (comma_or_semicolon() == TOKEN_SEMICOLON) {
					return;
				}
			}
		} else if (t->token == TOKEN_OPEN_PAR3) {
			skip_par3(t);
		} else if (t->token == TOKEN_IDENT) {
			if (sym_check(t, "__attribute__")) {
				search_token_c(TOKEN_OPEN_PAR);
				t = get_next_token_c();
				skip_par(t);
			} else {
				sym = *t;
			}
		}
	}
}

static int comma_or_semicolon(void)
{
	ST_TOKEN	*t = get_next_token_c();

	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_SEMICOLON || t->token == TOKEN_COMMA) {
			break;
		} else if (t->token == TOKEN_OPEN_PAR2) {
			skip_scope(t);
		}
	}

	return t->token;
}

static void search_token_c(int token)
{
	ST_TOKEN	*t;

	t = get_next_token_c();
	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == token) {
			return;
		}
	}
}

static bool is_classy_ident(ST_TOKEN *t)
{
	return sym_check(t, "class") || sym_check(t, "struct") || sym_check(t, "union");
}

static bool is_user_label(ST_TOKEN *t)
{
	return sym_check(t, "DEF_EX_LABEL") || sym_check(t, "_EXTRA_LABEL") || sym_check(t, "_EXTRA_DATA_START_LABEL") ||
		sym_check(t, "_EXTRA_DATA_END_LABEL") || sym_check(t, "EV_CALL_LABEL") || sym_check(t, "DEF_CMD_LABEL") ||
		sym_check(t, "EVENT_DATA_START") || sym_check(t, "SCRIPT_LABEL") || sym_check(t, "_SHOP_MENU_START") ||
		sym_check(t, "_INIT_RELATIVE_ADRS") || sym_check(t, "EV_WORK_LABEL") || sym_check(t, "SCRIPT_TBL_LABEL") ||
		sym_check(t, "DEF_WORK") || sym_check(t, "DEF_CALL") || sym_check(t, "DEF_SCRIPT_TBL") || sym_check(t, "DEF_EX_CMD") ||
		sym_check(t, "DEF_CMD") || sym_check(t, "DEF_SEQ");
}

static bool sym_check(ST_TOKEN *t, const char *str)
{
	int		len;

	len = strlen(str);
	if (len != t->len) {
		return false;
	}
	return strncmp(t->start_p, str, len) == 0;
}

static bool sym_check_i(ST_TOKEN *t, const char *str)
{
	int		len;

	len = strlen(str);
	if (len != t->len) {
		return false;
	}
	return strncmpi(t->start_p, str, len) == 0;
}

static void skip_scope(ST_TOKEN *t)
{
	int		level = 0;

	st_line_cnt = 0;
	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_CLOSE_PAR2 && --level == 0) {	// oX "}" 𔭌B
			break;
		} else if (t->token == TOKEN_OPEN_PAR2) {
			level++;
		} else if (100000 < st_line_cnt) {
			// sꍇ́A"}"łȂƌďIB
			ShowMessage("}Ȃ̂ŁA߂܂");
			break;
		}
	}
}

static void skip_scope_easy(ST_TOKEN *t)
{
	// XR[v΂ȗŁB
	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_CLOSE_PAR2 &&
			!t->skip_space && token_prev(t)->token == TOKEN_NEW_LINE)
		{
			// s"}"ȂIƂ݂ȂB
			break;
		}
	}
}

static void skip_par(ST_TOKEN *t)
{
	int		level = 0;

	st_line_cnt = 0;
	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_CLOSE_PAR && --level == 0) {	// oX ")" 𔭌B
			break;
		} else if (t->token == TOKEN_OPEN_PAR) {
			level++;
		} else if (1024 < st_line_cnt) {
			// sꍇ́A")"łȂƌďIB
			ShowMessage(")Ȃ̂ŁA߂܂");
			break;
		}
	}
}

static void skip_par3(ST_TOKEN *t)
{
	int		level = 0;

	st_line_cnt = 0;
	for (; t->token != TOKEN_EOF; t = get_next_token_c()) {
		if (t->token == TOKEN_CLOSE_PAR3 && --level == 0) {	// oX "]" 𔭌B
			break;
		} else if (t->token == TOKEN_OPEN_PAR3) {
			level++;
		} else if (1024 < st_line_cnt) {
			// sꍇ́A"]"łȂƌďIB
			ShowMessage("]Ȃ̂ŁA߂܂");
			break;
		}
	}
}

static ST_TOKEN *get_next_token_c(void)
{
	ST_TOKEN		*t;
	int				token;

	t = get_next_token();
	for (; t->token != TOKEN_EOF; t = get_next_token()) {
		token = t->token;
		if (!comment_path(t)) {
			if (token != TOKEN_NEW_LINE) {
				break;
			} else {
				st_line_cnt++;
			}
		} else if (token == TOKEN_DBL_SLASH) {
			st_line_cnt++;
		}
	}

	return t;
}

static void skip_next_new_line_c(void)
{
	ST_TOKEN	*t;
	int			token;

	t = get_next_token();
	for (; t->token != TOKEN_EOF; t = get_next_token()) {
		token = t->token;
		if (comment_path(t) ? token == TOKEN_DBL_SLASH :
			token == TOKEN_NEW_LINE)
		{
			break;
		}
	}
}

static void skip_next_new_line(void)
{
	ST_TOKEN	*t;

	t = get_next_token();
	for (; t->token != TOKEN_EOF; t = get_next_token()) {
		if (t->token == TOKEN_NEW_LINE) {
			break;
		}
	}
}

static bool comment_path(ST_TOKEN *t)
{
	int		ret = false;

	if (t->token == TOKEN_DBL_SLASH) {
		search_token(TOKEN_NEW_LINE);
		ret = true;
	} else if (t->token == TOKEN_OPEN_COMMENT) {
		search_token(TOKEN_CLOSE_COMMENT);
		ret = true;
	} else if (t->token == TOKEN_DQUART) {
		search_token(TOKEN_DQUART);
		ret = true;
	}

	return ret;
}

static void search_token(int token)
{
	ST_TOKEN	*t;

	t = get_next_token();
	for (; t->token != TOKEN_EOF; t = get_next_token()) {
		if (t->token == token) {
			return;
		}
	}
}

static void add_symbol(ST_TOKEN *t)
{
	sym_add(t, st_path);
}
