#pragma hdrstop

#include "symbol.h"

#define	SYMBOL_BLOCK_SIZE		(256)
#define	BUF_BLOCK_SIZE			(256)

static TList	*st_sym_list;

static int __fastcall sym_compare(void *item1, void *item2);
static AnsiString __fastcall str_to_line(AnsiString str);

void sym_init(void)
{
	st_sym_list = new TList();
}

void sym_clear(void)
{
	for (int i = st_sym_list->Count - 1; 0 <= i; i--) {
		delete (ST_SYMBOL *)st_sym_list->Items[i];
	}
	st_sym_list->Count = 0;
}

void sym_finish(void)
{
	sym_clear();
	delete st_sym_list;
}

void sym_add(ST_TOKEN *t, AnsiString path)
{
	ST_SYMBOL	*sym;

	sym = new ST_SYMBOL();
	sym->symbol = AnsiString(t->start_p, t->len);
	sym->path = path;
	sym->line_str = t->line;
	if (st_sym_list->Count == st_sym_list->Capacity) {
		st_sym_list->Capacity = st_sym_list->Count + SYMBOL_BLOCK_SIZE;
	}
	st_sym_list->Add(sym);
}

static int __fastcall sym_compare(void *item1, void *item2)
{
	ST_SYMBOL	*it1 = (ST_SYMBOL *)item1;
	ST_SYMBOL	*it2 = (ST_SYMBOL *)item2;
	int			res;

	res = CompareStr(it1->symbol, it2->symbol);
	if (res == 0) {
		res = CompareStr(it1->path, it2->path);
		if (res == 0) {
			res = CompareStr(it1->line_str, it2->line_str);
		}
	}
	return res;
}

void sym_sort_cut(void)
{
	st_sym_list->Sort(sym_compare);
	for (int i = 0; i < st_sym_list->Count - 1; i++) {
		ST_SYMBOL	*p1 = (ST_SYMBOL *)st_sym_list->Items[i];
		ST_SYMBOL	*p2 = (ST_SYMBOL *)st_sym_list->Items[i + 1];

		if (CompareStr(p1->symbol, p2->symbol) == 0 &&
			CompareStr(p1->path, p2->path) == 0 &&
			CompareStr(p1->line_str, p2->line_str) == 0)
		{
			st_sym_list->Items[i] = NULL;
			delete p1;
		}
	}
	st_sym_list->Pack();
}

void sym_save(TStringList *vtags, AnsiString path)
{
	for (int i = 0; i < st_sym_list->Count; i++) {
		ST_SYMBOL		*p = (ST_SYMBOL *)st_sym_list->Items[i];

		vtags->Append(p->symbol + "\t" + ExtractRelativePath(path, p->path) + "\t/^" + str_to_line(p->line_str) + "$/");
	}
}

static AnsiString __fastcall str_to_line(AnsiString str)
{
	char		buf[2];
	AnsiString	dst;
	int			len;

	buf[1] = '\0';
	len = str.Length();
	for (int i = 1; i <= len; i++) {
		char	c = str[i];

		if (str.ByteType(i) == mbLeadByte) {
			buf[0] = c;
			dst += buf;
			i++;
			if (len < i) {
				break;
			}
			buf[0] = str[i];
			dst += buf;
			continue;
		} else if (c == '/') {
			buf[0] = '\\';
			dst += buf;
		} else if (c == '\\') {
			buf[0] = '\\';
			dst += buf;
		}
		buf[0] = c;
		dst += buf;
	}

	return dst;
}
