#ifndef	___TOKEN_H_
#define	___TOKEN_H_

#include <vcl>

enum {
	TOKEN_OTHER,
	TOKEN_IDENT,				// ʎqipŎn܂pj
	TOKEN_SHARP,				// #
	TOKEN_OPEN_PAR,				// (
	TOKEN_CLOSE_PAR,			// )
	TOKEN_OPEN_PAR2,			// {
	TOKEN_CLOSE_PAR2,			// }
	TOKEN_OPEN_PAR3,			// [
	TOKEN_CLOSE_PAR3,			// ]
	TOKEN_SEMICOLON,			// ;
	TOKEN_COLON,				// :
	TOKEN_COMMA,				// ,
	TOKEN_DBL_SLASH,			// //
	TOKEN_OPEN_COMMENT,			// /*
	TOKEN_CLOSE_COMMENT,		// */
	TOKEN_EQUAL,				// =
	TOKEN_DQUART,				// "
	TOKEN_DOT,					// .
	TOKEN_NEW_LINE,				// sR[h
	TOKEN_EOF					// 
};

typedef struct StToken {
	int			token;
	int			skip_space;
	AnsiString	line;
	char		*start_p;
	int			len;
	StToken() : token(TOKEN_OTHER) { }
} ST_TOKEN;

void token_init(void);
void token_start(AnsiString path);
void token_end(void);
void token_finish(void);
int bookmark_token(void);
void go_bookmark_token(int pos);
bool token_is_end(void);
ST_TOKEN *token_prev(ST_TOKEN *t);
void token_set_pos_to_start(void);
void token_restart(void);
ST_TOKEN *get_next_token(void);

#endif
