﻿use strict;
use File::Find;
use utf8;

binmode STDERR, "encoding(shiftjis)";

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my (%addmsg, $flist, $reg_start, $reg_end);

	# utf8のBOM。
	print "\x{ef}\x{bb}\x{bf}";
	binmode STDOUT, "utf8";

	$reg_start = qr/^\t<row id="([^"]*)".*>$/;
	$reg_end = qr/^\t<\/row>$/;

	# 追加メッセージ取得。
	{
		my ($state, $data, $prev_msg_id);

		open(GMM, "addmsg.gmm");
		binmode(GMM, "utf8");
		while (<GMM>) {
			if ($state == 0) {
				if (/$reg_start/) {
					$data->{head} = $_;
					$state = 1;
				}
			} elsif ($state == 1) {
				if (/$reg_end/) {
					$data->{body} .= $_;
					if (exists $addmsg{$prev_msg_id}) {
						die "${prev_msg_id}が重複。\n";
					}
					$addmsg{$prev_msg_id} = $data;
					undef($prev_msg_id);	# 念のため。
					$data = {};
					$state = 0;
				} elsif (/^\t\t<attribute name="prev_msg_id">(.*)<\/attribute>$/) {
					$prev_msg_id = $1;
				} else {
					$data->{body} .= $_;
				}
			}
		}
		close GMM;
	}

	$flist = get_file_list("src");
	for my $i (@{$flist}) {
		my ($state, $msg_id, $out);

		open(GMM, $i);
		binmode(GMM, "utf8");
		$state = 0;
		while (<GMM>) {
			if ($state == 0) {
				$out .= $_;
				if (/$reg_start/) {
					$msg_id = $1;
					if ($addmsg{$msg_id}) {
						$state = 1;
					}
				}
			} elsif ($state == 1) {
				$out .= $_;
				if (/$reg_end/) {
					while (1) {
						my ($prev_msg_id);

						$out .= $addmsg{$msg_id}{head};
						$out .= $addmsg{$msg_id}{body};
						$prev_msg_id = $msg_id;
						$addmsg{$msg_id}{head} =~ /$reg_start/;
						$msg_id = $1;
						print "$i: ${msg_id} を ${prev_msg_id} 後に挿入\n";
						if (!$addmsg{$msg_id}) {
							last;
						}
					}
					$state = 0;
				}
			}
		}
		close GMM;

		open(GMM, ">$i");
		binmode(GMM, "utf8");
		print GMM $out;
		close GMM;
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.gmm$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
