﻿#	※ このファイルは、UTF8が扱えるエディタで編集して下さい。
#

use strict;
use utf8;

#***********************************************************
# パッケージletter
#***********************************************************
package letter;

our $LETTER_JPN =
	"　ぁあぃいぅうぇえぉおかがきぎく" .	# 0x001
	"ぐけげこごさざしじすずせぜそぞた" .	# 0x011
	"だちぢっつづてでとどなにぬねのは" .	# 0x021
	"ばぱひびぴふぶぷへべぺほぼぽまみ" .	# 0x031
	"むめもゃやゅゆょよらりるれろわを" .	# 0x041
	"んァアィイゥウェエォオカガキギク" .	# 0x051
	"グケゲコゴサザシジスズセゼソゾタ" .	# 0x061
	"ダチヂッツヅテデトドナニヌネノハ" .	# 0x071
	"バパヒビピフブプヘベペホボポマミ" .	# 0x081
	"ムメモャヤュユョヨラリルレロワヲ" .	# 0x091
	"ン０１２３４５６７８９ＡＢＣＤＥ" .	# 0x0a1
	"ＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵ" .	# 0x0b1
	"ＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋ" .	# 0x0c1
	"ｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ_" .	# 0x0d1
	"！？、。…・／「」『』（）♂♀＋" .	# 0x0e1
	"ー×÷＝～：；．，♠♣♥♦★◎○" .	# 0x0f1
	"□△◇＠♪％☀☁☂☃㌀㌁㌂㌃㌄㌅" .	# 0x101
	"㌆円㌇㌈㌉㌊㌋㌌㌍㌎←↑↓→►＆" .	# 0x111
	"0123456789ABCDEF" .			# 0x121
	"GHIJKLMNOPQRSTUV" .			# 0x131
	"WXYZabcdefghijkl" .			# 0x141
	"mnopqrstuvwxyzÀÁ" .			# 0x151
	"ÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑ" .			# 0x161
	"ÒÓÔÕÖ_ØÙÚÛÜÝÞßàá" .			# 0x171
	"âãäåæçèéêëìíîïðñ" .			# 0x181
	"òóôõö_øùúûüýþÿŒœ" .			# 0x191
	"Şşªº___\$¡¿!?,._･" .			# 0x1a1
	"/‘'“”„«»()__+-*#" .			# 0x1b1
	"=&~:;㌐㌑㌒㌓㌔㌕㌖㌗㌘㌙@" .		# 0x1c1
	"㌚%㌛㌜㌝㌞㌟㌠㌡㌢㌣㌤㌥ __" .	# 0x1d1
	"________________" .			# 0x1e1
	"________________";			# 0x1f1

our $LETTER_ENG =
	"　ぁあぃいぅうぇえぉおかがきぎく" .	# 0x001
	"ぐけげこごさざしじすずせぜそぞた" .	# 0x011
	"だちぢっつづてでとどなにぬねのは" .	# 0x021
	"ばぱひびぴふぶぷへべぺほぼぽまみ" .	# 0x031
	"むめもゃやゅゆょよらりるれろわを" .	# 0x041
	"んァアィイゥウェエォオカガキギク" .	# 0x051
	"グケゲコゴサザシジスズセゼソゾタ" .	# 0x061
	"ダチヂッツヅテデトドナニヌネノハ" .	# 0x071
	"バパヒビピフブプヘベペホボポマミ" .	# 0x081
	"ムメモャヤュユョヨラリルレロワヲ" .	# 0x091
	"ン０１２３４５６７８９ＡＢＣＤＥ" .	# 0x0a1
	"ＦＧＨＩＪＫＬＭＮＯＰＱＲＳＴＵ" .	# 0x0b1
	"ＶＷＸＹＺａｂｃｄｅｆｇｈｉｊｋ" .	# 0x0c1
	"ｌｍｎｏｐｑｒｓｔｕｖｗｘｙｚ_" .	# 0x0d1
	"！？、。…・／「」『』（）♂♀＋" .	# 0x0e1
	"ー×÷＝～：；．，_____◎○" .		# 0x0f1
	"□△◇＠_％☀☁☂☃______" .		# 0x101
	"_円_____________＆" .			# 0x111
	"0123456789ABCDEF" .			# 0x121
	"GHIJKLMNOPQRSTUV" .			# 0x131
	"WXYZabcdefghijkl" .			# 0x141
	"mnopqrstuvwxyzÀÁ" .			# 0x151
	"ÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑ" .			# 0x161
	"ÒÓÔÕÖ_ØÙÚÛÜÝÞßàá" .			# 0x171
	"âãäåæçèéêëìíîïðñ" .			# 0x181
	"òóôõö_øùúûüýþÿŒœ" .			# 0x191
	"Şşªº___\$¡¿!?,.__" .			# 0x1a1
	"/_'_\"„__()__+-*#" .			# 0x1b1
	"=&~:;__________@" .			# 0x1c1
	"_%___________ __";			# 0x1d1

our %UNDERSCORE = (
	"NULL"     => "",               "SPADE"   => pack('S', 0xfa),  "CLUB"   => pack('S', 0xfb),
	"HEART"    => pack('S', 0xfc),  "DIAMOND" => pack('S', 0xfd),  "STAR"   => pack('S', 0xfe),
	"MUSIC"    => pack('S', 0x105), "NORMAL"  => pack('S', 0x10b), "SMILE"  => pack('S', 0x10c),
	"CRY"      => pack('S', 0x10d), "ANGRY"   => pack('S', 0x10e), "UPPER"  => pack('S', 0x10f),
	"DOWNER"   => pack('S', 0x110), "SLEEP"   => pack('S', 0x111), "ITEM"   => pack('S', 0x113),
	"KEYITEM"  => pack('S', 0x114), "MACHINE" => pack('S', 0x115), "SEAL"   => pack('S', 0x116),
	"MEDICINE" => pack('S', 0x117), "NUT"     => pack('S', 0x118), "BALL"   => pack('S', 0x119),
	"BATTLE"   => pack('S', 0x11a), "LEFT"    => pack('S', 0x11b), "UP"     => pack('S', 0x11c),
	"DOWN"     => pack('S', 0x11d), "RIGHT"   => pack('S', 0x11e), "CURSOR" => pack('S', 0x11f),
	"TIMES"    => pack('S', 0x176), "DIVIDES" => pack('S', 0x196), "er"     => pack('S', 0x1a5),
	"re"       => pack('S', 0x1a6), "r"       => pack('S', 0x1a7), "LEADER" => pack('S', 0x1af),
	"CDOT"     => pack('S', 0x1b0), "SQUOTE"  => pack('S', 0x1b2), "DQUOTE" => pack('S', 0x1b4),
	"MALE"     => pack('S', 0x1bb), "FEMALE"  => pack('S', 0x1bc), "e"      => pack('S', 0x1df),
	"PKMN"     => pack('S', 0x1e0) . pack('S', 0x1e1),             "SPCNUM" => pack('S', 0x1e2)
);

our %TAG = (
	"[3:00:" => "HEART_",
	"[3:01:" => "MUSIC_",
	"[3:02:" => "ITEM_",
	"[3:03:" => "KEYITEM_",
	"[3:04:" => "MACHINE_",
	"[3:05:" => "SEAL_",
	"[3:06:" => "MEDICINE_",
	"[3:07:" => "NUT_",
	"[3:08:" => "BALL_",
	"[3:09:" => "BATTLE_",
	"[3:0A:" => "LEFT_",
	"[3:0B:" => "UP_",
	"[3:0C:" => "RIGHT_",
	"[3:0D:" => "MALE_",
	"[3:0E:" => "FEMALE_",
	"[4:00:" => "er_",
	"[4:01:" => "re_",
	"[4:02:" => "r_",
	"[4:03:" => "e_",
	"[4:04:" => "LEADER_",
	"[4:05:" => "CDOT_",
	"[4:06:" => "SQUOTE_",
	"[4:07:" => "DQUOTE_",
	"[4:08:" => "PKMN_",
	"[4:09:" => "NULL_"
);

our $OSE =
	"0123456789ABCDEF" .
	"GHIJKLMNOPQRSTUV" .
	"WXYZabcdefghijkl" .
	"mnopqrstuvwxyzÀÁ" .
	"ÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑ" .
	"ÒÓÔÕÖØÙÚÛÜÝÞßàá" .
	"âãäåæçèéêëìíîïðñ" .
	"òóôõöøùúûüýþÿŒœ" .
	"Şşªº\$¡¿!?,." .
	"/'\"„()+-*#" .
	"=&~:;@% ";

our $COMM =
	"0123456789ABCDEF" .
	"GHIJKLMNOPQRSTUV" .
	"WXYZabcdefghijkl" .
	"mnopqrstuvwxyzÀÁ" .
	"ÄÇÈÉÌÍÑ" .
	"ÒÓÖÙÚÜßàá" .
	"âäçèéêëìíîïñ" .
	"òóôöùúûü" .
	"¡¿!?,." .
	"/'\"„()+-*#" .
	"=&~:;@% ";

our @POKE_EACH = ( "ABC", "DEF", "GHI", "JKL", "MNO",
	"PQR", "STU", "VWX", "YZ" );

our @SIMPLE_REG = (
	qr/^A/, qr/^B/, qr/^C/, qr/^D/, qr/^E/, qr/^F/,
	qr/^G/, qr/^H/, qr/^I/, qr/^J/, qr/^K/, qr/^L/,
	qr/^M/, qr/^N/, qr/^O/, qr/^P/, qr/^Q/, qr/^R/,
	qr/^S/, qr/^T/, qr/^U/, qr/^V/, qr/^W/, qr/^X/,
	qr/^Y/, qr/^Z/, qr//
);

our @REP_TABLE = (
	{ reg => qr/_NULL_/,	rep => "" },
	{ reg => qr/_er_/,	rep => "一" },
	{ reg => qr/_re_/,	rep => "二" },
	{ reg => qr/_r_/,	rep => "三" },
	{ reg => qr/_e_/,	rep => "四" },
	{ reg => qr/_LEADER_/,	rep => "..." },
	{ reg => qr/_CDOT_/,	rep => "・" },
	{ reg => qr/_SQUOTE_/,	rep => "‘" },
	{ reg => qr/_DQUOTE_/,	rep => "“" },
	{ reg => qr/_MALE_/,	rep => "♂" },
	{ reg => qr/_FEMALE_/,	rep => "♀" },
	{ reg => qr/_PKMN_/,	rep => "PKMN" },
	{ reg => qr/Æ/,		rep => "AE" },
	{ reg => qr/Œ/,		rep => "OE" },
);

our @PHASE1_TABLE = (
	{ trans => "一",	phase1 => "ER" },
	{ trans => "二",	phase1 => "RE" },
	{ trans => "三",	phase1 => "R" },
	{ trans => "四",	phase1 => "E" },
	{ trans => " ‘'“\"„@#\$%&()*+,-./:;=¡!¿?~・♀♂",
				phase1 => "" },
	{ trans => "ÀÁÂÃÄÅª",	phase1 => "A" },
	{ trans => "Ç",		phase1 => "C" },
	{ trans => "Ð",		phase1 => "D" },
	{ trans => "ÈÉÊË",	phase1 => "E" },
	{ trans => "ÌÍÎÏ",	phase1 => "I" },
	{ trans => "Ñ",		phase1 => "N" },
	{ trans => "ÒÓÔÕÖØº",	phase1 => "O" },
	{ trans => "ßŞ",	phase1 => "S" },
	{ trans => "ÙÚÛÜ",	phase1 => "U" },
	{ trans => "ÝÞ",	phase1 => "Y" },
);

our $PHASE2 =
	" ‘'“\"„@#\$%&()*+,-./:;=¡!¿?~・♀♂" .
	"0123456789" .
	"AaÁáÀàÂâÄäÃãÅåªBbCcÇçDdÐðEeÉéÈèÊêËë四一" .
	"FfGgHhIiÍíÌìÎîÏïJjKkLlMmNnÑñ" .
	"OoÓóÒòÔôÖöÕõØøºPpQqRr三二SsßÿŞşTt" .
	"UuÚúÙùÛûÜüVvWwXxYyÝýÞþZz" .
	"ぁあぃいぅうぇえぉおかがきぎくぐ" .
	"けげこごさざしじすずせぜそぞただ" .
	"ちぢっつづてでとどなにぬねのはば" .
	"ぱひびぴふぶぷへべぺほぼぽまみむ" .
	"めもゃやゅゆょよらりるれろわをん" .
	"ァアィイゥウェエォオカガキギクグ" .
	"ケゲコゴサザシジスズセゼソゾタダ" .
	"チヂッツヅテデトドナニヌネノハバ" .
	"パヒビピフブプヘベペホボポマミム" .
	"メモャヤュユョヨラリルレロワヲン";

our %SIMPLE_DUP = (
	"LANG_ENGLISH" => {
		"I" => [
			{ no => 1145, use => 0 },
			{ no => 1176, use => 0 },
			{ no => 1179, use => 0 },
			{ no => 1180, use => 1 }
		], "YOU" => [
			{ no => 1146, use => 1 },
			{ no => 1165, use => 0 }
		], "KIDS" => [
			{ no => 1167, use => 1 },
			{ no => 1175, use => 0 }
		], "HEY" => [
			{ no => 1216, use => 1 },
			{ no => 1264, use => 0 }
		], "HUH?" => [
			{ no => 1191, use => 0 },
			{ no => 1249, use => 1 }
		], "WELCOME" => [
			{ no => 1200, use => 0 },
			{ no => 1279, use => 1 }
		], "WOW" => [
			{ no => 1206, use => 1 },
			{ no => 1285, use => 0 }
		], "OK" => [
			{ no => 1211, use => 1 },
			{ no => 1280, use => 0 }
		]
	}, "LANG_FRANCE" => {
	}, "LANG_GERMANY" => {
	}, "LANG_ITALY" => {
	}, "LANG_SPAIN" => {
	}
);
