﻿use strict;
use XML::DOM;
use File::Find;
use utf8;

use gmm;

binmode(STDOUT, "encoding(shiftjis)");
binmode(STDERR, "encoding(shiftjis)");

main();
exit;

#-----------------------------------------------------------
# メイン処理。
#-----------------------------------------------------------
sub main {
	my $fname;

	$fname = get_file_list();
	for my $i (@{$fname}) {
		my $gmm = new gmm($i);

		print STDERR "$i\n";
		print STDOUT "===$i===\n";
		for (my $iter = $gmm->newIter(); !$iter->over(); $iter->next()) {
			my ($line, $scroll, $dst, $line_max, $scroll_type, $save, $dsp) = (0, 0, "", 0);
			my $text = $iter->getText('JPN');
			my $msg_id = $iter->getMsgId();
			my $line_num = 2;	#$iter->getLineNum();

			while ($text =~ /^([^\n▽▼]*)([\n▽▼])(.*)$/s) {
				my $left = $1;
				my $match = $2;
				my $right = $3;

				if ($match eq "\n") {
					$line++;
					$dst .= $left . "\n";
					$save .= $left . "\n";
				} elsif ($match eq "▽") {
					if ($right !~ /^\n/) {
						die "error: ▽ next no newline, $i, $msg_id\n";
					}
					if ($line + 1 != $line_num) {
						print "warning: illegal ▽, $i, $msg_id\n";
						$line++;
					}
					$right = substr($right, 1);
					$scroll = 1;
					$scroll_type = "SCROLL";
					$dst .= $left . "\n";
					$save = "";
				} elsif ($match eq "▼") {
					$dsp = 0;
					if ($right =~ /^\n/) {
						$right = substr($right, 1);
						$dst .= $left . "\n\n";
						$dsp = 1;
					} elsif ($right ne "") {
						if ($right =~ /^(.*)$/m) {
							print "a▼: $i, $msg_id, $1\n";
						}
						$dst .= $left . "\n\n";
					} else {
						$dst .= $left;
					}
					if ($line_max < $line) {
						$line_max = $line;
					}
					$line = 0;
					$scroll = 1;
					$scroll_type = "NORMAL";
					$save = "";
				}
				$text = $right;
			}
			$save .= $text;

			if ($scroll == 1) {
				if ($line_num <= $line_max) {
					print "warning: line over, $i, $msg_id\n";
				}
			}
			if ($scroll == 1 && $scroll_type eq "NORMAL" && $dsp == 1) {
				print "n▼: $i, $msg_id, $save\n";
			}
		}
	}
}

#-----------------------------------------------------------
# ファイルリスト取得。
#-----------------------------------------------------------
sub get_file_list {
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.gmm$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, 'src');
	return \@list;
}
