﻿use strict;
use File::Find;
use utf8;

binmode STDERR, "encoding(shiftjis)";

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my ($flist, %trnr, %map, %len);

	# utf8のBOM。
	binmode STDOUT, "raw";
	print "\x{ef}\x{bb}\x{bf}";
	binmode STDOUT, "utf8";

	# トレーナー名のリストを取得。
	{
		my (@term);

		if (!open(LIST, "list.txt")) {
			die "list.txtが開けません。\n";
		}
		binmode LIST, "encoding(shiftjis)";
		while (<LIST>) {
			chomp;
			@term = split /\t/;
			$trnr{$term[0]} = { jp => $term[1], us => $term[2] };
		}
		close LIST;
	}

	# エリア名のリストを取得。
	{
		my (@term);

		if (!open(MAP, "map.txt")) {
			die "map.txtが開けません。\n";
		}
		binmode MAP, "encoding(shiftjis)";
		while (<MAP>) {
			chomp;
			@term = split /\t/;
			$map{"\U$term[0]\E"} = $term[1];
		}
		close MAP;
	}

	$flist = get_file_list("E:/yamamoto/work/pokemon/ds/pm_dp_ose/src/fielddata/eventdata");
	for my $i (@{$flist}) {
		my ($fname);

		if ($i !~ /([^\\\/]+)$/) {
			die "ファイル名がおかしい。\n";
		}
		$fname = $1;

		print STDERR "===$fname===\n";

		if (!open(EV, $i)) {
			die "${i}が開けません。\n";
		}
		binmode EV, "encoding(shiftjis)";
		while (<EV>) {
			while (/(\w+)/g) {
				my ($word);

				$word = $1;
				if (exists $trnr{$word}) {
					if (exists $trnr{$word}{area}) {
						print "すでにエリア設定があります: $word,$trnr{$word}{jp},$trnr{$word}{area}\n";
					} else {
						if ($fname !~ /^zone_(.*)\.evc$/) {
							print "${fname}は型にはまりません。\n";
						} else {
							my ($area_name);

							$area_name = "\U$1\E";
							if (!exists($map{$area_name})) {
								print "${area_name}は対応するマップ名がありません。\n";
							} else {
								$trnr{$word}{area} = $map{$area_name};
							}
						}
					}
				}
			}
		}
		close EV;
	}

	for my $i (sort keys %trnr) {
		if (exists $trnr{$i}{area}) {
			my ($len);

			$len = length($trnr{$i}{jp}) + length($trnr{$i}{area});
			$len{$len}++;
			print "$i: $trnr{$i}{jp},$trnr{$i}{us},$trnr{$i}{area},$len\n";
		}
	}

	print "総文字長: 個数\n";
	for my $i (sort { $a <=> $b; } keys %len) {
		print sprintf("%2d: %2d\n", $i, $len{$i});
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.evc$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
