﻿use strict;
use utf8;

binmode(STDERR, "encoding(shiftjis)");

my @LANG = (
	{ src => "fra", dst => "LANG_FRANCE" },
	{ src => "ger", dst => "LANG_GERMANY" },
	{ src => "ita", dst => "LANG_ITALY" },
	{ src => "spa", dst => "LANG_SPAIN" }
);
my $SRC_PATH = "src/%s/font/shelter";
my $DST_PATH = "dst/%s";

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	for my $i (@LANG) {
		my ($src_path, $dst_path, $data, $res);

		$src_path = sprintf($SRC_PATH, $i->{src});
		$dst_path = sprintf($DST_PATH, $i->{dst});
		mkdir $dst_path;

		# フォントアーカイブを解凍。
		`..\\unarc\\unarc.pl $src_path/font.narc $src_path/arclist.txt $src_path`;

		# バイナリファイルを開く。
		if (!open(SRC, "$src_path/system.dat")) {
			die "$src_path/system.datが開けない。\n";
		}
		binmode(SRC, "raw");

		# フォントデータを取得、出力。
		$res = get_bin(\*SRC, \$data, 0x10, 0, 0x7f40);
		if ($res != 0x7f40) {
			die "フォントデータのサイズが異常。\n";
		}
		if (!open(DST, ">$dst_path/font_system.gly")) {
			die "$dst_path/font_system.glyが開けない。\n";
		}
		binmode(DST, "raw");
		print DST $data;
		close DST;

		# 幅データを取得、出力。
		$res = get_bin(\*SRC, \$data, 0x7f50, 0, 0x1fd);
		if ($res != 0x1fd) {
			die "フォント幅のサイズが異常。\n";
		}
		if (!open(DST, ">$dst_path/font_system.wid")) {
			die "$dst_path/font_system.widが開けない。\n";
		}
		binmode(DST, "raw");
		print DST $data;
		close DST;

		close SRC;
	}
}

#===========================================================
# バイナリ読み込み。
#===========================================================
sub get_bin {
	my ($hdl, $dst, $ofs, $bs, $size) = @_;
	my ($res);

	seek($hdl, $ofs, $bs);
	$res = read($hdl, ${$dst}, $size);
	return $res;
}
