﻿use strict;
use utf8;
use Win32::OLE qw(in with CP_UTF8);
use Win32::OLE::Const 'Microsoft Excel';
use Cwd;

$Win32::OLE::CP = CP_UTF8;

#***********************************************************
# パッケージxls
#***********************************************************
package xls;

my $excel;

#===========================================================
# エクセル開始。
#===========================================================
sub start {
	if (!$excel) {
		$excel = Win32::OLE->new('Excel.Application');
		if (!defined($excel)) {
			die "excelが開始できません。\n";
		}
		$excel->{DisplayAlerts} = 0;
	}
}

#===========================================================
# エクセル終了。
#===========================================================
sub end {
	if ($excel) {
		$excel->Quit();
		$excel = undef;
	}
}

#===========================================================
# オブジェクト生成。
#===========================================================
sub new {
	my ($class, $fname) = @_;

	bless {
		fname => $fname
	}, $class;
}

#===========================================================
# シート名取得。
#===========================================================
sub getSheetName {
	my ($self, $sheet_no) = @_;

	$self->open_book($sheet_no);

	return $self->{sheet}{$sheet_no}{Name};
}

#===========================================================
# データ取得。
#===========================================================
sub getData {
	my ($self, $sheet_no, $ccol, $crow) = @_;
	my ($range, $data, $row, $col);

	$self->open_book($sheet_no);

	$range = $self->{sheet}{$sheet_no}->Range("${ccol}65536")->End(::xlUp);
	$row = $range->{Row};
	$range = $self->{sheet}{$sheet_no}->Range("IV${crow}")->End(::xlToLeft);
	$col = $self->to_col_name($range->{Column});
	$data = $self->{sheet}{$sheet_no}->Range("$ccol$crow:$col$row")->{Value};
	for my $i (@{$data}) {
		for my $j (@{$i}) {
			$j = substr($j . 'あ', 0, length($j));
		}
	}

	return $data;
}

#===========================================================
# book保存。
#===========================================================
sub save {
	my ($self) = @_;

	$self->{book}->Save();
}

#===========================================================
# book別名に保存。
#===========================================================
sub saveAs {
	my ($self, $fname) = @_;
	my ($path);

	$path = ::getcwd();
	$self->{book}->SaveAs("$path/$fname");
}

#===========================================================
# エクセルを閉じる。
#===========================================================
sub close {
	my ($self) = @_;

	$self->{book}->Close();
}

#-----------------------------------------------------------
# private
#-----------------------------------------------------------

#===========================================================
# テキストノードを取得。
#===========================================================
sub open_book {
	my ($self, $sheet_no) = @_;

	if (!$self->{sheet}{$sheet_no}) {
		my $path;

		if ($self->{fname} =~ /^([A-Za-z]:|\/\/|\\\\)/) {
			$path = $self->{fname};
		} else {
			$path = ::getcwd();
			$path = "$path/$self->{fname}";
		}
		$self->{book} = $excel->Workbooks->Open($path);
		if (!defined($self->{book})) {
			die "bookが開けません。\n";
		}
		$self->{sheet}{$sheet_no} = $self->{book}->Worksheets($sheet_no);
		if (!defined($self->{sheet}{$sheet_no})) {
			die "sheetが取れません。\n";
		}
		$self->{sheet}{$sheet_no}->{FilterMode} = 0;
		$self->{sheet}{$sheet_no}->{AutoFilterMode} = 0;
	}
}

#===========================================================
# 列番号を列名に変換。
#===========================================================
sub to_col_name {
	my ($self, $no) = @_;
	my ($val);

	$val = 'A';
	for (1 .. $no - 1) {
		$val++;
	}
	return $val;
}

1;
