﻿use strict;
use XML::DOM;
use File::Find;
use utf8;

use gmm;

binmode(STDOUT, "encoding(shiftjis)");
binmode(STDERR, "encoding(shiftjis)");

main();
exit;

#-----------------------------------------------------------
# メイン処理。
#-----------------------------------------------------------
sub main {
	my ($gmm, $flist, %text);

	print "***get jp***\n";
	$flist = get_file_list("src");
	for my $i (@{$flist}) {
		my $gmm = new gmm($i);

		print "$i\n";
		for (my $iter = $gmm->newIter("LANG_JAPAN"); !$iter->over(); $iter->next()) {
			$text{$i}{$iter->getMsgId()} = $iter->getText();
		}
	}

	print "***set us***\n";
	$flist = get_file_list("src_us");
	for my $i (@{$flist}) {
		my $gmm = new gmm($i);

		print "$i\n";
		for (my $iter = $gmm->newIter("LANG_JAPAN"); !$iter->over(); $iter->next()) {
			my $fname = "src/" . $iter->getOrgFileName();
			my $msg_id = $iter->getMsgId();

			$fname =~ s/\\/\//g;
			$msg_id =~ s/^\d+-//;
			$iter->setText($text{$fname}{$msg_id});
		}
		$gmm->print($i);
	}
}

#-----------------------------------------------------------
# ファイルリスト取得。
#-----------------------------------------------------------
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.gmm$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
