#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#define	WID			(14)
#define	HEI			(20)
#define	X_NUM		(16)
#define	NUM(a)		(sizeof(a) / sizeof(*a))
#define	PART_NUM	(4)

#define	LT_X_SIZ	(6)
#define	LT_Y_SIZ	(5)
#define	LB_X_SIZ	(5)
#define	LB_Y_SIZ	(10 - LT_Y_SIZ)
#define	RT_X_SIZ	(10 - LT_X_SIZ)
#define	RT_Y_SIZ	(5)
#define	RB_X_SIZ	(10 - LB_X_SIZ)
#define	RB_Y_SIZ	(10 - RT_Y_SIZ)

struct REGION {
	int		s;
	int		e;
};
struct PART_INFO {
	int		p[PART_NUM];
};
struct PART_SIZE {
	int		x;
	int		y;
};

static const REGION		region_all[] = {
	{ 60 * X_NUM - 1, 207 * X_NUM - 3 },
	{ 207 * X_NUM, 209 * X_NUM + 1 },
	{ 210 * X_NUM, 210 * X_NUM + 5 },
};
static const PART_SIZE	part_size[] = {
	{ LT_X_SIZ, LT_Y_SIZ },
	{ LB_X_SIZ, LB_Y_SIZ },
	{ RT_X_SIZ, RT_Y_SIZ },
	{ RB_X_SIZ, RB_Y_SIZ }
};

typedef Graphics::TBitmap TBITMAP;

static int read_bitmap(const char *in_file, TBITMAP **dst);
static TBITMAP *create_bitmap(int wid, int hei);
static int make_hangul_only(int **src_id, const REGION *reg, int num);
static void to_rect(RECT *r, int id);
static void to_rect_lt(RECT *p, const RECT *r);
static void to_rect_lb(RECT *p, const RECT *r);
static void to_rect_rt(RECT *p, const RECT *r);
static void to_rect_rb(RECT *p, const RECT *r);
static TBITMAP *create_part(TBITMAP *src, RECT *r);
static int add_list(TList *lst, TBITMAP *bmp, int *id);
static void divide(TList **lst, PART_INFO *pi, TBITMAP *src, int num);
static void output(TList **lst, const PART_INFO *pi, int num, const char *out_file);

#pragma argsused
int main(int argc, char* argv[])
{
	TList		*lst[PART_NUM];
	TBITMAP		*bmp;
	int			num;
	PART_INFO	*part_info;

	if (argc != 3) {
		printf("܂B\n");
		exit(1);
	}
	num = read_bitmap(argv[1], &bmp);

	bmp->SaveToFile("check.bmp");

	part_info = new PART_INFO[num];
	divide(lst, part_info, bmp, num);
	delete bmp;
	output(lst, part_info, num, argv[2]);
	for (int i = 0; i < PART_NUM; i++) {
		delete lst[i];
	}

	return 0;
}

static int read_bitmap(const char *in_file, TBITMAP **dst)
{
	TBITMAP		*src;
	int			*src_id;
	int			num;

	num = make_hangul_only(&src_id, region_all, NUM(region_all));
	src = new TBITMAP();
	*dst = create_bitmap(X_NUM * WID, 0);
	src->LoadFromFile(in_file);
	(*dst)->Height = 0;
	for (int i = 0; i < num; i++) {
		RECT	src_r, dst_r;

		if (i % X_NUM == 0) {
			(*dst)->Height += HEI;
		}
		to_rect(&src_r, src_id[i]);
		to_rect(&dst_r, i);
		(*dst)->Canvas->CopyRect(dst_r, src->Canvas, src_r);
	}
	return num;
}

static TBITMAP *create_bitmap(int wid, int hei)
{
	TBITMAP		*res;

	res = new TBITMAP();
	res->PixelFormat = pf8bit;
	res->Width = wid;
	res->Height = hei;
	return res;
}

static int make_hangul_only(int **src_id, const REGION *reg, int num)
{
	int		n;
	int		*res;

	n = 0;
	for (int i = 0; i < num; i++) {
		const REGION		*p = &reg[i];

		n += p->e - p->s;
	}
	res = new int[n];
	n = 0;
	for (int i = 0; i < num; i++) {
		const REGION		*p = &reg[i];

		for (int j = p->s; j < p->e; j++) {
			res[n++] = j;
		}
	}
	*src_id = res;
	return n;
}

static void to_rect(RECT *r, int id)
{
	r->left = (id % X_NUM) * WID;
	r->top = (id / X_NUM) * HEI;
	r->right = r->left + WID;
	r->bottom = r->top + HEI;
}

static void to_rect_lt(RECT *p, const RECT *r)
{
	p->left = r->left + 2;
	p->top = r->top + 4;
}

static void to_rect_lb(RECT *p, const RECT *r)
{
	p->left = r->left + 2;
	p->top = r->top + 4 + LT_Y_SIZ;
}

static void to_rect_rt(RECT *p, const RECT *r)
{
	p->left = r->left + 2 + LT_X_SIZ;
	p->top = r->top + 4;
}

static void to_rect_rb(RECT *p, const RECT *r)
{
	p->left = r->left + 2 + LB_X_SIZ;
	p->top = r->top + 4 + RT_Y_SIZ;
}

static TBITMAP *create_part(TBITMAP *src, RECT *r)
{
	TBITMAP		*bmp;
	RECT		dst;
	int			wid, hei;

	wid = r->right - r->left;
	hei = r->bottom - r->top;
	bmp = create_bitmap(wid, hei);
	dst.left = 0;
	dst.top = 0;
	dst.right = wid;
	dst.bottom = hei;
	bmp->Canvas->CopyRect(dst, src->Canvas, *r);
	return bmp;
}

static int add_list(TList *lst, TBITMAP *bmp, int *id)
{
	*id = -1;
	for (int i = 0; i < lst->Count; i++) {
		TBITMAP		*p;
		int			diff = 0;

		p = (TBITMAP *)lst->Items[i];
		for (int j = 0; j < bmp->Height; j++) {
			unsigned char *c1 = (unsigned char *)bmp->ScanLine[j];
			unsigned char *c2 = (unsigned char *)p->ScanLine[j];

			for (int k = 0; k < bmp->Width; k++) {
				if (c1[k] != c2[k]) {
					diff = 1;
					break;
				}
			}
			if (diff) {
				break;
			}
		}
		if (!diff) {
			*id = i;
			break;
		}
	}
	if (*id == -1) {
		lst->Add(bmp);
		*id = lst->Count - 1;
		return 1;
	}
	return 0;
}

static void divide(TList **lst, PART_INFO *pi, TBITMAP *src, int num)
{
	const struct PART {
		const char	*name;
		void		(*func)(RECT *, const RECT *);
	}			part[] = {
		{ "", to_rect_lt },
		{ "", to_rect_lb },
		{ "E", to_rect_rt },
		{ "E", to_rect_rb }
	};
	int			pix_num;

	for (int i = 0; i < PART_NUM; i++) {
		lst[i] = new TList();
	}
	for (int i = 0; i < num; i++) {
		RECT		r, src_r;
		TBITMAP		*bmp;

		to_rect(&r, i);
		for (int j = 0; j < PART_NUM; j++) {
			const PART	*p = &part[j];
			int			id;

			p->func(&src_r, &r);
			src_r.right = src_r.left + part_size[j].x;
			src_r.bottom = src_r.top + part_size[j].y;
			bmp = create_part(src, &src_r);
			if (!add_list(lst[j], bmp, &id)) {
				delete bmp;
			}
			pi[i].p[j] = id;
		}
	}
	pix_num = 0;
	for (int i = 0; i < PART_NUM; i++) {
		const PART	*p = &part[i];

		printf("%s(%d, %d): count = %d\n", p->name,
			part_size[i].x, part_size[i].y, lst[i]->Count);
		pix_num += lst[i]->Count * part_size[i].x * part_size[i].y;
	}
	printf("num = %d\n", num);
	printf("total pixel = %d\n", pix_num);
}

static void output(TList **lst, const PART_INFO *pi, int num, const char *out_file)
{
	int		d = 0, bit = 0, l_num = 0;
	FILE	*fp;

	fp = fopen(out_file, "wt");
	if (fp == NULL) {
		printf("t@CJ܂B\n");
		exit(1);
	}

	fprintf(fp, "%d\n\n", num);
	for (int i = 0; i < num; i++) {
		fprintf(fp, "( ");
		for (int j = 0; j < PART_NUM; j++) {
			fprintf(fp, "%3d", pi[i].p[j]);
			if (j != PART_NUM - 1) {
				fprintf(fp, ",");
			}
		}
		fprintf(fp, " ), ");
		l_num++;
		if (l_num == 4) {
			fprintf(fp, "\n");
			l_num = 0;
		}
	}
	if (l_num != 0) {
		fprintf(fp, "\n");
	}
	fprintf(fp, "\n");

	for (int i = 0; i < PART_NUM; i++) {
		fprintf(fp, "%d,( %d,%d )\n", lst[i]->Count, part_size[i].x, part_size[i].y);
	}
	fprintf(fp, "\n");

	l_num = 0;
	for (int i = 0; i < PART_NUM; i++) {
		for (int j = 0; j < lst[i]->Count; j++) {
			TBITMAP		*bmp = (TBITMAP *)lst[i]->Items[j];

			for (int k = 0; k < bmp->Height; k++) {
				unsigned char *c = (unsigned char *)bmp->ScanLine[k];

				for (int m = 0; m < bmp->Width; m++) {
					if (c[m] == 0) {
						d |= 1 << bit;
					} else if (c[m] != 0xff) {
						printf("FςłB\n");
						exit(1);
					}
					bit++;
					if (bit == 8) {
						fprintf(fp, "%02x,", d);
						d = 0;
						bit = 0;
						l_num++;
						if (l_num == 16) {
							fprintf(fp, "\n");
							l_num = 0;
						}
					}
				}
			}
		}
	}
	if (bit != 0) {
		fprintf(fp, "%02x,", d);
		l_num++;
		if (l_num == 16) {
			fprintf(fp, "\n");
			l_num = 0;
		}
	}
	if (l_num != 0) {
		fprintf(fp, "\n");
	}

	fclose(fp);
}
