#include <vcl.h>
#include <stdio.h>
#pragma hdrstop

#define	WID			(14)
#define	HEI			(20)
#define	X_NUM		(16)

enum {
	PART_LT = 0,
	PART_LB,
	PART_RT,
	PART_RB,
	PART_NUM
};

struct PART_INFO {
	int		p[PART_NUM];
};
struct PART_SIZE {
	int		x;
	int		y;
};

typedef Graphics::TBitmap TBITMAP;

static void read_info(const char *in_file, PART_INFO **pi,
	int *num, TList **lst);
static TBITMAP *create_bitmap(int wid, int hei);
static void to_rect(RECT *r, int id);
static void to_rect_lt(RECT *p, const RECT *r, const PART_SIZE *ps);
static void to_rect_lb(RECT *p, const RECT *r, const PART_SIZE *ps);
static void to_rect_rt(RECT *p, const RECT *r, const PART_SIZE *ps);
static void to_rect_rb(RECT *p, const RECT *r, const PART_SIZE *ps);
static TBITMAP *create_out_bitmap(int num);
static void output_hangul(const PART_INFO *pi, int num, TList **lst, TBITMAP *bmp);

#pragma argsused
int main(int argc, char* argv[])
{
	TList		*lst[PART_NUM];
	int			num;
	PART_INFO	*part_info;
	TBITMAP		*bmp;

	if (argc != 3) {
		printf("܂B\n");
		exit(1);
	}
	read_info(argv[1], &part_info, &num, lst);
	bmp = create_out_bitmap(num);
	output_hangul(part_info, num, lst, bmp);

// 킴ƈvȂ悤ɂĂ݂`FbNpB
#if 0
	((unsigned char *)bmp->ScanLine[HEI * 3])[WID * 3] = 0xff;
#endif

	bmp->SaveToFile(argv[2]);

	return 0;
}

static void read_info(const char *in_file, PART_INFO **pi,
	int *num, TList **lst)
{
	FILE		*fp;
	char		buf[256];
	PART_SIZE	ps[PART_NUM];
	int			n[PART_NUM];
	int			d, bit = 0;

	fp = fopen(in_file, "rt");
	if (fp == NULL) {
		printf("t@CJ܂B\n");
		exit(1);
	}
	fscanf(fp, "%d", num);
	*pi = new PART_INFO[*num];
	for (int i = 0; i < *num; i++) {
		PART_INFO	*p = &(*pi)[i];
		char		dum[256];

		fscanf(fp, "%s%d,%d,%d,%d%s", dum, &p->p[0], &p->p[1], &p->p[2], &p->p[3], dum);
	}
	for (int i = 0; i < PART_NUM; i++) {
		char	dum[256];

		fscanf(fp, "%d%s%d,%d%s", &n[i], dum, &ps[i].x, &ps[i].y, dum);
	}
	for (int i = 0; i < PART_NUM; i++) {
		lst[i] = new TList();
		for (int j = 0; j < n[i]; j++) {
			TBITMAP		*bmp;

			bmp = create_bitmap(ps[i].x, ps[i].y);
			for (int k = 0; k < ps[i].y; k++) {
				unsigned char *c = (unsigned char *)bmp->ScanLine[k];

				for (int m = 0; m < bmp->Width; m++) {
					if (bit == 0) {
						fscanf(fp, "%x,", &d);
					}
					if (d & (1 << bit)) {
						c[m] = 0;
					} else {
						c[m] = 0xff;
					}
					bit++;
					if (bit == 8) {
						bit = 0;
					}
				}
			}
			lst[i]->Add(bmp);
		}
	}
	fclose(fp);
}

static TBITMAP *create_bitmap(int wid, int hei)
{
	TBITMAP		*res;

	res = new TBITMAP();
	res->PixelFormat = pf8bit;
	res->Width = wid;
	res->Height = hei;
	return res;
}

static void to_rect(RECT *r, int id)
{
	r->left = (id % X_NUM) * WID;
	r->top = (id / X_NUM) * HEI;
	r->right = r->left + WID;
	r->bottom = r->top + HEI;
}

static void to_rect_lt(RECT *p, const RECT *r, const PART_SIZE *ps)
{
	p->left = r->left + 2;
	p->top = r->top + 4;
}

static void to_rect_lb(RECT *p, const RECT *r, const PART_SIZE *ps)
{
	p->left = r->left + 2;
	p->top = r->top + 4 + ps[PART_LT].y;
}

static void to_rect_rt(RECT *p, const RECT *r, const PART_SIZE *ps)
{
	p->left = r->left + 2 + ps[PART_LT].x;
	p->top = r->top + 4;
}

static void to_rect_rb(RECT *p, const RECT *r, const PART_SIZE *ps)
{
	p->left = r->left + 2 + ps[PART_LB].x;
	p->top = r->top + 4 + ps[PART_RT].y;
}

static TBITMAP *create_out_bitmap(int num)
{
	TBITMAP		*bmp, *frm;
	RECT		src;

	bmp = create_bitmap(X_NUM * WID, ((num - 1) / X_NUM + 1) * HEI);
	frm = create_bitmap(0, 0);
	frm->LoadFromFile("frame.bmp");
	src.left = 0;
	src.top = 0;
	src.right = WID;
	src.bottom = HEI;
	for (int i = 0; i < num; i++) {
		RECT	dst;

		to_rect(&dst, i);
		bmp->Canvas->CopyRect(dst, frm->Canvas, src);
	}
	return bmp;
}

static void output_hangul(const PART_INFO *pi, int num, TList **lst, TBITMAP *bmp)
{
	const struct PART {
		const char	*name;
		void		(*func)(RECT *, const RECT *, const PART_SIZE *);
	}			part[] = {
		{ "", to_rect_lt },
		{ "", to_rect_lb },
		{ "E", to_rect_rt },
		{ "E", to_rect_rb }
	};
	PART_SIZE	ps[PART_NUM];
	RECT		src_r[PART_NUM];

	for (int i = 0; i < PART_NUM; i++) {
		TBITMAP		*b = (TBITMAP *)lst[i]->Items[0];

		ps[i].x = b->Width;
		ps[i].y = b->Height;
		src_r[i].left = src_r[i].top = 0;
		src_r[i].right = ps[i].x;
		src_r[i].bottom = ps[i].y;
	}
	for (int i = 0; i < num; i++) {
		RECT		r;

		to_rect(&r, i);
		for (int j = 0; j < PART_NUM; j++) {
			const PART	*p = &part[j];
			RECT		dst_r;
			TBITMAP		*src = (TBITMAP *)lst[j]->Items[pi[i].p[j]];

			p->func(&dst_r, &r, ps);
			dst_r.right = dst_r.left + ps[j].x;
			dst_r.bottom = dst_r.top + ps[j].y;
			bmp->Canvas->CopyRect(dst_r, src->Canvas, src_r[j]);
		}
	}
}
