﻿use strict;
use File::Find;
use utf8;
use gmm;

binmode STDERR, "encoding(shiftjis)";

my $gbl;

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my ($flist, $exe, $lang, $no_save);

	# utf8のBOM。
	print "\x{ef}\x{bb}\x{bf}";
	binmode STDOUT, "utf8";

	if (@ARGV == 0) {
		die "引数の数がおかしい。\n";
	}
	if ($ARGV[0] eq "-ns") {
		$no_save = 1;
		shift @ARGV;
	}
	if (!(1 <= @ARGV && @ARGV <= 2)) {
		die "引数の数がおかしい。\n";
	}
	{
		my ($exename, @lines, $dum);

		$exename = shift @ARGV;
		if (@ARGV) {
			$lang = shift @ARGV;
		} else {
			$lang = "LANG_ENGLISH";
		}
		if (!open(EXE, $exename)) {
			die "${exename}が開けません。";
		}
		binmode EXE, "raw";
		read(EXE, $dum, 3);
		binmode EXE, "utf8";
		@lines = <EXE>;
		close EXE;
		$exe = join "", @lines;
	}

	$flist = get_file_list("src");
	for my $i (@{$flist}) {
		my $gmm = new gmm($i);

		print STDERR "===$i===\n";

		for (my $iter = $gmm->newIter("LANG_JAPAN"); !$iter->over(); $iter->next()) {
			my (%data);

			$data{msg_id} = $iter->getMsgId();
			$data{back_col} = $iter->getBackColor();
			$data{text_jp} = $iter->getText();
			$data{text_us} = $iter->getText("LANG_ENGLISH");
			$data{text_ko} = $iter->getText("LANG_KOREA");
			$data{text} = $iter->getText($lang);
			$data{cmt_us} = $iter->getCommentEnglish();
			$data{cmt_add} = $iter->getCommentAdd();
			$data{scroll} = $iter->getScroll();
			$data{win_con} = $iter->getWindowContext();
			$data{need_wait} = $iter->getNeedWait();
			$data{use_tag_list} = $iter->getUseTagList();
			$data{org_file} = $iter->getOrgFile();
			$data{font} = $iter->getFontName($lang);
			if ($data{font} eq "") {
				$data{font} = " 0:font_talk";
			}

			eval $exe;
			if ($@) {
				die;
			}
		}
		if (!$no_save) {
			$gmm->print($i);
		}
		$gmm->delete();
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.gmm$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
