﻿use strict;
use File::Find;
use utf8;
require "../xlsdiff/xls.pm";

binmode(STDOUT, "utf8");
binmode(STDERR, "encoding(shiftjis)");

my %xls_info = (
	"src/DP_Areanames.xls" => {
		name => "xls/DP_Areanames_comment.xls", col => "H", col_src => "G"
	}, "src/DP_Characters.xls" => {
		name => "xls/DP_Characters_comment.xls", col => "H", col_src => "G"
	}
);

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	my ($f_list, %col_num);

	$f_list = get_file_list("src");
	{
		my ($ltr, $idx) = ( 'A', 0 );

		for my $i (1 .. 100) {
			$col_num{$ltr} = $idx;
			$ltr++;
			$idx++;
		}
	}

	for my $i (@{$f_list}) {

		print STDERR "===$i===\n";

		if ($xls_info{$i}) {
			my ($c_msg_id, $c_cmt, $c_cmt_src);
			my ($xls, $data, %cmt);

			$c_msg_id = $col_num{"A"};
			$c_cmt = $col_num{$xls_info{$i}{col}};
			$c_cmt_src = $col_num{$xls_info{$i}{col_src}};

			$xls = new xls($xls_info{$i}{name});
			$data = $xls->getData('Z');
			for my $j (@{$data}[1 .. $#{$data}]) {
				if ($j->[$c_cmt_src]) {
					$cmt{$j->[$c_msg_id]} = $j->[$c_cmt_src];
				}
			}

			$xls = new xls($i);
			$data = $xls->getData("Z");
			for my $j (@{$data}[1 .. $#{$data}]) {
				if ($cmt{$j->[$c_msg_id]}) {
					$j->[$c_cmt] = $cmt{$j->[$c_msg_id]};

					delete $cmt{$j->[$c_msg_id]};
					if (scalar(keys %cmt) == 0) {
						print "$i が終了。\n";
					}
				}
			}
			$xls->setData('Z', $data);
			$xls->Save();
		}
	}
}

#===========================================================
# ファイルリスト取得。
#===========================================================
sub get_file_list {
	my ($dir) = @_;
	my $sub;
	my @list;

	$sub = sub {
		if ($File::Find::name =~ /\.xls$/) {
			push @list, $File::Find::name;
		}
	};
	find($sub, $dir);
	return \@list;
}
