use strict;
use utf8;
use Win32::Process;
use Win32::Clipboard;
use Win32::OLE qw(in with CP_UTF8);
use Win32::OLE::Const 'Microsoft Excel';

$Win32::OLE::CP = CP_UTF8;

binmode STDOUT, "encoding(shiftjis)";
binmode STDERR, "encoding(shiftjis)";

main();
exit;

#===========================================================
# メイン処理。
#===========================================================
sub main {
	Win32::Clipboard()->Set($ARGV[0]);

	if ($ARGV[1] eq "gmm") {
		my ($prc, $cmd);

		$cmd = "\"$ARGV[2]\" \"$ARGV[3]\"";
		Win32::Process::Create($prc, $ARGV[2], $cmd, 0, DETACHED_PROCESS, ".");
	} else {
		my ($excel, $book);

		$excel = Win32::OLE->GetActiveObject('Excel.Application');
		if (!$excel) {
			$excel = Win32::OLE->new('Excel.Application');
		}
		if ($excel) {
			$excel->{Visible} = 1;
			$ARGV[2] =~ /[\\\/]?([^\\\/]+)$/;
			$book = $excel->Workbooks->Item($1);
			if (defined($book)) {
				$book->Activate();
			} else {
				$excel->Workbooks->Open($ARGV[2]);
			}
		}
	}
}
